/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.httpserver;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.glassfish.jersey.netty.httpserver.NettyHttpContainer;
import org.glassfish.jersey.netty.httpserver.NettyResponseWriter;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

class NettyHttp2ResponseWriter
implements ContainerResponseWriter {
    private final ChannelHandlerContext ctx;
    private final Http2HeadersFrame headersFrame;
    private final NettyHttpContainer container;
    private volatile ScheduledFuture<?> suspendTimeoutFuture;
    private volatile Runnable suspendTimeoutHandler;

    NettyHttp2ResponseWriter(ChannelHandlerContext ctx, Http2HeadersFrame headersFrame, NettyHttpContainer container) {
        this.ctx = ctx;
        this.headersFrame = headersFrame;
        this.container = container;
    }

    public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse responseContext) throws ContainerException {
        String reasonPhrase = responseContext.getStatusInfo().getReasonPhrase();
        int statusCode = responseContext.getStatus();
        HttpResponseStatus status = reasonPhrase == null ? HttpResponseStatus.valueOf((int)statusCode) : new HttpResponseStatus(statusCode, reasonPhrase);
        DefaultHttp2Headers response = new DefaultHttp2Headers();
        response.status((CharSequence)Integer.toString(responseContext.getStatus()));
        for (Map.Entry e : responseContext.getStringHeaders().entrySet()) {
            response.add((Object)((String)e.getKey()).toLowerCase(Locale.ROOT), (Iterable)e.getValue());
        }
        response.set((Object)HttpHeaderNames.CONTENT_LENGTH, (Object)Long.toString(contentLength));
        this.ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)response));
        if (!(this.headersFrame.headers().method().equals(HttpMethod.HEAD.asciiName()) || contentLength <= 0L && contentLength != -1L)) {
            return new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    this.write(new byte[]{(byte)b});
                }

                @Override
                public void write(byte[] b) throws IOException {
                    this.write(b, 0, b.length);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    ByteBuf buffer = NettyHttp2ResponseWriter.this.ctx.alloc().buffer(len);
                    buffer.writeBytes(b, off, len);
                    NettyHttp2ResponseWriter.this.ctx.writeAndFlush((Object)new DefaultHttp2DataFrame(buffer, false));
                }

                @Override
                public void flush() throws IOException {
                    NettyHttp2ResponseWriter.this.ctx.flush();
                }

                @Override
                public void close() throws IOException {
                    NettyHttp2ResponseWriter.this.ctx.write((Object)new DefaultHttp2DataFrame(true)).addListener((GenericFutureListener)NettyResponseWriter.FLUSH_FUTURE);
                }
            };
        }
        this.ctx.writeAndFlush((Object)new DefaultHttp2DataFrame(true));
        return null;
    }

    public boolean suspend(long timeOut, TimeUnit timeUnit, final ContainerResponseWriter.TimeoutHandler timeoutHandler) {
        this.suspendTimeoutHandler = new Runnable(){

            @Override
            public void run() {
                timeoutHandler.onTimeout((ContainerResponseWriter)NettyHttp2ResponseWriter.this);
            }
        };
        if (timeOut <= 0L) {
            return true;
        }
        this.suspendTimeoutFuture = this.container.getScheduledExecutorService().schedule(this.suspendTimeoutHandler, timeOut, timeUnit);
        return true;
    }

    public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
        if (this.suspendTimeoutFuture != null) {
            this.suspendTimeoutFuture.cancel(true);
        }
        if (timeOut <= 0L) {
            return;
        }
        this.suspendTimeoutFuture = this.container.getScheduledExecutorService().schedule(this.suspendTimeoutHandler, timeOut, timeUnit);
    }

    public void commit() {
        this.ctx.flush();
    }

    public void failure(Throwable error) {
        this.ctx.writeAndFlush((Object)new DefaultHttp2Headers().status((CharSequence)HttpResponseStatus.INTERNAL_SERVER_ERROR.codeAsText())).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public boolean enableResponseBuffering() {
        return true;
    }
}

