/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.httpserver;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.AsciiString;
import java.net.URI;
import org.glassfish.jersey.netty.httpserver.HttpVersionChooser;
import org.glassfish.jersey.netty.httpserver.JerseyHttp2ServerHandler;
import org.glassfish.jersey.netty.httpserver.JerseyServerHandler;
import org.glassfish.jersey.netty.httpserver.NettyHttpContainer;
import org.glassfish.jersey.server.ResourceConfig;

class JerseyServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final URI baseUri;
    private final String applicationPath;
    private final SslContext sslCtx;
    private final NettyHttpContainer container;
    private final boolean http2;
    private final ResourceConfig resourceConfig;

    public JerseyServerInitializer(URI baseUri, SslContext sslCtx, NettyHttpContainer container, ResourceConfig resourceConfig) {
        this(baseUri, sslCtx, container, resourceConfig, false);
    }

    public JerseyServerInitializer(URI baseUri, SslContext sslCtx, NettyHttpContainer container, ResourceConfig resourceConfig, boolean http2) {
        this.applicationPath = container.getApplicationHandler().getConfiguration().getApplicationPath();
        String uriPath = this.applicationPath == null ? baseUri.toString() : baseUri.toString() + "/" + this.applicationPath + "/";
        int doubleSlash = uriPath.indexOf("/") + 2;
        String path = uriPath.substring(0, doubleSlash) + uriPath.substring(doubleSlash).replaceAll("/{2,}", "/");
        this.baseUri = URI.create(path);
        this.sslCtx = sslCtx;
        this.container = container;
        this.resourceConfig = resourceConfig;
        this.http2 = http2;
    }

    public void initChannel(SocketChannel ch) {
        if (this.http2) {
            if (this.sslCtx != null) {
                this.configureSsl(ch);
            } else {
                this.configureClearText(ch);
            }
        } else {
            ChannelPipeline p = ch.pipeline();
            if (this.sslCtx != null) {
                p.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
            }
            p.addLast(new ChannelHandler[]{new HttpServerCodec()});
            p.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
            p.addLast(new ChannelHandler[]{new JerseyServerHandler(this.baseUri, this.applicationPath, this.container, this.resourceConfig)});
        }
    }

    private void configureSsl(SocketChannel ch) {
        ch.pipeline().addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc()), new HttpVersionChooser(this.baseUri, this.container, this.resourceConfig)});
    }

    private void configureClearText(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        HttpServerCodec sourceCodec = new HttpServerCodec();
        p.addLast(new ChannelHandler[]{sourceCodec});
        p.addLast(new ChannelHandler[]{new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, new HttpServerUpgradeHandler.UpgradeCodecFactory(){

            public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
                if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                    return new Http2ServerUpgradeCodec(Http2MultiplexCodecBuilder.forServer((ChannelHandler)new JerseyHttp2ServerHandler(JerseyServerInitializer.this.baseUri, JerseyServerInitializer.this.container, JerseyServerInitializer.this.resourceConfig)).build());
                }
                return null;
            }
        })});
        p.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<HttpMessage>(){

            protected void channelRead0(ChannelHandlerContext ctx, HttpMessage msg) throws Exception {
                ChannelPipeline pipeline = ctx.pipeline();
                ChannelHandlerContext thisCtx = pipeline.context((ChannelHandler)this);
                pipeline.addAfter(thisCtx.name(), null, (ChannelHandler)new JerseyServerHandler(JerseyServerInitializer.this.baseUri, JerseyServerInitializer.this.container, JerseyServerInitializer.this.resourceConfig));
                pipeline.replace((ChannelHandler)this, null, (ChannelHandler)new ChunkedWriteHandler());
                ctx.fireChannelRead((Object)msg);
            }
        }});
    }
}

