/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.httpserver;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.netty.connector.internal.NettyInputStream;
import org.glassfish.jersey.netty.httpserver.NettyHttp2ResponseWriter;
import org.glassfish.jersey.netty.httpserver.NettyHttpContainer;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.internal.ContainerUtils;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

@ChannelHandler.Sharable
class JerseyHttp2ServerHandler
extends ChannelDuplexHandler {
    private final URI baseUri;
    private final NettyInputStream nettyInputStream = new NettyInputStream();
    private final NettyHttpContainer container;
    private final ResourceConfig resourceConfig;

    JerseyHttp2ServerHandler(URI baseUri, NettyHttpContainer container, ResourceConfig resourceConfig) {
        this.baseUri = baseUri;
        this.container = container;
        this.resourceConfig = resourceConfig;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ctx.close();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2HeadersFrame) {
            this.onHeadersRead(ctx, (Http2HeadersFrame)msg);
        } else if (msg instanceof Http2DataFrame) {
            this.onDataRead(ctx, (Http2DataFrame)msg);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    private void onDataRead(ChannelHandlerContext ctx, Http2DataFrame data) throws Exception {
        this.nettyInputStream.publish(data.content());
        if (data.isEndStream()) {
            this.nettyInputStream.complete(null);
        }
    }

    private void onHeadersRead(ChannelHandlerContext ctx, Http2HeadersFrame headers) throws Exception {
        final ContainerRequest requestContext = this.createContainerRequest(ctx, headers);
        requestContext.setWriter((ContainerResponseWriter)new NettyHttp2ResponseWriter(ctx, headers, this.container));
        this.container.getExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                JerseyHttp2ServerHandler.this.container.getApplicationHandler().handle(requestContext);
            }
        });
    }

    private ContainerRequest createContainerRequest(ChannelHandlerContext ctx, Http2HeadersFrame http2Headers) {
        String path = http2Headers.headers().path().toString();
        String s = path.startsWith("/") ? path.substring(1) : path;
        URI requestUri = URI.create(this.baseUri + ContainerUtils.encodeUnsafeCharacters((String)s));
        ContainerRequest requestContext = new ContainerRequest(this.baseUri, requestUri, http2Headers.headers().method().toString(), this.getSecurityContext(), new PropertiesDelegate(){
            private final Map<String, Object> properties = new HashMap<String, Object>();

            public Object getProperty(String name) {
                return this.properties.get(name);
            }

            public Collection<String> getPropertyNames() {
                return this.properties.keySet();
            }

            public void setProperty(String name, Object object) {
                this.properties.put(name, object);
            }

            public void removeProperty(String name) {
                this.properties.remove(name);
            }
        }, (Configuration)this.resourceConfig);
        if (!http2Headers.isEndStream()) {
            ctx.channel().closeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

                public void operationComplete(Future<? super Void> future) throws Exception {
                    JerseyHttp2ServerHandler.this.nettyInputStream.complete(future.cause());
                }
            });
            requestContext.setEntityStream((InputStream)this.nettyInputStream);
        } else {
            requestContext.setEntityStream(new InputStream(){

                @Override
                public int read() throws IOException {
                    return -1;
                }
            });
        }
        for (CharSequence name : http2Headers.headers().names()) {
            requestContext.headers(name.toString(), this.mapToString(http2Headers.headers().getAll((Object)name)));
        }
        return requestContext;
    }

    private List<String> mapToString(List<CharSequence> list) {
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (CharSequence sequence : list) {
            result.add(sequence.toString());
        }
        return result;
    }

    private SecurityContext getSecurityContext() {
        return new SecurityContext(){

            public boolean isUserInRole(String role) {
                return false;
            }

            public boolean isSecure() {
                return false;
            }

            public Principal getUserPrincipal() {
                return null;
            }

            public String getAuthenticationScheme() {
                return null;
            }
        };
    }
}

