/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jetty;

import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.core.Application;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.jetty.JettyHttpContainer;
import org.glassfish.jersey.jetty.JettyHttpContainerFactory;
import org.glassfish.jersey.server.ContainerFactory;
import org.glassfish.jersey.server.JerseySeBootstrapConfiguration;
import org.glassfish.jersey.server.spi.WebServer;

final class JettyHttpServer
implements WebServer {
    private final JettyHttpContainer container;
    private final Server httpServer;

    JettyHttpServer(Application application, JerseySeBootstrapConfiguration configuration) {
        this((JettyHttpContainer)((Object)ContainerFactory.createContainer(JettyHttpContainer.class, (Application)application)), configuration);
    }

    JettyHttpServer(Class<? extends Application> applicationClass, JerseySeBootstrapConfiguration configuration) {
        this(new JettyHttpContainer(applicationClass), configuration);
    }

    JettyHttpServer(JettyHttpContainer container, JerseySeBootstrapConfiguration configuration) {
        SslContextFactory.Server sslContextFactory;
        SeBootstrap.Configuration.SSLClientAuthentication sslClientAuthentication = configuration.sslClientAuthentication();
        if (configuration.isHttps()) {
            sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setSslContext(configuration.sslContext());
            sslContextFactory.setWantClientAuth(sslClientAuthentication == SeBootstrap.Configuration.SSLClientAuthentication.OPTIONAL);
            sslContextFactory.setNeedClientAuth(sslClientAuthentication == SeBootstrap.Configuration.SSLClientAuthentication.MANDATORY);
        } else {
            sslContextFactory = null;
        }
        this.container = container;
        this.httpServer = JettyHttpContainerFactory.createServer(configuration.uri(true), sslContextFactory, this.container, configuration.autoStart());
    }

    public final JettyHttpContainer container() {
        return this.container;
    }

    public final int port() {
        ServerConnector serverConnector = (ServerConnector)this.httpServer.getConnectors()[0];
        int configuredPort = serverConnector.getPort();
        int localPort = serverConnector.getLocalPort();
        return localPort < 0 ? configuredPort : localPort;
    }

    public final CompletableFuture<Void> start() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.httpServer.start();
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    public final CompletableFuture<Void> stop() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.httpServer.stop();
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    public final <T> T unwrap(Class<T> nativeClass) {
        return nativeClass.cast(this.httpServer);
    }
}

