/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.txw2.builder.xsd;

import com.sun.codemodel.JType;
import com.sun.tools.txw2.TxwOptions;
import com.sun.tools.txw2.builder.relaxng.DatatypeFactory;
import com.sun.tools.txw2.model.Attribute;
import com.sun.tools.txw2.model.Data;
import com.sun.tools.txw2.model.Define;
import com.sun.tools.txw2.model.Element;
import com.sun.tools.txw2.model.Empty;
import com.sun.tools.txw2.model.Grammar;
import com.sun.tools.txw2.model.Leaf;
import com.sun.tools.txw2.model.List;
import com.sun.tools.txw2.model.NodeSet;
import com.sun.tools.txw2.model.Ref;
import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSAttContainer;
import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSDeclaration;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSIdentityConstraint;
import com.sun.xml.xsom.XSListSimpleType;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSNotation;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.XSUnionSimpleType;
import com.sun.xml.xsom.XSWildcard;
import com.sun.xml.xsom.XSXPath;
import com.sun.xml.xsom.visitor.XSFunction;
import com.sun.xml.xsom.visitor.XSSimpleTypeFunction;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public final class XmlSchemaBuilder
implements XSFunction<Leaf>,
XSSimpleTypeFunction<Leaf> {
    protected final XSSchemaSet schemaSet;
    protected final NodeSet nodeSet;
    private final DatatypeFactory dtf;
    private final Map<XSModelGroupDecl, Define> modelGroups = new HashMap<XSModelGroupDecl, Define>();
    private final Map<XSComplexType, Define> complexTypes = new HashMap<XSComplexType, Define>();
    private final Map<XSAttGroupDecl, Define> attGroups = new HashMap<XSAttGroupDecl, Define>();
    private final Grammar grammar = new Grammar();

    public static NodeSet build(XSSchemaSet xs, TxwOptions opts) {
        XmlSchemaBuilder builder = new XmlSchemaBuilder(xs, opts);
        builder.build(xs);
        return builder.nodeSet;
    }

    private void build(XSSchemaSet xs) {
        for (XSSchema s : xs.getSchemas()) {
            for (XSComplexType t : s.getComplexTypes().values()) {
                t.apply((XSFunction)this);
            }
        }
        this.nodeSet.addAll(this.complexTypes.values());
        this.nodeSet.addAll(this.modelGroups.values());
        this.nodeSet.addAll(this.attGroups.values());
    }

    public Leaf simpleType(XSSimpleType simpleType) {
        return (Leaf)simpleType.apply((XSSimpleTypeFunction)this);
    }

    public Leaf particle(XSParticle particle) {
        return (Leaf)particle.getTerm().apply((XSFunction)this);
    }

    public Leaf empty(XSContentType empty) {
        return new Empty(empty.getLocator());
    }

    public Attribute attributeDecl(XSAttributeDecl decl) {
        return new Attribute(decl.getLocator(), this.getQName((XSDeclaration)decl), this.simpleType(decl.getType()));
    }

    public Attribute attributeUse(XSAttributeUse use) {
        return this.attributeDecl(use.getDecl());
    }

    public Leaf wildcard(XSWildcard wc) {
        return new Empty(wc.getLocator());
    }

    public Leaf modelGroupDecl(XSModelGroupDecl mg) {
        Define def = this.modelGroups.get(mg);
        if (def == null) {
            def = this.grammar.get(mg.getName());
            this.modelGroups.put(mg, def);
            def.addChild((Leaf)mg.getModelGroup().apply((XSFunction)this));
        }
        return new Ref(mg.getLocator(), def);
    }

    public Leaf modelGroup(XSModelGroup mg) {
        XSParticle[] children = mg.getChildren();
        if (children.length == 0) {
            return new Empty(mg.getLocator());
        }
        Leaf l = this.particle(children[0]);
        for (int i = 1; i < children.length; ++i) {
            l.merge(this.particle(children[i]));
        }
        return l;
    }

    public Leaf elementDecl(XSElementDecl e) {
        Element el = new Element(e.getLocator(), this.getQName((XSDeclaration)e), (Leaf)e.getType().apply((XSFunction)this));
        this.nodeSet.add(el);
        return el;
    }

    public Leaf complexType(XSComplexType ct) {
        Define def = this.complexTypes.get(ct);
        if (def == null) {
            String name = ct.getName();
            if (ct.isLocal()) {
                name = ct.getScope().getName();
            }
            def = this.grammar.get(name);
            this.complexTypes.put(ct, def);
            XSType baseType = ct.getBaseType();
            if (baseType.isComplexType() && !this.isAnyType(baseType)) {
                def.addChild((Leaf)baseType.apply((XSFunction)this));
                if (ct.getDerivationMethod() == 1) {
                    XSContentType explicitContent = ct.getExplicitContent();
                    if (explicitContent != null) {
                        def.addChild((Leaf)explicitContent.apply((XSFunction)this));
                    }
                    this.attHolder((XSAttContainer)ct, def);
                }
            } else {
                def.addChild((Leaf)ct.getContentType().apply((XSFunction)this));
                this.attHolder((XSAttContainer)ct, def);
            }
        }
        return new Ref(ct.getLocator(), def);
    }

    private void attHolder(XSAttContainer ct, Define def) {
        for (XSAttributeUse use : ct.getDeclaredAttributeUses()) {
            def.addChild(this.attributeUse(use));
        }
        for (XSAttGroupDecl ag : ct.getAttGroups()) {
            def.addChild(this.attGroupDecl(ag));
        }
    }

    public Leaf attGroupDecl(XSAttGroupDecl ag) {
        Define def = this.attGroups.get(ag);
        if (def == null) {
            def = this.grammar.get(ag.getName());
            this.attGroups.put(ag, def);
            this.attHolder((XSAttContainer)ag, def);
        }
        return new Ref(ag.getLocator(), def);
    }

    private boolean isAnyType(XSType t) {
        return t.getName().equals("anyType") && t.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema");
    }

    public Leaf restrictionSimpleType(XSRestrictionSimpleType rst) {
        JType t = this.dtf.getType(rst.getTargetNamespace(), rst.getName());
        if (t != null) {
            return new Data(rst.getLocator(), t);
        }
        return this.simpleType(rst.getSimpleBaseType());
    }

    public Leaf unionSimpleType(XSUnionSimpleType st) {
        Leaf l = this.simpleType(st.getMember(0));
        for (int i = 1; i < st.getMemberSize(); ++i) {
            l.merge(this.simpleType(st.getMember(i)));
        }
        return l;
    }

    public Leaf listSimpleType(XSListSimpleType st) {
        return new List(st.getLocator(), this.simpleType(st.getItemType()));
    }

    private QName getQName(XSDeclaration decl) {
        return new QName(decl.getTargetNamespace(), decl.getName());
    }

    private XmlSchemaBuilder(XSSchemaSet xs, TxwOptions opts) {
        this.schemaSet = xs;
        this.grammar.addChild(new Empty(null));
        this.nodeSet = new NodeSet(opts, this.grammar);
        this.dtf = new DatatypeFactory(opts.codeModel);
    }

    public Leaf annotation(XSAnnotation xsAnnotation) {
        throw new IllegalStateException();
    }

    public Leaf schema(XSSchema xsSchema) {
        throw new IllegalStateException();
    }

    public Leaf facet(XSFacet xsFacet) {
        throw new IllegalStateException();
    }

    public Leaf notation(XSNotation xsNotation) {
        throw new IllegalStateException();
    }

    public Leaf identityConstraint(XSIdentityConstraint xsIdentityConstraint) {
        throw new IllegalStateException();
    }

    public Leaf xpath(XSXPath xsxPath) {
        throw new IllegalStateException();
    }
}

