/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JPrimitiveType;

public abstract class JType
implements JGenerable,
Comparable<JType> {
    protected JType() {
    }

    public static JPrimitiveType parse(JCodeModel codeModel, String typeName) {
        switch (typeName) {
            case "void": {
                return codeModel.VOID;
            }
            case "boolean": {
                return codeModel.BOOLEAN;
            }
            case "byte": {
                return codeModel.BYTE;
            }
            case "short": {
                return codeModel.SHORT;
            }
            case "char": {
                return codeModel.CHAR;
            }
            case "int": {
                return codeModel.INT;
            }
            case "float": {
                return codeModel.FLOAT;
            }
            case "long": {
                return codeModel.LONG;
            }
            case "double": {
                return codeModel.DOUBLE;
            }
        }
        throw new IllegalArgumentException("Not a primitive type: " + typeName);
    }

    public abstract JCodeModel owner();

    public abstract String fullName();

    public String binaryName() {
        return this.fullName();
    }

    public abstract String name();

    public abstract JClass array();

    public boolean isArray() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public abstract JClass boxify();

    public abstract JType unboxify();

    public JType erasure() {
        return this;
    }

    public final boolean isReference() {
        return !this.isPrimitive();
    }

    public JType elementType() {
        throw new IllegalArgumentException("Not an array type");
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.fullName() + ")";
    }

    @Override
    public int compareTo(JType o) {
        String rhs = o.fullName();
        boolean p = this.fullName().startsWith("java");
        boolean q = rhs.startsWith("java");
        if (p && !q) {
            return -1;
        }
        if (!p && q) {
            return 1;
        }
        return this.fullName().compareTo(rhs);
    }
}

