/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.component.behavior;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.Application;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;

public class AjaxBehaviors
implements Serializable {
    private static final String AJAX_BEHAVIORS = "javax.faces.component.AjaxBehaviors";
    private ArrayDeque<BehaviorInfo> behaviorStack = new ArrayDeque();

    public static AjaxBehaviors getAjaxBehaviors(FacesContext context, boolean createIfNull) {
        Map<Object, Object> attrs = context.getAttributes();
        AjaxBehaviors ajaxBehaviors = (AjaxBehaviors)attrs.get(AJAX_BEHAVIORS);
        if (ajaxBehaviors == null && createIfNull) {
            ajaxBehaviors = new AjaxBehaviors();
            attrs.put(AJAX_BEHAVIORS, ajaxBehaviors);
        }
        return ajaxBehaviors;
    }

    public void addBehaviors(FacesContext context, ClientBehaviorHolder behaviorHolder) {
        if (this.behaviorStack == null || this.behaviorStack.isEmpty()) {
            return;
        }
        Iterator<BehaviorInfo> descendingIter = this.behaviorStack.descendingIterator();
        while (descendingIter.hasNext()) {
            descendingIter.next().addBehavior(context, behaviorHolder);
        }
    }

    public void pushBehavior(FacesContext context, AjaxBehavior ajaxBehavior, String eventName) {
        this.behaviorStack.add(new BehaviorInfo(context, ajaxBehavior, eventName));
    }

    public void popBehavior() {
        if (this.behaviorStack.size() > 0) {
            this.behaviorStack.removeLast();
        }
    }

    public static class BehaviorInfo
    implements Serializable {
        private String eventName;
        private Object behaviorState;
        private static final long serialVersionUID = -7679229822647712959L;

        public BehaviorInfo(FacesContext context, AjaxBehavior ajaxBehavior, String eventName) {
            this.eventName = eventName;
            this.behaviorState = ajaxBehavior.saveState(context);
        }

        public void addBehavior(FacesContext context, ClientBehaviorHolder behaviorHolder) {
            String myEventName = this.eventName;
            if (myEventName == null && (myEventName = behaviorHolder.getDefaultEventName()) == null) {
                return;
            }
            if (this.shouldAddBehavior(behaviorHolder, myEventName)) {
                ClientBehavior behavior = this.createBehavior(context);
                behaviorHolder.addClientBehavior(myEventName, behavior);
            }
        }

        private boolean shouldAddBehavior(ClientBehaviorHolder behaviorHolder, String eventName) {
            if (!behaviorHolder.getEventNames().contains(eventName)) {
                return false;
            }
            Map<String, List<ClientBehavior>> allBehaviors = behaviorHolder.getClientBehaviors();
            List<ClientBehavior> eventBehaviors = allBehaviors.get(eventName);
            if (eventBehaviors == null || eventBehaviors.isEmpty()) {
                return true;
            }
            for (ClientBehavior behavior : eventBehaviors) {
                Set<ClientBehaviorHint> hints = behavior.getHints();
                if (!hints.contains((Object)ClientBehaviorHint.SUBMITTING)) continue;
                return false;
            }
            return true;
        }

        private ClientBehavior createBehavior(FacesContext context) {
            Application application = context.getApplication();
            AjaxBehavior behavior = (AjaxBehavior)application.createBehavior("javax.faces.behavior.Ajax");
            behavior.restoreState(context, this.behaviorState);
            return behavior;
        }

        private BehaviorInfo() {
        }
    }
}

