/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component.behavior;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public abstract class ClientBehaviorContext {
    public static final String BEHAVIOR_SOURCE_PARAM_NAME = "jakarta.faces.source";
    public static final String BEHAVIOR_EVENT_PARAM_NAME = "jakarta.faces.behavior.event";

    public static ClientBehaviorContext createClientBehaviorContext(FacesContext context, UIComponent component, String eventName, String sourceId, Collection<Parameter> parameters) {
        return new ClientBehaviorContextImpl(context, component, eventName, sourceId, parameters);
    }

    public abstract FacesContext getFacesContext();

    public abstract UIComponent getComponent();

    public abstract String getEventName();

    public abstract String getSourceId();

    public abstract Collection<Parameter> getParameters();

    private static final class ClientBehaviorContextImpl
    extends ClientBehaviorContext {
        private final FacesContext context;
        private final UIComponent component;
        private final String eventName;
        private final String sourceId;
        private final Collection<Parameter> parameters;

        private ClientBehaviorContextImpl(FacesContext context, UIComponent component, String eventName, String sourceId, Collection<Parameter> parameters) {
            Objects.requireNonNull(context);
            Objects.requireNonNull(component);
            Objects.requireNonNull(eventName);
            this.context = context;
            this.component = component;
            this.eventName = eventName;
            this.sourceId = sourceId;
            this.parameters = parameters == null ? Collections.emptyList() : parameters;
        }

        @Override
        public FacesContext getFacesContext() {
            return this.context;
        }

        @Override
        public UIComponent getComponent() {
            return this.component;
        }

        @Override
        public String getEventName() {
            return this.eventName;
        }

        @Override
        public String getSourceId() {
            return this.sourceId;
        }

        @Override
        public Collection<Parameter> getParameters() {
            return this.parameters;
        }
    }

    public static class Parameter {
        private final String name;
        private final Object value;

        public Parameter(String name, Object value) {
            if (null == name) {
                throw new NullPointerException();
            }
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

