/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util.copier;

import com.sun.faces.util.copier.Copier;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class CloneCopier
implements Copier {
    private static final String ERROR_CANT_CLONE = "Can not clone object of type %s since it doesn't implement Cloneable";

    @Override
    public Object copy(Object object) {
        if (!(object instanceof Cloneable)) {
            throw new IllegalStateException(String.format(ERROR_CANT_CLONE, object.getClass()));
        }
        try {
            Method cloneMethod = this.getMethod(object, "clone");
            if (!cloneMethod.canAccess(object)) {
                cloneMethod.setAccessible(true);
            }
            return cloneMethod.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private Method getMethod(Object object, String name) {
        for (Class<?> c = object.getClass(); c != null; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                if (!method.getName().equals(name)) continue;
                return method;
            }
        }
        return null;
    }
}

