/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.BaseContextMap;
import com.sun.faces.context.ExternalContextImpl;
import com.sun.faces.util.Util;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.ServletRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RequestParameterMap
extends BaseContextMap<String> {
    private String namingContainerPrefix;
    private final ServletRequest request;
    private boolean inspectedParameterNames = false;

    public RequestParameterMap(ServletRequest request) {
        this.request = request;
    }

    @Override
    public String get(Object key) {
        String mapKey;
        String mapValue;
        Util.notNull("key", key);
        if (!this.inspectedParameterNames) {
            this.inspectedParameterNames = true;
            this.request.getParameterNames();
        }
        if ((mapValue = this.request.getParameter(mapKey = key.toString())) == null && !mapKey.startsWith(this.getNamingContainerPrefix())) {
            mapValue = this.request.getParameter(this.getNamingContainerPrefix() + mapKey);
        }
        return mapValue;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    protected String getNamingContainerPrefix() {
        if (null == this.namingContainerPrefix) {
            FacesContext context = FacesContext.getCurrentInstance();
            if (context == null) {
                return "";
            }
            this.namingContainerPrefix = Util.getNamingContainerPrefix(context);
        }
        return this.namingContainerPrefix;
    }

    @Override
    public Collection<String> values() {
        return Collections.unmodifiableCollection(super.values());
    }

    @Override
    public boolean containsKey(Object key) {
        return key != null && this.get(key) != null;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == ExternalContextImpl.theUnmodifiableMapClass && super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hashCode = 7 * this.request.hashCode();
        for (Map.Entry<String, String> stringStringEntry : this.entrySet()) {
            hashCode += stringStringEntry.hashCode();
        }
        return hashCode;
    }

    @Override
    protected Iterator<Map.Entry<String, String>> getEntryIterator() {
        return new BaseContextMap.EntryIterator(this.request.getParameterNames());
    }

    @Override
    protected Iterator<String> getKeyIterator() {
        return new BaseContextMap.KeyIterator(this.request.getParameterNames());
    }

    @Override
    protected Iterator<String> getValueIterator() {
        return new BaseContextMap.ValueIterator(this.request.getParameterNames());
    }
}

