/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.cdi.clientwindow;

import com.sun.faces.cdi.clientwindow.ClientWindowScopeContextObject;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.LRUMap;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClientWindowScopeContextManager {
    private static final Logger LOGGER = FacesLogger.CLIENTWINDOW.getLogger();
    private static final String CLIENT_WINDOW_CONTEXTS = "com.sun.faces.cdi.clientwindow.clientWindowContexts";
    private final boolean distributable;

    public ClientWindowScopeContextManager() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.distributable = WebConfiguration.getInstance(facesContext.getExternalContext()).isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableDistributable);
    }

    public <T> T createBean(FacesContext facesContext, Contextual<T> contextual, CreationalContext<T> creational) {
        LOGGER.log(Level.FINEST, "Creating @ClientWindowScoped CDI bean using contextual: {0}", contextual);
        if (!(contextual instanceof PassivationCapable)) {
            throw new IllegalArgumentException("ClientWindowScoped bean " + contextual.toString() + " must be PassivationCapable, but is not.");
        }
        Object contextualInstance = contextual.create(creational);
        if (contextualInstance != null) {
            String passivationCapableId = ((PassivationCapable)contextual).getId();
            this.getContextMap(facesContext).put(passivationCapableId, new ClientWindowScopeContextObject<Object>(passivationCapableId, contextualInstance));
        }
        return (T)contextualInstance;
    }

    public <T> T getBean(FacesContext facesContext, Contextual<T> contextual) {
        T result = null;
        Map<String, ClientWindowScopeContextObject> contextMap = this.getContextMap(facesContext);
        if (contextMap != null) {
            if (!(contextual instanceof PassivationCapable)) {
                throw new IllegalArgumentException("ClientWindowScoped bean " + contextual.toString() + " must be PassivationCapable, but is not.");
            }
            ClientWindowScopeContextObject contextObject = contextMap.get(((PassivationCapable)contextual).getId());
            if (contextObject != null) {
                return contextObject.getContextualInstance();
            }
        }
        return result;
    }

    private Map<String, ClientWindowScopeContextObject> getContextMap(FacesContext facesContext) {
        return this.getContextMap(facesContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ClientWindowScopeContextObject> getContextMap(FacesContext facesContext, boolean create) {
        Map result = null;
        ExternalContext externalContext = facesContext.getExternalContext();
        if (externalContext != null) {
            Map<String, Object> sessionMap = externalContext.getSessionMap();
            Object session = externalContext.getSession(create);
            if (session != null) {
                Object object;
                Map clientWindowScopeContexts = (Map)sessionMap.get(CLIENT_WINDOW_CONTEXTS);
                String clientWindowId = this.getCurrentClientWindowId(facesContext);
                if (clientWindowScopeContexts == null && create) {
                    object = session;
                    synchronized (object) {
                        Integer size = (Integer)sessionMap.get("jakarta.faces.NUMBER_OF_CLIENT_WINDOWS");
                        if (size == null) {
                            size = 10;
                        }
                        sessionMap.put(CLIENT_WINDOW_CONTEXTS, Collections.synchronizedMap(new LRUMap(size)));
                    }
                }
                if (clientWindowScopeContexts != null && clientWindowId != null && create) {
                    object = clientWindowScopeContexts;
                    synchronized (object) {
                        if (!clientWindowScopeContexts.containsKey(clientWindowId)) {
                            clientWindowScopeContexts.put(clientWindowId, new ConcurrentHashMap());
                            if (this.distributable) {
                                sessionMap.put(CLIENT_WINDOW_CONTEXTS, clientWindowScopeContexts);
                            }
                        }
                    }
                }
                if (clientWindowScopeContexts != null && clientWindowId != null) {
                    result = (Map)clientWindowScopeContexts.get(clientWindowId);
                }
            }
        }
        return result;
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        HttpSession session;
        Map clientWindowScopeContexts;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Cleaning up session for CDI @ClientWindowScoped beans");
        }
        if ((clientWindowScopeContexts = (Map)(session = httpSessionEvent.getSession()).getAttribute(CLIENT_WINDOW_CONTEXTS)) != null) {
            clientWindowScopeContexts.clear();
            session.removeAttribute(CLIENT_WINDOW_CONTEXTS);
        }
    }

    protected String getCurrentClientWindowId(FacesContext facesContext) {
        return facesContext.getExternalContext().getClientWindow().getId();
    }
}

