/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.maven;

import com.sun.enterprise.module.common_impl.Jar;
import com.sun.enterprise.module.maven.VersionTranslator;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public class OSGiPackager {
    private static final Logger logger = Logger.getAnonymousLogger();
    private Properties props;

    public OSGiPackager(Properties props) {
        this.props = props;
    }

    public Map<String, String> configureOSGiManifest(MavenProject pom, MavenArchiveConfiguration archive, File classesDirectory) throws IOException {
        List<ExportedPackage> packages;
        String exportPackages;
        String requiredBundles;
        HashMap<String, String> entries = archive != null ? archive.getManifestEntries() : new HashMap<String, String>();
        if (entries.get("Bundle-ManifestVersion") == null) {
            entries.put("Bundle-ManifestVersion", "2");
        }
        if (entries.get("Bundle-Name") == null) {
            entries.put("Bundle-Name", pom.getName());
        }
        if (entries.get("Bundle-SymbolicName") == null) {
            entries.put("Bundle-SymbolicName", pom.getGroupId() + '.' + pom.getArtifactId());
        }
        if (entries.get("Bundle-Version") == null) {
            entries.put("Bundle-Version", VersionTranslator.MavenToOSGi(pom.getVersion()));
        }
        if (entries.get("Bundle-Description") == null && pom.getDescription() != null) {
            entries.put("Bundle-Description", pom.getDescription());
        }
        if (entries.get("Bundle-Vendor") == null && pom.getOrganization() != null && pom.getOrganization().getName() != null) {
            entries.put("Bundle-Vendor", pom.getOrganization().getName());
        }
        if (entries.get("Require-Bundle") == null && (requiredBundles = this.generateRequireBundleHeader(this.discoverRequiredBundles(pom))).length() > 0) {
            entries.put("Require-Bundle", requiredBundles);
        }
        if (entries.get("Export-Package") == null && (exportPackages = OSGiPackager.generateExportPackageHeader(packages = OSGiPackager.discoverPackages(classesDirectory), null)).length() > 0) {
            entries.put("Export-Package", exportPackages);
        }
        return entries;
    }

    public List<BundleDependency> discoverRequiredBundles(MavenProject pom) throws IOException {
        ArrayList<BundleDependency> dependencies = new ArrayList<BundleDependency>();
        for (Artifact a : pom.getDependencyArtifacts()) {
            String version;
            if ("test".equals(a.getScope()) || "provided".equals(a.getScope())) continue;
            if (a.getFile() == null) {
                throw new AssertionError((Object)(a.getId() + " is not resolved. a=" + a));
            }
            Attributes attributes = null;
            String name = null;
            Manifest manifest = Jar.create((File)a.getFile()).getManifest();
            if (manifest != null) {
                attributes = manifest.getMainAttributes();
                name = attributes.getValue("Bundle-SymbolicName");
            }
            if (name == null || attributes.getValue("Fragment-Host") != null) continue;
            BundleDependency bd = new BundleDependency();
            bd.bundleSymbolicName = name;
            bd.versionRange = version = attributes.getValue("Bundle-Version");
            bd.resolution = this.props.getProperty("resolution", "mandatory");
            bd.visibility = this.props.getProperty("visibility", "private");
            dependencies.add(bd);
        }
        return dependencies;
    }

    public String generateRequireBundleHeader(List<BundleDependency> dependencies) {
        StringBuilder requiredBundles = new StringBuilder();
        for (BundleDependency bd : dependencies) {
            if (requiredBundles.length() != 0) {
                requiredBundles.append(",");
            }
            requiredBundles.append(bd.bundleSymbolicName);
            if (bd.versionRange != null) {
                requiredBundles.append(';').append("bundle-version").append('=').append(bd.versionRange);
            }
            requiredBundles.append(";").append("resolution").append(":=").append(bd.resolution);
            requiredBundles.append(';').append("visibility").append(":=").append(bd.visibility);
        }
        return requiredBundles.toString();
    }

    public static List<ExportedPackage> discoverPackages(final File classesDirectory) {
        final ArrayList<ExportedPackage> packages = new ArrayList<ExportedPackage>();
        classesDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File file = new File(dir, name);
                if (file.isDirectory()) {
                    file.listFiles(this);
                }
                String CLASS_EXT = ".class";
                if (!name.endsWith(".class")) {
                    return false;
                }
                String packagePath = dir.getPath().substring(classesDirectory.getPath().length() + 1);
                String packageName = packagePath.replace(File.separatorChar, '.');
                logger.fine("packageName = " + packageName);
                ExportedPackage ep = new ExportedPackage(packageName);
                if (!packages.contains(ep)) {
                    packages.add(ep);
                }
                return true;
            }
        });
        Collections.sort(packages);
        return packages;
    }

    public static String generateExportPackageHeader(Collection<ExportedPackage> packages, String version) {
        if (packages.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (ExportedPackage p : packages) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(p.packageName);
            if (version == null) continue;
            sb.append(";").append("version").append("=").append(version);
        }
        return sb.toString();
    }

    static class ExportedPackage
    implements Comparable<ExportedPackage> {
        String packageName;
        Collection<String> packagesUsed;

        public ExportedPackage(String packageName, Collection<String> packagesUsed) {
            this.packageName = packageName;
            this.packagesUsed = packagesUsed;
        }

        public ExportedPackage(String packageName) {
            this(packageName, null);
        }

        public int hashCode() {
            return this.packageName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ExportedPackage) {
                return this.packageName.equals(((ExportedPackage)ExportedPackage.class.cast((Object)obj)).packageName);
            }
            return false;
        }

        @Override
        public int compareTo(ExportedPackage exportedPackage) {
            return this.packageName.compareTo(exportedPackage.packageName);
        }
    }

    static class BundleDependency {
        String bundleSymbolicName;
        String versionRange;
        String resolution;
        String visibility;

        BundleDependency() {
        }
    }
}

