/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.maven;

import com.sun.enterprise.module.maven.OSGiPackager;
import com.sun.enterprise.module.maven.Packager;
import java.io.File;
import java.util.Properties;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public class PackageMojo
extends AbstractMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    protected File outputDirectory;
    protected String finalName;
    protected JarArchiver jarArchiver;
    protected MavenProject project;
    protected MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    protected MavenProjectHelper projectHelper;
    protected File classesDirectory;
    protected String[] excludes;
    private boolean generateOSGiHeaders;
    private String resolution;
    private String visibility;

    protected final MavenProject getProject() {
        return this.project;
    }

    protected static File getJarFile(File basedir, String finalName) {
        return new File(basedir, finalName + ".jar");
    }

    public File createArchive() throws MojoExecutionException {
        File jarFile = PackageMojo.getJarFile(this.outputDirectory, this.finalName);
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(jarFile);
        try {
            File contentDirectory;
            new Packager().configureManifest(this.project, this.archive, this.classesDirectory);
            if (this.generateOSGiHeaders) {
                Properties props = new Properties();
                props.put("resolution", this.resolution);
                props.put("visibility", this.visibility);
                new OSGiPackager(props).configureOSGiManifest(this.project, this.archive, this.classesDirectory);
            }
            if (!(contentDirectory = this.classesDirectory).exists()) {
                this.getLog().warn((CharSequence)"JAR will be empty - no content was marked for inclusion!");
            } else {
                archiver.getArchiver().addDirectory(contentDirectory, DEFAULT_INCLUDES, this.getExcludes());
            }
            archiver.createArchive(this.project, this.archive);
            return jarFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling JAR", e);
        }
    }

    public void execute() throws MojoExecutionException {
        File jarFile = this.createArchive();
        this.getProject().getArtifact().setFile(jarFile);
    }

    private String[] getExcludes() {
        if (this.excludes != null && this.excludes.length > 0) {
            return this.excludes;
        }
        return new String[]{"**/package.html"};
    }
}

