/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config.provider.internal;

import com.sun.hk2.component.InhabitantStore;
import com.sun.hk2.component.InjectionResolverQuery;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.provider.ConfigTransaction;
import org.jvnet.hk2.config.provider.ConfigTransactionException;
import org.jvnet.hk2.config.provider.ConfigTransactionRejectedException;
import org.jvnet.hk2.config.provider.internal.ConfigByInhabitant;
import org.jvnet.hk2.config.provider.internal.ConfigByMetaInhabitant;
import org.jvnet.hk2.config.provider.internal.ConfigTransactionCoordinator;
import org.jvnet.hk2.config.provider.internal.ReflectionHelper;

@Service
public class ConfigTransactionImpl
implements ConfigTransaction,
InjectionResolverQuery {
    private final Logger logger = Logger.getLogger(ConfigTransactionImpl.class.getName());
    private ConfigTransactionCoordinator coordinator;
    private Map<Object, ConfigEntry> txnConfig2Entry = new HashMap<Object, ConfigEntry>();
    private boolean prepared;

    ConfigTransactionImpl(ConfigTransactionCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @Override
    public synchronized void prepare() throws ConfigTransactionException {
        if (this.prepared) {
            return;
        }
        this.verifyActiveTransaction(true);
        try {
            for (Map.Entry<Object, ConfigEntry> entry : this.txnConfig2Entry.entrySet()) {
                this.prepareEntry(entry.getKey(), entry.getValue());
            }
            this.prepared = true;
        }
        catch (ConfigTransactionRejectedException e) {
            this.rollback();
        }
    }

    private void prepareEntry(Object configBean, ConfigEntry value) {
        if (value.prepared) {
            return;
        }
        if (Change.CREATE == value.change) {
            value.setConfiguredByMeta(this.coordinator.getConfiguredByInhabitants(configBean.getClass()));
            for (ConfigByMetaInhabitant cbi : value.configuredByMeta) {
                cbi.managePrepare(configBean, value, this);
            }
        } else {
            if (Change.UPDATE == value.change) {
                throw new UnsupportedOperationException();
            }
            if (Change.DELETE != value.change) assert (false);
        }
        value.prepared = true;
    }

    @Override
    public synchronized void commit() throws ConfigTransactionException {
        if (!this.prepared) {
            this.prepare();
        } else {
            this.verifyActiveTransaction(false);
        }
        ComponentException ce = null;
        for (Map.Entry<Object, ConfigEntry> entry : this.txnConfig2Entry.entrySet()) {
            try {
                this.commitEntry(entry.getKey(), entry.getValue());
            }
            catch (ComponentException e) {
                this.logger.log(Level.FINE, "error during commit", e);
                if (null != ce) continue;
                ce = e;
            }
        }
        this.coordinator.finishedTransaction(this);
        this.coordinator = null;
        this.prepared = false;
        if (null != ce) {
            throw new ConfigTransactionException("error during commit", ce);
        }
    }

    @Override
    public synchronized void commit(Map<Object, Object> beanReplacements) throws ConfigTransactionException {
        throw new UnsupportedOperationException();
    }

    private void commitEntry(Object configBean, ConfigEntry value) {
        assert (value.prepared);
        if (Change.CREATE == value.change) {
            if (null == value.suggestedName) {
                value.suggestedName = ReflectionHelper.nameOf(configBean);
            }
            HashSet beanContracts = new HashSet();
            ReflectionHelper.annotatedWith(beanContracts, configBean, Contract.class);
            this.coordinator.manage(configBean, beanContracts, value.suggestedName, (MultiMap<String, ConfigByInhabitant>)value.configuredBy);
        } else {
            if (Change.UPDATE == value.change) {
                throw new UnsupportedOperationException();
            }
            if (Change.DELETE == value.change) {
                String name = ReflectionHelper.nameOf(configBean);
                HashSet beanContracts = new HashSet();
                ReflectionHelper.annotatedWith(beanContracts, configBean, Contract.class);
                this.coordinator.unmanage(configBean, beanContracts, name);
            } else assert (false);
        }
        value.prepared = true;
    }

    @Override
    public synchronized void rollback() {
        this.verifyActiveTransaction(false);
        for (Map.Entry<Object, ConfigEntry> entry : this.txnConfig2Entry.entrySet()) {
            this.rollback(entry.getKey(), entry.getValue());
        }
        this.coordinator.finishedTransaction(this);
        this.coordinator = null;
        this.prepared = false;
    }

    private void rollback(Object key, ConfigEntry value) {
        if (value.prepared) {
            if (Change.CREATE != value.change && Change.UPDATE != value.change && Change.DELETE != value.change) assert (false);
            value.prepared = false;
        }
    }

    private void verifyActiveTransaction(boolean mustBeOpen) {
        if (null == this.coordinator) {
            throw new ConfigTransactionException("no active transaction");
        }
        if (mustBeOpen && this.prepared) {
            throw new ConfigTransactionException("in prepared state");
        }
    }

    @Override
    public synchronized void created(Object createdConfigBean, String name, MultiMap<String, String> metadata) {
        this.verifyActiveTransaction(true);
        if (null == createdConfigBean) {
            throw new IllegalArgumentException();
        }
        if (this.txnConfig2Entry.containsKey(createdConfigBean) || this.coordinator.has(createdConfigBean)) {
            throw new ConfigTransactionException(createdConfigBean + " is already in txn");
        }
        Configured configured = ReflectionHelper.annotation(createdConfigBean, Configured.class);
        if (null == configured) {
            throw new IllegalArgumentException();
        }
        this.txnConfig2Entry.put(createdConfigBean, new ConfigEntry(Change.CREATE, name, null));
    }

    @Override
    public void deleted(Collection<?> deletedConfigBeans) {
        for (Object bean : deletedConfigBeans) {
            this.deleted(bean);
        }
    }

    @Override
    public synchronized void deleted(Object deleted) {
        this.track(deleted, Change.DELETE);
    }

    @Override
    public void updated(Collection<?> updatedConfigBeans) {
        for (Object bean : updatedConfigBeans) {
            this.updated(bean, null);
        }
    }

    @Override
    public synchronized void updated(Object updated, PropertyChangeEvent event) {
        this.track(updated, Change.UPDATE);
    }

    private void track(Object bean, Change change) {
        this.verifyActiveTransaction(true);
        if (null == bean) {
            throw new IllegalArgumentException();
        }
        if (this.txnConfig2Entry.containsKey(bean)) {
            throw new ConfigTransactionException(bean + " is already in txn");
        }
        MultiMap<String, ConfigByInhabitant> allConfiguredByBean = this.coordinator.get(bean);
        if (null == allConfiguredByBean) {
            throw new ConfigTransactionException(bean + " is not being tracked");
        }
        this.txnConfig2Entry.put(bean, new ConfigEntry(change, null, allConfiguredByBean));
    }

    public <V> V getValue(Object component, Inhabitant<?> onBehalfOf, AnnotatedElement annotated, Type genericType, Class<V> type) throws ComponentException {
        String name = annotated.getAnnotation(Inject.class).name();
        String string = name = null == name || name.isEmpty() ? null : name;
        if (null != type.getAnnotation(Configured.class)) {
            for (Object bean : this.txnConfig2Entry.keySet()) {
                String name2;
                Class<?> clazz = bean.getClass();
                if (!type.isAssignableFrom(clazz) || !ConfigTransactionImpl.eq(name, name2 = ReflectionHelper.nameOf(bean))) continue;
                return (V)bean;
            }
        }
        for (ConfigEntry ce : this.txnConfig2Entry.values()) {
            if (null == ce.configuredBy) continue;
            for (Map.Entry entry : ce.configuredBy.entrySet()) {
                if (null != entry.getKey()) continue;
            }
        }
        this.logger.log(Level.FINE, "couldn''t resolve: {0}", type);
        return null;
    }

    private static boolean eq(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    private static class ConfigEntry
    implements InhabitantStore {
        private final Change change;
        private String suggestedName;
        private Collection<ConfigByMetaInhabitant> configuredByMeta;
        private MultiMap<String, ConfigByInhabitant> configuredBy;
        private boolean prepared;

        private ConfigEntry(Change change, String name, MultiMap<String, ConfigByInhabitant> ci) {
            this.change = change;
            this.suggestedName = name;
            this.configuredBy = ci;
        }

        public void setConfiguredByMeta(Collection<ConfigByMetaInhabitant> configuredByInhabitants) {
            this.configuredByMeta = configuredByInhabitants;
        }

        private void initConfiguredByCollection() {
            if (null == this.configuredBy) {
                this.configuredBy = new MultiMap();
            }
        }

        public void add(Inhabitant<?> managed) {
            this.initConfiguredByCollection();
            this.configuredBy.add(null, (Object)((ConfigByInhabitant)managed));
        }

        public void addIndex(Inhabitant<?> managed, String typeName, String name) {
            this.initConfiguredByCollection();
            this.configuredBy.add((Object)(typeName + (null == name ? "" : ":" + name)), (Object)((ConfigByInhabitant)managed));
        }

        public boolean remove(Inhabitant<?> managed) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIndex(String index, String name) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIndex(String index, Object serviceOrInhabitant) {
            throw new UnsupportedOperationException();
        }
    }

    private static enum Change {
        CREATE,
        UPDATE,
        DELETE;

    }
}

