/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config.provider.internal;

import com.sun.hk2.component.ExistingSingletonInhabitant;
import com.sun.hk2.component.InhabitantsParser;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.PreDestroy;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantActivator;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.ConfiguredBy;
import org.jvnet.hk2.config.provider.ConfigTransaction;
import org.jvnet.hk2.config.provider.ConfigTransactionFactory;
import org.jvnet.hk2.config.provider.internal.ConfigByInhabitant;
import org.jvnet.hk2.config.provider.internal.ConfigByMetaInhabitant;
import org.jvnet.hk2.config.provider.internal.ConfigTransactionImpl;

@Service
public class ConfigTransactionCoordinator
implements ConfigTransactionFactory,
PreDestroy {
    private Logger logger = Logger.getLogger(ConfigTransactionCoordinator.class.getName());
    @Inject
    private Habitat habitat;
    @Inject(optional=true)
    private InhabitantActivator activator;
    private ConfigTransaction theActiveOne;
    private Map<Object, MultiMap<String, ConfigByInhabitant>> beanToManagedConfigBy = new HashMap<Object, MultiMap<String, ConfigByInhabitant>>();

    @Override
    public synchronized ConfigTransaction getActiveTransaction(boolean create) {
        if (create && null == this.theActiveOne) {
            this.theActiveOne = new ConfigTransactionImpl(this);
        }
        return this.theActiveOne;
    }

    synchronized void finishedTransaction(ConfigTransaction txn) {
        assert (this.theActiveOne == txn);
        this.theActiveOne = null;
    }

    public void preDestroy() {
        if (null != this.theActiveOne) {
            this.theActiveOne.rollback();
            assert (null == this.theActiveOne);
        }
    }

    boolean has(Object bean) {
        return this.beanToManagedConfigBy.containsKey(bean);
    }

    MultiMap<String, ConfigByInhabitant> get(Object bean) {
        MultiMap<String, ConfigByInhabitant> orig = this.beanToManagedConfigBy.get(bean);
        return null == orig ? null : new MultiMap();
    }

    Collection<ConfigByMetaInhabitant> getConfiguredByInhabitants(Class<?> clazz) {
        HashSet configured = new HashSet();
        if (Proxy.isProxyClass(clazz)) {
            for (Class<?> iface : clazz.getInterfaces()) {
                if (null == iface.getAnnotation(Configured.class)) continue;
                configured.add(iface);
            }
        }
        while (Object.class != clazz) {
            String name = clazz.getName();
            if (null != name && null != clazz.getAnnotation(Configured.class)) {
                configured.add(clazz);
            }
            clazz = clazz.getSuperclass();
        }
        ArrayList<ConfigByMetaInhabitant> configuredByList = null;
        for (Inhabitant i : this.habitat.getInhabitantsByContract(ConfiguredBy.class.getName())) {
            ConfigByMetaInhabitant configuredBy = (ConfigByMetaInhabitant)i;
            if (!configured.contains(configuredBy.getConfiguredBy())) continue;
            if (null == configuredByList) {
                configuredByList = new ArrayList<ConfigByMetaInhabitant>();
            }
            configuredByList.add(configuredBy);
        }
        return null == configuredByList ? Collections.EMPTY_LIST : Collections.unmodifiableList(configuredByList);
    }

    void manage(Object bean, Set<Class<?>> beanContracts, String name, MultiMap<String, ConfigByInhabitant> managed) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "managing: {0}, {1}, {2}, {3}", new Object[]{bean, name, beanContracts, managed});
        }
        if (null != beanContracts && !beanContracts.isEmpty()) {
            ExistingSingletonInhabitant configBeanInhabitant = new ExistingSingletonInhabitant(bean);
            for (Class<?> beanContract : beanContracts) {
                this.habitat.addIndex((Inhabitant)configBeanInhabitant, beanContract.getName(), name);
            }
        }
        for (Map.Entry cbi : managed.entrySet()) {
            String index = (String)cbi.getKey();
            if (null != index) {
                StringBuilder sb = new StringBuilder();
                index = InhabitantsParser.parseIndex((String)index, (StringBuilder)sb);
                if (null == name) {
                    name = 0 == sb.length() ? null : sb.toString();
                }
            }
            for (ConfigByInhabitant i : (List)cbi.getValue()) {
                if (null == index) {
                    this.habitat.addIndex((Inhabitant)i, i.typeName(), name);
                } else {
                    this.habitat.addIndex((Inhabitant)i, index, name);
                }
                if (null == this.activator) {
                    Object service = i.get();
                    assert (null != service);
                    continue;
                }
                this.activator.activate((Inhabitant)i);
            }
        }
        this.beanToManagedConfigBy.put(bean, managed);
        if (null != this.activator) {
            try {
                this.activator.awaitCompletion();
            }
            catch (InterruptedException e) {
                throw new ComponentException((Throwable)e);
            }
        }
    }

    void unmanage(Object bean, Set<Class<?>> beanContracts, String name) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "unmanaging: {0}, {1}, {2}", new Object[]{bean, name, beanContracts});
        }
        MultiMap<String, ConfigByInhabitant> managed = this.beanToManagedConfigBy.remove(bean);
        for (Map.Entry entry : managed.entrySet()) {
            String index = (String)entry.getKey();
            if (null != index) {
                index = InhabitantsParser.parseIndex((String)index, null);
            }
            for (ConfigByInhabitant i : (List)entry.getValue()) {
                boolean removed = null == index ? this.habitat.removeIndex(i.typeName(), (Object)i) : this.habitat.removeIndex(index, (Object)i);
                assert (removed);
                i.release();
            }
        }
        if (null != beanContracts) {
            for (Class clazz : beanContracts) {
                boolean removed = this.habitat.removeIndex(clazz.getName(), bean);
                assert (removed);
            }
        }
    }
}

