/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.glassfish.hk2.classmodel.reflect.ExtensibleType;
import org.glassfish.hk2.classmodel.reflect.FieldModel;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.ParameterizedInterfaceModel;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.impl.ParameterizedInterfaceModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.TypeImpl;
import org.glassfish.hk2.classmodel.reflect.impl.TypeProxy;

public abstract class ExtensibleTypeImpl<T extends ExtensibleType>
extends TypeImpl
implements ExtensibleType<T> {
    private TypeProxy<?> parent;
    private final List<FieldModel> staticFields = new ArrayList<FieldModel>();
    private final List<TypeProxy<InterfaceModel>> implementedIntf = new ArrayList<TypeProxy<InterfaceModel>>();
    private final List<ParameterizedInterfaceModel> implementedParameterizedIntf = new ArrayList<ParameterizedInterfaceModel>();

    public ExtensibleTypeImpl(String name, TypeProxy<Type> sink, TypeProxy parent) {
        super(name, sink);
        this.parent = parent;
    }

    @Override
    public T getParent() {
        if (this.parent != null) {
            return (T)((ExtensibleType)this.parent.get());
        }
        return null;
    }

    public synchronized TypeProxy<?> setParent(TypeProxy<?> parent) {
        if (null == this.parent) {
            this.parent = parent;
        }
        return this.parent;
    }

    synchronized void isImplementing(TypeProxy<InterfaceModel> intf) {
        this.implementedIntf.add(intf);
    }

    synchronized void isImplementing(ParameterizedInterfaceModelImpl pim) {
        this.implementedIntf.add(pim.rawInterface);
        this.implementedParameterizedIntf.add(pim);
    }

    @Override
    public Collection<InterfaceModel> getInterfaces() {
        return TypeProxy.adapter(Collections.unmodifiableCollection(this.implementedIntf));
    }

    @Override
    public Collection<ParameterizedInterfaceModel> getParameterizedInterfaces() {
        return Collections.unmodifiableCollection(this.implementedParameterizedIntf);
    }

    @Override
    public Collection<T> subTypes() {
        ArrayList<ExtensibleType> subTypes = new ArrayList<ExtensibleType>();
        for (Type t : this.sink.getSubTypeRefs()) {
            subTypes.add((ExtensibleType)t);
        }
        return subTypes;
    }

    @Override
    public Collection<T> allSubTypes() {
        Collection<T> allTypes = this.subTypes();
        for (ExtensibleType child : this.subTypes()) {
            allTypes.addAll(child.allSubTypes());
        }
        return allTypes;
    }

    synchronized void addStaticField(FieldModel field) {
        this.staticFields.add(field);
    }

    void addField(FieldModel field) {
        throw new RuntimeException("Cannot add a field to a non classmodel type");
    }

    @Override
    public Collection<FieldModel> getStaticFields() {
        return Collections.unmodifiableCollection(this.staticFields);
    }

    @Override
    protected void print(StringBuffer sb) {
        super.print(sb);
        sb.append(", parent=").append(this.parent == null ? "null" : this.parent.getName());
        sb.append(", interfaces=[");
        for (TypeProxy<InterfaceModel> im : this.implementedIntf) {
            sb.append(" ").append(im.getName());
        }
        sb.append("]");
    }
}

