/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import org.glassfish.grizzly.servlet.DispatcherType;
import org.glassfish.grizzly.servlet.Registration;
import org.glassfish.grizzly.servlet.WebappContext;

public class FilterRegistration
extends Registration {
    protected Class<? extends Filter> filterClass;
    protected final Map<String[], Byte> servletNames;
    protected final Map<String[], Byte> urlPatterns;
    protected Filter filter;

    protected FilterRegistration(WebappContext ctx, String name, String filterClassName) {
        super(ctx, name, filterClassName);
        this.initParameters = new HashMap(4, 1.0f);
        this.servletNames = new HashMap<String[], Byte>(4, 1.0f);
        this.urlPatterns = new HashMap<String[], Byte>(4, 1.0f);
    }

    protected FilterRegistration(WebappContext ctx, String name, Class<? extends Filter> filter) {
        this(ctx, name, filter.getName());
        this.filterClass = filter;
    }

    protected FilterRegistration(WebappContext ctx, String name, Filter filter) {
        this(ctx, name, filter.getClass());
        this.filter = filter;
    }

    public void addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, String ... servletNames) {
        this.addMapping(this.servletNames, servletNames, dispatcherTypes, "servletNames");
    }

    public Collection<String> getServletNameMappings() {
        return Collections.unmodifiableSet(this.getUnifiedKeyView(this.servletNames));
    }

    public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, String ... urlPatterns) {
        this.addMapping(this.urlPatterns, urlPatterns, dispatcherTypes, "urlPatterns");
    }

    public Collection<String> getUrlPatternMappings() {
        return Collections.unmodifiableSet(this.getUnifiedKeyView(this.urlPatterns));
    }

    protected byte getDispatcherMask(EnumSet<DispatcherType> dispatcherType) {
        byte types = 0;
        if (dispatcherType != null && !dispatcherType.isEmpty()) {
            for (DispatcherType d : dispatcherType) {
                types = (byte)(types | d.type());
            }
        } else {
            types = (byte)(types | DispatcherType.REQUEST.type());
        }
        return types;
    }

    protected boolean isDispatcherSet(byte dispatcherTypeMask, DispatcherType dispatcherType) {
        return (dispatcherTypeMask & dispatcherType.type()) != 0;
    }

    private void addMapping(Map<String[], Byte> map, String[] mappings, EnumSet<DispatcherType> dispatcherTypes, String arrayArgumentName) {
        if (this.ctx.deployed) {
            throw new IllegalStateException("WebappContext has already been deployed");
        }
        if (mappings == null || mappings.length == 0) {
            throw new IllegalArgumentException('\'' + arrayArgumentName + "' is null or zero-length");
        }
        map.put(mappings, this.getDispatcherMask(dispatcherTypes));
    }

    private Set<String> getUnifiedKeyView(Map<String[], Byte> map) {
        Set<String> names;
        if (!map.isEmpty()) {
            names = new LinkedHashSet();
            for (String[] mappings : map.keySet()) {
                int len = mappings.length;
                for (int i = 0; i < len; ++i) {
                    names.add(mappings[i]);
                }
            }
        } else {
            names = Collections.emptySet();
        }
        return names;
    }
}

