/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.SSLEngineFactory;
import com.ning.http.client.providers.grizzly.TransportCustomizer;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.glassfish.grizzly.connectionpool.MultiEndpointPool;

public class GrizzlyAsyncHttpProviderConfig
implements AsyncHttpProviderConfig<Property, Object> {
    private final Map<Property, Object> attributes = new HashMap<Property, Object>();
    protected MultiEndpointPool<SocketAddress> connectionPool;
    private SSLEngineFactory sslEngineFactory;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AsyncHttpProviderConfig addProperty(Property name, Object value) {
        if (name == null) {
            return this;
        }
        if (value == null) {
            if (!name.hasDefaultValue()) return this;
            value = name.defaultValue;
        } else if (!name.type.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException(String.format("The value of property [%s] must be of type [%s].  Type of value provided: [%s].", name.name(), name.type.getName(), value.getClass().getName()));
        }
        this.attributes.put(name, value);
        return this;
    }

    @Override
    public Object getProperty(Property name) {
        Object ret = this.attributes.get((Object)name);
        if (ret == null && name.hasDefaultValue()) {
            ret = name.defaultValue;
        }
        return ret;
    }

    @Override
    public Object removeProperty(Property name) {
        if (name == null) {
            return null;
        }
        return this.attributes.remove((Object)name);
    }

    @Override
    public Set<Map.Entry<Property, Object>> propertiesSet() {
        return this.attributes.entrySet();
    }

    public MultiEndpointPool<SocketAddress> getConnectionPool() {
        return this.connectionPool;
    }

    public void setConnectionPool(MultiEndpointPool<SocketAddress> connectionPool) {
        this.connectionPool = connectionPool;
    }

    public SSLEngineFactory getSslEngineFactory() {
        return this.sslEngineFactory;
    }

    public void setSslEngineFactory(SSLEngineFactory sslEngineFactory) {
        this.sslEngineFactory = sslEngineFactory;
    }

    public static enum Property {
        TRANSPORT_CUSTOMIZER(TransportCustomizer.class),
        MAX_HTTP_PACKET_HEADER_SIZE(Integer.class, 8192),
        BUFFER_WEBSOCKET_FRAGMENTS(Boolean.class, true),
        DECOMPRESS_RESPONSE(Boolean.class, true);

        final Object defaultValue;
        final Class<?> type;

        private Property(Class<?> type, Object defaultValue) {
            this.type = type;
            this.defaultValue = defaultValue;
        }

        private Property(Class<?> type) {
            this(type, null);
        }

        boolean hasDefaultValue() {
            return this.defaultValue != null;
        }
    }
}

