/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine.groups;

import javax.validation.groups.Default;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group {
    private Class<?> group;
    private Class<?> sequence;

    public Group(Class<?> group) {
        this(group, null);
    }

    public Group(Class<?> group, Class<?> sequence) {
        this.group = group;
        this.sequence = sequence;
    }

    public Class<?> getGroup() {
        return this.group;
    }

    public boolean partOfSequence() {
        return this.sequence != null;
    }

    public Class<?> getSequence() {
        return this.sequence;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Group group1 = (Group)o;
        if (this.group != null ? !this.group.equals(group1.group) : group1.group != null) {
            return false;
        }
        return !(this.sequence != null ? !this.sequence.equals(group1.sequence) : group1.sequence != null);
    }

    public boolean isDefaultGroup() {
        return this.getGroup().getName().equals(Default.class.getName());
    }

    public int hashCode() {
        int result = this.group != null ? this.group.hashCode() : 0;
        result = 31 * result + (this.sequence != null ? this.sequence.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Group{groups=" + this.group + ", sequence=" + this.sequence + '}';
    }
}

