/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ValidationException;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.validation.constraints.AssertFalseValidator;
import org.hibernate.validation.constraints.AssertTrueValidator;
import org.hibernate.validation.constraints.DigitsValidatorForNumber;
import org.hibernate.validation.constraints.DigitsValidatorForString;
import org.hibernate.validation.constraints.FutureValidatorForCalendar;
import org.hibernate.validation.constraints.FutureValidatorForDate;
import org.hibernate.validation.constraints.MaxValidatorForNumber;
import org.hibernate.validation.constraints.MaxValidatorForString;
import org.hibernate.validation.constraints.MinValidatorForNumber;
import org.hibernate.validation.constraints.MinValidatorForString;
import org.hibernate.validation.constraints.NotNullValidator;
import org.hibernate.validation.constraints.NullValidator;
import org.hibernate.validation.constraints.PastValidatorForCalendar;
import org.hibernate.validation.constraints.PastValidatorForDate;
import org.hibernate.validation.constraints.PatternValidator;
import org.hibernate.validation.constraints.SizeValidatorForArray;
import org.hibernate.validation.constraints.SizeValidatorForCollection;
import org.hibernate.validation.constraints.SizeValidatorForMap;
import org.hibernate.validation.constraints.SizeValidatorForString;
import org.hibernate.validation.util.LoggerFactory;
import org.hibernate.validation.util.ReflectionHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintHelper {
    private static final Logger log = LoggerFactory.make();
    private final Map<Class<? extends Annotation>, List<Class<? extends ConstraintValidator<?, ?>>>> builtinConstraints = new HashMap();

    public ConstraintHelper() {
        ArrayList<Class<PatternValidator>> constraintList = new ArrayList<Class<PatternValidator>>();
        constraintList.add(AssertFalseValidator.class);
        this.builtinConstraints.put(AssertFalse.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(AssertTrueValidator.class);
        this.builtinConstraints.put(AssertTrue.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(FutureValidatorForCalendar.class);
        constraintList.add(FutureValidatorForDate.class);
        this.builtinConstraints.put(Future.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(MaxValidatorForNumber.class);
        constraintList.add(MaxValidatorForString.class);
        this.builtinConstraints.put(Max.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(MinValidatorForNumber.class);
        constraintList.add(MinValidatorForString.class);
        this.builtinConstraints.put(Min.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(NotNullValidator.class);
        this.builtinConstraints.put(NotNull.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(NullValidator.class);
        this.builtinConstraints.put(Null.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(PastValidatorForCalendar.class);
        constraintList.add(PastValidatorForDate.class);
        this.builtinConstraints.put(Past.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(DigitsValidatorForString.class);
        constraintList.add(DigitsValidatorForNumber.class);
        this.builtinConstraints.put(Digits.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(SizeValidatorForString.class);
        constraintList.add(SizeValidatorForCollection.class);
        constraintList.add(SizeValidatorForArray.class);
        constraintList.add(SizeValidatorForMap.class);
        this.builtinConstraints.put(Size.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(PatternValidator.class);
        this.builtinConstraints.put(Pattern.class, constraintList);
    }

    public <T extends Annotation> List<Class<? extends ConstraintValidator<T, ?>>> getBuiltInConstraints(T annotation) {
        List<Class<ConstraintValidator<?, ?>>> builtInList = this.getBuiltInFromAnnotationType(annotation.annotationType());
        if (builtInList == null || builtInList.size() == 0) {
            throw new ValidationException("Unable to find constraints for  " + annotation.annotationType());
        }
        ArrayList constraints = new ArrayList(builtInList.size());
        Iterator<Class<ConstraintValidator<?, ?>>> i$ = builtInList.iterator();
        while (i$.hasNext()) {
            Class<ConstraintValidator<?, ?>> validatorClass;
            Class<ConstraintValidator<?, ?>> safeValdiatorClass = validatorClass = i$.next();
            constraints.add(safeValdiatorClass);
        }
        return constraints;
    }

    private List<Class<? extends ConstraintValidator<?, ?>>> getBuiltInFromAnnotationType(Class<?> annotationType) {
        return this.builtinConstraints.get(annotationType);
    }

    public boolean isBuiltinConstraint(Annotation annotation) {
        return this.builtinConstraints.containsKey(annotation.annotationType());
    }

    public boolean isMultiValueConstraint(Annotation annotation) {
        boolean isMultiValueConstraint;
        block6: {
            isMultiValueConstraint = false;
            try {
                Annotation[] annotations;
                Method m = annotation.getClass().getMethod("value", new Class[0]);
                Class<?> returnType = m.getReturnType();
                if (!returnType.isArray() || !returnType.getComponentType().isAnnotation()) break block6;
                for (Annotation a : annotations = (Annotation[])m.invoke((Object)annotation, new Object[0])) {
                    if (!this.isConstraintAnnotation(a) && !this.isBuiltinConstraint(a)) {
                        isMultiValueConstraint = false;
                        break;
                    }
                    isMultiValueConstraint = true;
                }
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (IllegalAccessException iae) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return isMultiValueConstraint;
    }

    public <A extends Annotation> List<Annotation> getMultiValueConstraints(A annotation) {
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        try {
            Method m = annotation.getClass().getMethod("value", new Class[0]);
            Class<?> returnType = m.getReturnType();
            if (returnType.isArray() && returnType.getComponentType().isAnnotation()) {
                Annotation[] annotations;
                for (Annotation a : annotations = (Annotation[])m.invoke(annotation, new Object[0])) {
                    if (!this.isConstraintAnnotation(a) && !this.isBuiltinConstraint(a)) continue;
                    annotationList.add(a);
                }
            }
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return annotationList;
    }

    public boolean isConstraintAnnotation(Annotation annotation) {
        Method[] methods;
        Constraint constraint = annotation.annotationType().getAnnotation(Constraint.class);
        if (constraint == null) {
            return false;
        }
        try {
            ReflectionHelper.getAnnotationParameter(annotation, "message", String.class);
        }
        catch (Exception e) {
            String msg = annotation.annotationType().getName() + " contains Constraint annotation, but does " + "not contain a message parameter. Annotation is getting ignored.";
            log.warn(msg);
            return false;
        }
        try {
            ReflectionHelper.getAnnotationParameter(annotation, "groups", Class[].class);
        }
        catch (Exception e) {
            String msg = annotation.annotationType().getName() + " contains Constraint annotation, but does " + "not contain a groups parameter. Annotation is getting ignored.";
            log.warn(msg);
            return false;
        }
        for (Method m : methods = annotation.getClass().getMethods()) {
            if (!m.getName().startsWith("valid")) continue;
            String msg = "Parameters starting with 'valid' are not allowed in a constraint.";
            log.warn(msg);
            return false;
        }
        return true;
    }
}

