/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.usm.SnmpUsmAlgorithmImpl;
import com.sun.management.snmp.usm.SnmpUsmAuthAlgorithm;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class SnmpUsmHmacAlgorithm
extends SnmpUsmAlgorithmImpl
implements SnmpUsmAuthAlgorithm {
    String mdName = null;
    MessageDigest innerMD = null;
    MessageDigest md = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpUsmHmacAlgorithm");
    String dbgTag = "SnmpUsmHmacAlgorithm";

    protected SnmpUsmHmacAlgorithm(String algoName, String mdName) {
        super(algoName);
        this.mdName = mdName;
        try {
            this.innerMD = MessageDigest.getInstance(mdName);
            this.md = MessageDigest.getInstance(mdName);
        }
        catch (NoSuchAlgorithmException e) {
            if (logger.finestOn()) {
                logger.finest("SnmpUsmHmacAlgorithm", e);
            }
            throw new IllegalArgumentException("No such algorithm: " + e);
        }
    }

    abstract int getBlockSize();

    abstract int getKeySize();

    public abstract int getDeltaSize();

    abstract int getPasswordToKeySize();

    public synchronized byte[] sign(byte[] key, byte[] data, int length) {
        int i;
        byte[] digest = null;
        byte[] ipad = null;
        byte[] opad = null;
        int kLen = key.length;
        int blockSize = this.getBlockSize();
        if (kLen > blockSize) {
            this.md.reset();
            this.md.update(key);
            key = this.md.digest();
            kLen = key.length;
        }
        ipad = new byte[blockSize];
        opad = new byte[blockSize];
        for (i = 0; i < blockSize; ++i) {
            while (i < key.length) {
                ipad[i] = key[i];
                opad[i] = key[i];
                ++i;
            }
            ipad[i] = 0;
            opad[i] = 0;
        }
        i = 0;
        while (i < 64) {
            int n = i;
            ipad[n] = (byte)(ipad[n] ^ 0x36);
            int n2 = i++;
            opad[n2] = (byte)(opad[n2] ^ 0x5C);
        }
        this.innerMD.reset();
        this.innerMD.update(ipad);
        this.innerMD.update(data, 0, length);
        digest = this.innerMD.digest();
        this.md.reset();
        this.md.update(opad);
        this.md.update(digest);
        digest = this.md.digest();
        byte[] res = new byte[12];
        for (int i2 = 0; i2 < 12; ++i2) {
            res[i2] = digest[i2];
        }
        return res;
    }

    public boolean verify(byte[] key, byte[] data, int length, byte[] signature) {
        int sigLen = signature.length;
        byte[] digest = this.sign(key, data, length);
        int digLen = digest.length;
        if (sigLen != digLen) {
            return false;
        }
        for (int i = 0; i < sigLen; ++i) {
            if (signature[i] == digest[i]) continue;
            return false;
        }
        return true;
    }

    public String toString(byte[] signature) {
        StringBuffer r = new StringBuffer();
        String hex = "0123456789ABCDEF";
        byte[] b = signature;
        for (int i = 0; i < 16; ++i) {
            int c = b[i] >>> 4 & 0xF;
            r.append("0123456789ABCDEF".charAt(c));
            c = b[i] & 0xF;
            r.append("0123456789ABCDEF".charAt(c));
        }
        return r.toString();
    }

    public synchronized byte[] password_to_key(String password) {
        int size = 0;
        this.md.reset();
        size = this.getPasswordToKeySize();
        return this.password_to_key(this.md, password, size);
    }

    public synchronized byte[] localizeAuthKey(byte[] key, SnmpEngineId engineId) {
        this.md.reset();
        this.md.update(key);
        this.md.update(engineId.getBytes());
        this.md.update(key);
        return this.md.digest();
    }

    public byte[] localizePrivKey(byte[] key, SnmpEngineId engineId, int keysize) {
        byte[] k = this.localizeAuthKey(key, engineId);
        byte[] privK = new byte[keysize];
        for (int i = 0; i < keysize; ++i) {
            privK[i] = k[i];
        }
        return privK;
    }

    public byte[] calculateAuthDelta(byte[] oldKey, byte[] newKey, byte[] random) {
        return this.calculateDelta(oldKey, newKey, random, this.getDeltaSize());
    }

    public byte[] calculatePrivDelta(byte[] oldKey, byte[] newKey, byte[] random, int deltaSize) {
        return this.calculateDelta(oldKey, newKey, random, deltaSize);
    }

    private synchronized byte[] calculateDelta(byte[] oldKey, byte[] newKey, byte[] random, int deltaSize) {
        byte[] temp = null;
        byte[] delta = new byte[deltaSize];
        int i = 0;
        if (newKey.length > deltaSize) {
            temp = new byte[oldKey.length];
            for (i = 0; i < oldKey.length; ++i) {
                temp[i] = oldKey[i];
            }
            int iterations = (deltaSize - 1) / deltaSize;
            for (i = 0; i < iterations; ++i) {
                this.md.reset();
                this.md.update(temp);
                this.md.update(random);
                temp = this.md.digest();
                for (int j = i * deltaSize; j < deltaSize * i + deltaSize; ++j) {
                    delta[j] = temp[j];
                    int n = j;
                    delta[n] = (byte)(delta[n] ^ newKey[j]);
                }
            }
        } else {
            temp = oldKey;
        }
        this.md.reset();
        this.md.update(temp);
        this.md.update(random);
        temp = this.md.digest();
        for (int cpt = i * deltaSize; cpt < deltaSize; ++cpt) {
            delta[cpt] = temp[cpt];
            int n = cpt;
            delta[n] = (byte)(delta[n] ^ newKey[cpt]);
        }
        return delta;
    }

    public byte[] calculateNewAuthKey(byte[] oldKey, byte[] randomdelta) {
        return this.calculateNewKey(oldKey, randomdelta, this.getDeltaSize());
    }

    public byte[] calculateNewPrivKey(byte[] oldKey, byte[] randomdelta, int deltaSize) {
        return this.calculateNewKey(oldKey, randomdelta, deltaSize);
    }

    private synchronized byte[] calculateNewKey(byte[] oldKey, byte[] randomdelta, int deltaSize) {
        byte[] temp = null;
        byte[] newKey = new byte[oldKey.length];
        int i = 0;
        byte[] random = new byte[deltaSize];
        byte[] delta = new byte[deltaSize];
        for (i = 0; i < deltaSize; ++i) {
            random[i] = randomdelta[i];
            delta[i] = randomdelta[i + deltaSize];
        }
        i = 0;
        if (newKey.length > deltaSize) {
            int iterations = (deltaSize - 1) / deltaSize;
            temp = new byte[oldKey.length];
            for (i = 0; i < oldKey.length; ++i) {
                temp[i] = oldKey[i];
            }
            for (i = 0; i < iterations; ++i) {
                this.md.reset();
                this.md.update(temp);
                this.md.update(random);
                temp = this.md.digest();
                for (int j = i * deltaSize; j < deltaSize * i + deltaSize; ++j) {
                    newKey[j] = temp[j];
                    int n = j;
                    newKey[n] = (byte)(newKey[n] ^ delta[j]);
                }
            }
        } else {
            temp = oldKey;
        }
        this.md.reset();
        this.md.update(temp);
        this.md.update(random);
        temp = this.md.digest();
        for (int cpt = i * deltaSize; cpt < deltaSize; ++cpt) {
            newKey[cpt] = temp[cpt];
            int n = cpt;
            newKey[n] = (byte)(newKey[n] ^ delta[cpt]);
        }
        return newKey;
    }

    private synchronized byte[] password_to_key(MessageDigest md, String pass, int size) {
        byte[] passBuffer = new byte[size];
        byte[] password = pass.getBytes();
        int passwordlen = pass.length();
        int password_index = 0;
        for (int count = 0; count < 0x100000; count += 64) {
            for (int i = 0; i < 64; ++i) {
                passBuffer[i] = password[password_index++ % passwordlen];
            }
            md.update(passBuffer, 0, 64);
        }
        return md.digest();
    }
}

