/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm;

import com.sun.jdmk.defaults.Utils;
import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpEncryptionPair;
import com.sun.management.internal.snmp.SnmpTools;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.usm.SnmpUsmAlgorithmImpl;
import com.sun.management.snmp.usm.SnmpUsmException;
import com.sun.management.snmp.usm.SnmpUsmKey;
import com.sun.management.snmp.usm.SnmpUsmPrivAlgorithm;
import com.sun.management.snmp.usm.SnmpUsmPrivException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class SnmpUsmDesAlgorithm
extends SnmpUsmAlgorithmImpl
implements SnmpUsmPrivAlgorithm {
    private long random = -1L;
    private String properties_decrypt = null;
    private String properties_encrypt = null;
    public static final String DES_PRIV = "usmDESPrivProtocol";
    private Cipher cipher_encrypt = null;
    private Cipher cipher_decrypt = null;
    private SnmpEngine engine = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpUsmDesAlgorithm");
    String dbgTag = "SnmpUsmDesAlgorithm";

    private synchronized long getRandom() {
        ++this.random;
        return this.random;
    }

    public SnmpUsmDesAlgorithm(SnmpEngine engine) throws SnmpUsmException {
        super(DES_PRIV);
        this.engine = engine;
        this.random = System.currentTimeMillis();
        this.properties_encrypt = "DES/CBC/NoPadding";
        this.properties_decrypt = "DES/CBC/NoPadding";
        try {
            this.cipher_encrypt = Cipher.getInstance(this.properties_encrypt);
            this.cipher_decrypt = Cipher.getInstance(this.properties_decrypt);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new SnmpUsmPrivException("NoSuchAlgorithmException");
        }
        catch (NoSuchPaddingException e2) {
            e2.printStackTrace();
            throw new SnmpUsmPrivException("NoSuchPaddingException");
        }
    }

    public SnmpUsmDesAlgorithm(SnmpEngine engine, String properties_encrypt, String properties_decrypt) throws SnmpUsmException {
        super(DES_PRIV);
        this.properties_encrypt = properties_encrypt;
        this.properties_decrypt = properties_decrypt;
        this.engine = engine;
        try {
            this.cipher_encrypt = Cipher.getInstance(properties_encrypt);
            this.cipher_decrypt = Cipher.getInstance(properties_decrypt);
        }
        catch (NoSuchAlgorithmException x) {
            if (logger.finestOn()) {
                logger.finest("SnmpUsmDesAlgorithm", "No such algorithm: " + x);
            }
            throw new SnmpUsmPrivException("No such algorithm: " + x);
        }
        catch (NoSuchPaddingException x) {
            if (logger.finestOn()) {
                logger.finest("SnmpUsmDesAlgorithm", "No such padding: " + x);
            }
            throw new SnmpUsmPrivException("No such padding: " + x);
        }
    }

    public int getKeySize() {
        return 16;
    }

    public int getDeltaSize() {
        return 16;
    }

    public String getOid() {
        return "1.3.6.1.6.3.10.1.2.2";
    }

    private byte[] genDesKey(byte[] key) {
        byte[] desKey = new byte[8];
        desKey[7] = 0;
        for (int i = 6; i >= 0; --i) {
            int offset = 6 - i;
            desKey[i] = key[i + 1];
            desKey[i] = (byte)(desKey[i] >>> 1);
            desKey[i] = (byte)(desKey[i] & 0x7F);
            for (int j = offset; j > 0; --j) {
                byte bit = (byte)(desKey[i] & 1);
                desKey[i] = (byte)(desKey[i] >>> 1);
                desKey[i] = (byte)(desKey[i] & 0x7F);
                bit = (byte)(bit << 8 - j);
                desKey[i + 1] = (byte)(desKey[i + 1] | bit);
            }
        }
        desKey[0] = (byte)(desKey[0] | key[0] & 0xFE);
        return desKey;
    }

    public synchronized SnmpEncryptionPair encrypt(byte[] key, byte[] data, int dataLength) throws SnmpUsmException {
        int remain = dataLength % 8;
        int toadd = 0;
        byte[] paddedData = data;
        int paddedDataLength = dataLength;
        if (remain != 0) {
            toadd = 8 - remain;
            if (logger.finestOn()) {
                logger.finest("encrypt", " Padding, must add : " + toadd);
            }
            paddedData = new byte[dataLength + toadd];
            paddedDataLength = paddedData.length;
            for (int i = 0; i < dataLength; ++i) {
                paddedData[i] = data[i];
            }
        }
        if (logger.finestOn()) {
            logger.finest("encrypt", "encrypt using :\t" + this.properties_encrypt + "\tkey length :" + key.length + "\tkey :" + SnmpTools.binary2ascii(key) + "\tdata length :" + paddedDataLength + "\tstart time:" + System.currentTimeMillis());
        }
        SnmpEncryptionPair pair = new SnmpEncryptionPair();
        int boots = this.engine.getEngineBoots();
        long random = this.getRandom();
        if (key.length != 16) {
            throw new SnmpUsmPrivException("Invalid key size :" + key.length);
        }
        if (logger.finestOn()) {
            logger.finest("encrypt", "encrypt using :\t" + this.properties_encrypt + "\tGen key start time:" + System.currentTimeMillis());
        }
        DESKeySpec jdesKey = null;
        try {
            jdesKey = new DESKeySpec(key);
        }
        catch (InvalidKeyException x) {
            if (logger.finestOn()) {
                logger.finest("decrypt :", "Invalid key: " + x);
            }
            throw new SnmpUsmPrivException("Invalid key: " + x);
        }
        if (logger.finestOn()) {
            logger.finest("encrypt", "encrypt using :\t" + this.properties_encrypt);
        }
        byte[] iv = new byte[8];
        if (logger.finestOn()) {
            logger.finest("encrypt", "encrypt using :\t" + this.properties_encrypt + "\tGen key start time:" + System.currentTimeMillis());
        }
        byte[] salt = new byte[]{(byte)(boots & 0xFF000000), (byte)(boots & 0xFF0000), (byte)(boots & 0xFF00), (byte)(boots & 0xFF), (byte)(random & 0xFFFFFFFFFF000000L), (byte)(random & 0xFF0000L), (byte)(random & 0xFF00L), (byte)(random & 0xFFL)};
        for (int i = 0; i < 8; ++i) {
            iv[i] = key[i + 8];
            int n = i;
            iv[n] = (byte)(iv[n] ^ salt[i]);
        }
        if (logger.finestOn()) {
            logger.finest("encrypt", "encrypt using :\t" + this.properties_encrypt + "\tSalt end time:" + System.currentTimeMillis());
        }
        pair.parameters = salt;
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        try {
            this.cipher_encrypt.init(1, (Key)new SnmpUsmKey(jdesKey.getKey()), ivSpec);
        }
        catch (InvalidKeyException x) {
            throw new SnmpUsmPrivException("Invalid key: " + x);
        }
        catch (InvalidAlgorithmParameterException x) {
            if (logger.finestOn()) {
                logger.finest("encrypt :", "Invalid algorithm parameter: " + x);
            }
            throw new SnmpUsmPrivException("Invalid algorithm parameter: " + x);
        }
        try {
            pair.encryptedData = this.cipher_encrypt.doFinal(paddedData, 0, paddedDataLength);
        }
        catch (IllegalBlockSizeException x) {
            if (logger.finestOn()) {
                logger.finest("encrypt :", "Illegal block size: " + x);
            }
            throw new SnmpUsmPrivException("Illegal block size: " + x);
        }
        catch (BadPaddingException x) {
            if (logger.finestOn()) {
                logger.finest("encrypt :", "Bad padding: " + x);
            }
            throw new SnmpUsmPrivException("Bad padding: " + x);
        }
        catch (Exception x) {
            if (logger.finestOn()) {
                logger.finest("encrypt :", "Unexpected exception: " + x);
            }
            SnmpUsmPrivException sp = new SnmpUsmPrivException("Unexpected exception: " + x);
            Utils.initCause(sp, x);
            throw sp;
        }
        if (logger.finestOn()) {
            logger.finest("encrypt", "Over params length :" + pair.parameters.length + " encrypted data length :" + pair.encryptedData.length);
        }
        if (logger.finestOn()) {
            logger.finest("encrypt", "encrypt using :\t" + this.properties_encrypt + "\tENCRYPT end time:" + System.currentTimeMillis());
        }
        if (logger.finestOn()) {
            logger.finest("encrypt", "Encryption input :" + SnmpTools.binary2ascii(paddedData, paddedDataLength));
            logger.finest("encrypt", "Encryption output :" + SnmpTools.binary2ascii(pair.encryptedData));
        }
        return pair;
    }

    public synchronized byte[] decrypt(byte[] key, SnmpEncryptionPair pair) throws SnmpUsmException {
        if (logger.finestOn()) {
            logger.finest("decrypt", "decrypt using :\t" + this.properties_decrypt + "\tkey length :" + key.length + "\tdata length :" + pair.encryptedData.length + "\t priv parameters : " + SnmpTools.binary2ascii(pair.parameters));
        }
        if (pair.encryptedData == null) {
            if (logger.finestOn()) {
                logger.finest("decrypt :", "encrypted data is null, error.");
            }
            throw new SnmpUsmPrivException("Invalid encrypted data.");
        }
        int remain = pair.encryptedData.length % 8;
        if (remain != 0) {
            if (logger.finestOn()) {
                logger.finest("decrypt :", "encrypted data length is not OK, error.");
            }
            throw new SnmpUsmPrivException("Invalid encrypted data length.");
        }
        DESKeySpec jdesKey = null;
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = key[i + 8];
            int n = i;
            iv[n] = (byte)(iv[n] ^ pair.parameters[i]);
        }
        try {
            jdesKey = new DESKeySpec(key);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            this.cipher_decrypt.init(2, (Key)new SnmpUsmKey(jdesKey.getKey()), ivSpec);
        }
        catch (InvalidKeyException x) {
            if (logger.finestOn()) {
                logger.finest("decrypt :", "Invalid key: " + x);
            }
            throw new SnmpUsmPrivException("Invalid key: " + x);
        }
        catch (InvalidAlgorithmParameterException x) {
            if (logger.finestOn()) {
                logger.finest("decrypt :", "Invalid algorithm parameter: " + x);
            }
            throw new SnmpUsmPrivException("Invalid algorithm parameter: " + x);
        }
        byte[] dec = null;
        try {
            dec = this.cipher_decrypt.doFinal(pair.encryptedData);
        }
        catch (IllegalBlockSizeException x) {
            if (logger.finestOn()) {
                logger.finest("decrypt :", "Illegal block size: " + x);
            }
            throw new SnmpUsmPrivException("Illegal block size: " + x);
        }
        catch (BadPaddingException x) {
            if (logger.finestOn()) {
                logger.finest("decrypt :", "Bad padding: " + x);
            }
            throw new SnmpUsmPrivException("Bad padding: " + x);
        }
        catch (Exception x) {
            if (logger.finestOn()) {
                logger.finest("decrypt :", "Unexpected exception: " + x);
            }
            SnmpUsmPrivException sp = new SnmpUsmPrivException("Unexpected Exception: " + x);
            Utils.initCause(sp, x);
            throw sp;
        }
        if (logger.finestOn()) {
            logger.finest("decrypt :", " Decryption input : " + SnmpTools.binary2ascii(pair.encryptedData));
            logger.finest("decrypt :", " Decryption output : " + SnmpTools.binary2ascii(dec));
        }
        return dec;
    }
}

