/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.internal.snmp.SnmpIncomingResponse;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpMsg;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpPduRequestType;
import com.sun.management.snmp.SnmpSecurityException;
import com.sun.management.snmp.manager.SnmpQManager;
import com.sun.management.snmp.manager.SnmpRequest;
import com.sun.management.snmp.manager.SnmpSession;
import java.net.DatagramPacket;

class SnmpResponseHandler {
    SnmpQManager snmpq = null;
    SnmpSession session = null;
    SnmpEngineImpl engine = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpResponseHandler");
    String dbgTag = "SnmpResponseHandler";

    public SnmpResponseHandler(SnmpSession session) {
        this.snmpq = SnmpQManager.getTheInstance();
        this.session = session;
    }

    public SnmpResponseHandler(SnmpQManager q, SnmpSession session) {
        this.snmpq = q;
        this.session = session;
    }

    public void setEngine(SnmpEngine engine) {
        this.engine = (SnmpEngineImpl)engine;
    }

    public synchronized void processDatagram(DatagramPacket dgrm) {
        byte[] data = dgrm.getData();
        int datalen = dgrm.getLength();
        if (logger.finerOn()) {
            logger.finer("processDatagram", "Received from peer " + dgrm.getAddress().toString() + " Length = " + datalen + "\nDump : \n" + SnmpMsg.dumpHexBuffer(data, 0, datalen));
        }
        SnmpRequest req = null;
        try {
            int version = SnmpMsg.getProtocolVersion(dgrm.getData());
            SnmpPduFactory pduFactory = this.snmpq.findPduFactory(dgrm.getAddress(), dgrm.getPort());
            if (pduFactory == null) {
                if (logger.finestOn()) {
                    logger.finest("processDatagram", "Use the SnmpSession pdu factory.");
                }
                pduFactory = this.session.getPduFactory();
            } else if (logger.finestOn()) {
                logger.finest("processDatagram", "Use the SnmpPeer pdu factory.");
            }
            SnmpMsgProcessingSubSystem msgsys = this.engine.getMsgProcessingSubSystem();
            SnmpIncomingResponse resp = msgsys.getIncomingResponse(version, pduFactory);
            int msgId = resp.getRequestId(data);
            if (pduFactory == null) {
                if (logger.finestOn()) {
                    logger.finest("processDatagram", "Dropping packet. Unable to find the pdu factory for = " + dgrm.getAddress() + ":" + dgrm.getPort());
                }
                return;
            }
            req = this.snmpq.removeRequest(msgId);
            if (req == null) {
                if (logger.finestOn()) {
                    logger.finest("processDatagram", "Dropping packet. Unable to find corresponding for requestId = " + msgId);
                }
                return;
            }
            resp.setSecurityCache(req.getSecurityCache());
            SnmpPdu snmpProt = null;
            try {
                resp.decodeMessage(data, datalen, dgrm.getAddress(), dgrm.getPort());
                snmpProt = resp.decodeSnmpPdu();
            }
            catch (SnmpSecurityException e) {
                if (logger.finestOn()) {
                    logger.finest("processDatagram", " Security Exception when unmarshalling, status : " + e.status);
                }
                req.setErrorStatusAndIndex(e.status, 0);
                req.invokeOnResponse(null);
                return;
            }
            if (snmpProt == null) {
                if (logger.finestOn()) {
                    logger.finest("processDatagram", "Dropping packet. Pdu factory returned a null value");
                }
                return;
            }
            if (!(snmpProt instanceof SnmpPduRequestType)) {
                if (logger.finestOn()) {
                    logger.finest("processDatagram", "Dropping packet. The packet does not contain a response");
                }
                snmpProt = null;
                return;
            }
            SnmpPdu pduReq = snmpProt;
            req.setResponseSecurityParameters(resp.getSecurityParameters());
            req.invokeOnResponse(pduReq);
        }
        catch (Exception e) {
            if (logger.finestOn()) {
                logger.finest("processDatagram", "Exception while processing");
                logger.finest("processDatagram", e);
            }
            if (!this.session.isInvalidResponseErrorHidden()) {
                if (logger.finestOn()) {
                    logger.finest("processDatagram", "Error are not hidden.throw genErr.");
                }
                req.setErrorStatusAndIndex(5, 0);
                req.invokeOnResponse(null);
            }
            return;
        }
    }
}

