/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager;

import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.manager.SnmpQManager;
import com.sun.management.snmp.manager.SnmpRequest;
import java.net.InetAddress;
import java.util.Vector;

class SendQ
extends Vector {
    private static final long serialVersionUID = 7156215046287757465L;
    final long sendQ_pollMargin = 0L;
    boolean isBeingDestroyed = false;

    SendQ(int initialCapacity, int capacityIncr) {
        super(initialCapacity, capacityIncr);
    }

    public synchronized String printAllRequest(long time) {
        if (this.isEmpty()) {
            return "------- SendQ empty.......";
        }
        int max = this.size();
        StringBuffer str = new StringBuffer("\n------------------------ Requests in SendQ -> " + max);
        for (int i = 0; i < max; ++i) {
            SnmpRequest req = this.getRequestAt(i);
            str.append("\n" + i + ". (" + req.toString() + " RemainingTimeToSend = " + req.timeRemainingForAction(time) + "  ) ................................\n");
        }
        return str.toString();
    }

    private synchronized void notifyClients() {
        this.notifyAll();
    }

    public synchronized void addRequest(SnmpRequest req) {
        int i;
        long nextPoll = req.getAbsNextPollTime();
        for (i = this.size(); i > 0 && nextPoll >= this.getRequestAt(i - 1).getAbsNextPollTime(); --i) {
        }
        if (i == this.size()) {
            this.addElement(req);
            this.notifyClients();
        } else {
            this.insertElementAt(req, i);
        }
    }

    public synchronized SnmpRequest getOutstandingRequest() {
        this.waitUntilReady();
        SnmpRequest req = (SnmpRequest)this.lastElement();
        --this.elementCount;
        return req;
    }

    synchronized void introduceSleep(long tm) {
        long origtm = System.currentTimeMillis();
        while (true) {
            try {
                do {
                    this.wait(tm);
                } while (System.currentTimeMillis() - origtm < tm);
                return;
            }
            catch (Exception e) {
                continue;
            }
            break;
        }
    }

    public synchronized boolean waitUntilReady() {
        while (!this.isBeingDestroyed) {
            long tmp = 0L;
            if (!this.isEmpty()) {
                long currTime = System.currentTimeMillis();
                SnmpRequest req = (SnmpRequest)this.lastElement();
                tmp = req.getAbsNextPollTime() - currTime;
                if (tmp <= 0L) {
                    return true;
                }
            }
            this.waitOnThisQueue(tmp);
        }
        return false;
    }

    public synchronized Vector getAllOutstandingRequest(long margin) {
        Vector<SnmpRequest> outreq = new Vector<SnmpRequest>();
        while (this.waitUntilReady()) {
            SnmpRequest req;
            long refTime = System.currentTimeMillis() + margin;
            for (int i = this.size(); i > 0 && (req = this.getRequestAt(i - 1)).getAbsNextPollTime() <= refTime; --i) {
                outreq.addElement(req);
            }
            if (outreq.isEmpty()) continue;
            this.elementCount -= outreq.size();
            return outreq;
        }
        return null;
    }

    public synchronized void waitOnThisQueue(long time) {
        if (time == 0L && !this.isEmpty() && SnmpQManager.logger.finestOn()) {
            SnmpQManager.logger.finest("waitOnThisQueue", "[" + Thread.currentThread().toString() + "]:" + "Fatal BUG :: Blocking on newq permenantly. But size = " + this.size());
        }
        try {
            this.wait(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public SnmpRequest getRequestAt(int idx) {
        return (SnmpRequest)this.elementAt(idx);
    }

    public synchronized SnmpRequest removeRequest(long reqid) {
        int max = this.size();
        for (int i = 0; i < max; ++i) {
            SnmpRequest reqc = this.getRequestAt(i);
            if (reqid != (long)reqc.getRequestId()) continue;
            this.removeElementAt(i);
            return reqc;
        }
        return null;
    }

    public synchronized SnmpPduFactory findPduFactory(InetAddress address, int port) {
        SnmpPduFactory result = null;
        int max = this.size();
        for (int i = 0; i < max && result == null; ++i) {
            SnmpRequest reqc = this.getRequestAt(i);
            result = reqc.getSnmpSession().getPduFactory();
        }
        return result;
    }
}

