/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.defaults.Utils;
import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.agent.AcmChecker;
import com.sun.management.snmp.agent.SnmpMibAgent;
import com.sun.management.snmp.agent.SnmpMibNode;
import com.sun.management.snmp.agent.SnmpMibOid;
import com.sun.management.snmp.agent.SnmpMibRequest;
import com.sun.management.snmp.agent.SnmpMibRequestImpl;
import com.sun.management.snmp.agent.SnmpMibSubRequest;
import com.sun.management.snmp.agent.SnmpMibTable;
import com.sun.management.snmp.agent.SnmpRequestTree;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public abstract class SnmpMib
extends SnmpMibAgent
implements Serializable {
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpMib");
    protected SnmpMibOid root = new SnmpMibOid();
    private transient long[] rootOid = null;

    protected String getGroupOid(String groupName, String defaultOid) {
        return defaultOid;
    }

    protected ObjectName getGroupObjectName(String name, String oid, String defaultName) throws MalformedObjectNameException {
        return new ObjectName(defaultName);
    }

    protected void registerGroupNode(String groupName, String groupOid, ObjectName groupObjName, SnmpMibNode node, Object group, MBeanServer server) throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, IllegalAccessException {
        this.root.registerNode(groupOid, node);
        if (server != null && groupObjName != null && group != null) {
            server.registerMBean(group, groupObjName);
        }
    }

    public abstract void registerTableMeta(String var1, SnmpMibTable var2);

    public abstract SnmpMibTable getRegisteredTableMeta(String var1);

    public void get(SnmpMibRequest req) throws SnmpStatusException {
        int reqType = 160;
        SnmpRequestTree handlers = this.getHandlers(req, false, false, 160);
        SnmpRequestTree.Handler h = null;
        SnmpMibNode meta = null;
        boolean finest = logger.finestOn();
        if (finest) {
            logger.finest("get", "Processing handlers for GET... ");
        }
        Enumeration eh = handlers.getHandlers();
        while (eh.hasMoreElements()) {
            h = (SnmpRequestTree.Handler)eh.nextElement();
            if (finest) {
                logger.finest("get", "Got handler: " + h);
            }
            meta = handlers.getMetaNode(h);
            if (finest) {
                logger.finest("get", "Retrieved handler's meta: " + meta);
            }
            int depth = handlers.getOidDepth(h);
            if (finest) {
                logger.finest("get", "Retrieved meta's depth: " + depth);
            }
            Enumeration rqs = handlers.getSubRequests(h);
            while (rqs.hasMoreElements()) {
                if (finest) {
                    logger.finest("get", "invoke get for subrequest");
                }
                meta.get((SnmpMibSubRequest)rqs.nextElement(), depth);
            }
        }
    }

    public void set(SnmpMibRequest req) throws SnmpStatusException {
        SnmpRequestTree handlers = null;
        if (req instanceof SnmpMibRequestImpl) {
            handlers = ((SnmpMibRequestImpl)req).getRequestTree();
        }
        int reqType = 163;
        if (handlers == null) {
            handlers = this.getHandlers(req, false, true, 163);
        }
        handlers.switchCreationFlag(false);
        handlers.setPduType(163);
        SnmpRequestTree.Handler h = null;
        SnmpMibNode meta = null;
        if (logger.finestOn()) {
            logger.finest("set", "Processing handlers for SET... ");
        }
        Enumeration eh = handlers.getHandlers();
        while (eh.hasMoreElements()) {
            h = (SnmpRequestTree.Handler)eh.nextElement();
            meta = handlers.getMetaNode(h);
            int depth = handlers.getOidDepth(h);
            Enumeration rqs = handlers.getSubRequests(h);
            while (rqs.hasMoreElements()) {
                meta.set((SnmpMibSubRequest)rqs.nextElement(), depth);
            }
        }
    }

    public void check(SnmpMibRequest req) throws SnmpStatusException {
        int reqType = 253;
        SnmpRequestTree handlers = this.getHandlers(req, true, true, 253);
        SnmpRequestTree.Handler h = null;
        SnmpMibNode meta = null;
        if (logger.finestOn()) {
            logger.finest("check", "Processing handlers for CHECK... ");
        }
        Enumeration eh = handlers.getHandlers();
        while (eh.hasMoreElements()) {
            h = (SnmpRequestTree.Handler)eh.nextElement();
            meta = handlers.getMetaNode(h);
            int depth = handlers.getOidDepth(h);
            Enumeration rqs = handlers.getSubRequests(h);
            while (rqs.hasMoreElements()) {
                meta.check((SnmpMibSubRequest)rqs.nextElement(), depth);
            }
        }
        if (req instanceof SnmpMibRequestImpl) {
            ((SnmpMibRequestImpl)req).setRequestTree(handlers);
        }
    }

    public void getNext(SnmpMibRequest req) throws SnmpStatusException {
        SnmpRequestTree handlers = this.getGetNextHandlers(req);
        SnmpRequestTree.Handler h = null;
        SnmpMibNode meta = null;
        if (logger.finestOn()) {
            logger.finest("getNext", "Processing handlers for GET-NEXT... ");
        }
        Enumeration eh = handlers.getHandlers();
        while (eh.hasMoreElements()) {
            h = (SnmpRequestTree.Handler)eh.nextElement();
            meta = handlers.getMetaNode(h);
            int depth = handlers.getOidDepth(h);
            Enumeration rqs = handlers.getSubRequests(h);
            while (rqs.hasMoreElements()) {
                meta.get((SnmpMibSubRequest)rqs.nextElement(), depth);
            }
        }
    }

    public void getBulk(SnmpMibRequest req, int nonRepeat, int maxRepeat) throws SnmpStatusException {
        this.getBulkWithGetNext(req, nonRepeat, maxRepeat);
    }

    public long[] getRootOid() {
        if (this.rootOid == null) {
            Vector list = new Vector(10);
            this.root.getRootOid(list);
            this.rootOid = new long[list.size()];
            int i = 0;
            Enumeration e = list.elements();
            while (e.hasMoreElements()) {
                Integer val = (Integer)e.nextElement();
                this.rootOid[i++] = val.longValue();
            }
        }
        return this.rootOid;
    }

    private SnmpRequestTree getHandlers(SnmpMibRequest req, boolean createflag, boolean atomic, int type) throws SnmpStatusException {
        SnmpRequestTree handlers = new SnmpRequestTree(req, createflag, type);
        int index = 0;
        SnmpVarBind var = null;
        int ver = req.getVersion();
        Enumeration e = req.getElements();
        while (e.hasMoreElements()) {
            if (logger.finestOn()) {
                logger.finest("getHandlers", "Processing subrequest varbind #" + (index + 1));
            }
            var = (SnmpVarBind)e.nextElement();
            try {
                this.root.findHandlingNode(var, var.getOid().longValue(false), 0, handlers);
            }
            catch (SnmpStatusException x) {
                SnmpStatusException sn;
                int status;
                if (logger.finestOn()) {
                    logger.finest("getHandlers", "Couldn't find a handling node for " + var.getOid().toString());
                    logger.finest("getHandlers", "\tcaused by: " + x);
                }
                if (ver == 0) {
                    if (logger.finestOn()) {
                        logger.finest("getHandlers", "\tV1: Throwing exception");
                    }
                    throw new SnmpStatusException(x, index + 1);
                }
                if (type == 253 || type == 163) {
                    status = SnmpRequestTree.mapSetException(x.getStatus(), ver);
                    if (logger.finestOn()) {
                        logger.finest("getHandlers", "\tSET: Throwing exception");
                    }
                    sn = new SnmpStatusException(status, index + 1);
                    Utils.initCause(sn, x);
                    throw sn;
                }
                if (atomic) {
                    if (logger.finestOn()) {
                        logger.finest("getHandlers", "\tATOMIC: Throwing exception");
                    }
                    throw new SnmpStatusException(x, index + 1);
                }
                status = SnmpRequestTree.mapGetException(x.getStatus(), ver);
                if (status == 224) {
                    if (logger.finestOn()) {
                        logger.finest("getHandlers", "\tGET: Registering noSuchInstance");
                        logger.finest("getHandlers", "\tcaused by: " + x);
                        logger.finest("getHandlers", x);
                    }
                    var.setSnmpValue(SnmpVarBind.noSuchInstance);
                } else if (status == 225) {
                    if (logger.finestOn()) {
                        logger.finest("getHandlers", "\tGET: Registering noSuchObject");
                        logger.finest("getHandlers", "\tcaused by: " + x);
                        logger.finest("getHandlers", x);
                    }
                    var.setSnmpValue(SnmpVarBind.noSuchObject);
                } else {
                    if (logger.finestOn()) {
                        logger.finest("getHandlers", "\tGET: Registering global error: " + status);
                    }
                    sn = new SnmpStatusException(status, index + 1);
                    Utils.initCause(sn, x);
                }
            }
            catch (RuntimeException x) {
                if (logger.finestOn()) {
                    logger.finest("getHandlers", "failed for varbind #" + (index + 1) + ": " + x, x);
                }
                throw x;
            }
            ++index;
        }
        return handlers;
    }

    private SnmpRequestTree getGetNextHandlers(SnmpMibRequest req) throws SnmpStatusException {
        SnmpRequestTree handlers = new SnmpRequestTree(req, false, 161);
        handlers.setGetNextFlag();
        if (logger.finestOn()) {
            logger.finest("getGetNextHandlers", "Received MIB request : " + req);
        }
        AcmChecker checker = new AcmChecker(req);
        int index = 0;
        SnmpVarBind var = null;
        int ver = req.getVersion();
        Object original = null;
        Enumeration e = req.getElements();
        while (e.hasMoreElements()) {
            var = (SnmpVarBind)e.nextElement();
            SnmpOid result = null;
            try {
                if (logger.finestOn()) {
                    logger.finest("getGetNextHandlers", " Next Oid of :" + var.getOid());
                }
                result = new SnmpOid(this.root.findNextHandlingNode(var, var.getOid().longValue(false), 0, 0, handlers, checker));
                if (logger.finestOn()) {
                    logger.finest("getGetNextHandlers", " is :" + result);
                }
                var.setOid(result, false);
            }
            catch (SnmpStatusException x) {
                if (ver == 0) {
                    if (logger.finestOn()) {
                        logger.finest("getGetNextHandlers", "\tThrowing exception" + x.toString());
                    }
                    throw new SnmpStatusException(x, index + 1);
                }
                if (logger.finestOn()) {
                    logger.finest("getGetNextHandlers", "Exception : " + x.getStatus());
                    logger.finest("getHandlers", "\tcaused by: " + x);
                }
                var.setSnmpValue(SnmpVarBind.endOfMibView);
            }
            ++index;
        }
        return handlers;
    }
}

