/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.management.snmp.SnmpOid;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class SnmpIndex
implements Serializable {
    private static final long serialVersionUID = -8516937092825243248L;
    private Vector oids = new Vector();
    private int size = 0;

    public SnmpIndex(SnmpOid[] oidList) {
        this.size = oidList.length;
        for (int i = 0; i < this.size; ++i) {
            this.oids.addElement(oidList[i]);
        }
    }

    public SnmpIndex(SnmpOid oid) {
        this.oids.addElement(oid);
        this.size = 1;
    }

    public int getNbComponents() {
        return this.size;
    }

    public Vector getComponents() {
        return this.oids;
    }

    public boolean equals(SnmpIndex index) {
        if (this.size != index.getNbComponents()) {
            return false;
        }
        Vector components = index.getComponents();
        for (int i = 0; i < this.size; ++i) {
            SnmpOid oid2;
            SnmpOid oid1 = (SnmpOid)this.oids.elementAt(i);
            if (oid1.equals(oid2 = (SnmpOid)components.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public int compareTo(SnmpIndex index) {
        int length = index.getNbComponents();
        Vector components = index.getComponents();
        for (int i = 0; i < this.size; ++i) {
            SnmpOid oid2;
            if (i > length) {
                return 1;
            }
            SnmpOid oid1 = (SnmpOid)this.oids.elementAt(i);
            int comp = oid1.compareTo(oid2 = (SnmpOid)components.elementAt(i));
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    public String toString() {
        StringBuffer msg = new StringBuffer();
        Enumeration e = this.oids.elements();
        while (e.hasMoreElements()) {
            SnmpOid val = (SnmpOid)e.nextElement();
            msg.append("//" + val.toString());
        }
        return msg.toString();
    }
}

