/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp;

import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpString;

public class SnmpStringFixed
extends SnmpString {
    private static final long serialVersionUID = -2800002500347958885L;

    public SnmpStringFixed(byte[] v) {
        super(v);
    }

    public SnmpStringFixed(Byte[] v) {
        super(v);
    }

    public SnmpStringFixed(String v) {
        super(v);
    }

    public SnmpStringFixed(int l, byte[] v) throws IllegalArgumentException {
        int i;
        if (l <= 0 || v == null) {
            throw new IllegalArgumentException();
        }
        int length = Math.min(l, v.length);
        this.value = new byte[l];
        for (i = 0; i < length; ++i) {
            this.value[i] = v[i];
        }
        for (i = length; i < l; ++i) {
            this.value[i] = 0;
        }
    }

    public SnmpStringFixed(int l, Byte[] v) throws IllegalArgumentException {
        int i;
        if (l <= 0 || v == null) {
            throw new IllegalArgumentException();
        }
        int length = Math.min(l, v.length);
        this.value = new byte[l];
        for (i = 0; i < length; ++i) {
            this.value[i] = v[i];
        }
        for (i = length; i < l; ++i) {
            this.value[i] = 0;
        }
    }

    public SnmpStringFixed(int l, String s) throws IllegalArgumentException {
        int i;
        if (l <= 0 || s == null) {
            throw new IllegalArgumentException();
        }
        byte[] v = s.getBytes();
        int length = Math.min(l, v.length);
        this.value = new byte[l];
        for (i = 0; i < length; ++i) {
            this.value[i] = v[i];
        }
        for (i = length; i < l; ++i) {
            this.value[i] = 0;
        }
    }

    public static SnmpOid toOid(int l, long[] index, int start) throws SnmpStatusException {
        try {
            long[] ids = new long[l];
            for (int i = 0; i < l; ++i) {
                ids[i] = index[start + i];
            }
            return new SnmpOid(ids);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SnmpStatusException(2);
        }
    }

    public static int nextOid(int l, long[] index, int start) throws SnmpStatusException {
        int result = start + l;
        if (result > index.length) {
            throw new SnmpStatusException(2);
        }
        return result;
    }

    public static void appendToOid(int l, SnmpOid source, SnmpOid dest) {
        dest.append(source);
    }
}

