/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.IPAcl;

import com.sun.management.snmp.IPAcl.AclEntryImpl;
import com.sun.management.snmp.IPAcl.OwnerImpl;
import com.sun.management.snmp.IPAcl.PrincipalImpl;
import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.AclEntry;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

class AclImpl
extends OwnerImpl
implements Acl,
Serializable {
    private static final long serialVersionUID = 8614545947280796145L;
    private Vector entryList = new Vector();
    private String aclName = null;

    public AclImpl(PrincipalImpl owner, String name) {
        super(owner);
        this.aclName = name;
    }

    public void setName(Principal caller, String name) throws NotOwnerException {
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        this.aclName = name;
    }

    public String getName() {
        return this.aclName;
    }

    public boolean addEntry(Principal caller, AclEntry entry) throws NotOwnerException {
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        if (this.entryList.contains(entry)) {
            return false;
        }
        this.entryList.addElement(entry);
        return true;
    }

    public boolean removeEntry(Principal caller, AclEntry entry) throws NotOwnerException {
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        return this.entryList.removeElement(entry);
    }

    public void removeAll(Principal caller) throws NotOwnerException {
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        this.entryList.removeAllElements();
    }

    public Enumeration getPermissions(Principal user) {
        Enumeration e = this.entryList.elements();
        while (e.hasMoreElements()) {
            AclEntry ent = (AclEntry)e.nextElement();
            if (!((Object)ent.getPrincipal()).equals(user)) continue;
            return ent.permissions();
        }
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public Enumeration entries() {
        return this.entryList.elements();
    }

    public boolean checkPermission(Principal user, Permission perm) {
        Enumeration e = this.entryList.elements();
        while (e.hasMoreElements()) {
            AclEntry ent = (AclEntry)e.nextElement();
            if (!((Object)ent.getPrincipal()).equals(user) || !ent.checkPermission(perm)) continue;
            return true;
        }
        return false;
    }

    public boolean checkPermission(Principal user, String community, Permission perm) {
        Enumeration e = this.entryList.elements();
        while (e.hasMoreElements()) {
            AclEntryImpl ent = (AclEntryImpl)e.nextElement();
            if (!((Object)ent.getPrincipal()).equals(user) || !ent.checkPermission(perm) || !ent.checkCommunity(community)) continue;
            return true;
        }
        return false;
    }

    public boolean checkCommunity(String community) {
        Enumeration e = this.entryList.elements();
        while (e.hasMoreElements()) {
            AclEntryImpl ent = (AclEntryImpl)e.nextElement();
            if (!ent.checkCommunity(community)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "AclImpl: " + this.getName();
    }
}

