/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.internal.snmp;

import com.sun.management.snmp.SnmpDefinitions;

public class SnmpTools
implements SnmpDefinitions {
    public static String binary2ascii(byte[] data, int length) {
        if (data == null) {
            return null;
        }
        int size = length * 2 + 2;
        byte[] asciiData = new byte[size];
        asciiData[0] = 48;
        asciiData[1] = 120;
        for (int i = 0; i < length; ++i) {
            int j = i * 2;
            int v = data[i] & 0xF0;
            asciiData[j + 2] = (v >>= 4) < 10 ? (byte)(48 + v) : (byte)(65 + (v - 10));
            v = data[i] & 0xF;
            asciiData[j + 1 + 2] = v < 10 ? (byte)(48 + v) : (byte)(65 + (v - 10));
        }
        return new String(asciiData);
    }

    public static String binary2ascii(byte[] data) {
        return SnmpTools.binary2ascii(data, data.length);
    }

    public static byte[] ascii2binary(String str) {
        if (str == null) {
            return null;
        }
        String val = str.substring(2);
        int size = val.length();
        byte[] buf = new byte[size / 2];
        byte[] p = val.getBytes();
        for (int i = 0; i < size / 2; ++i) {
            int j = i * 2;
            byte v = 0;
            if (p[j] >= 48 && p[j] <= 57) {
                v = (byte)(p[j] - 48 << 4);
            } else if (p[j] >= 97 && p[j] <= 102) {
                v = (byte)(p[j] - 97 + 10 << 4);
            } else if (p[j] >= 65 && p[j] <= 70) {
                v = (byte)(p[j] - 65 + 10 << 4);
            } else {
                throw new Error("BAD format :" + str);
            }
            if (p[j + 1] >= 48 && p[j + 1] <= 57) {
                v = (byte)(v + (p[j + 1] - 48));
            } else if (p[j + 1] >= 97 && p[j + 1] <= 102) {
                v = (byte)(v + (p[j + 1] - 97 + 10));
            } else if (p[j + 1] >= 65 && p[j + 1] <= 70) {
                v = (byte)(v + (p[j + 1] - 65 + 10));
            } else {
                throw new Error("BAD format :" + str);
            }
            buf[i] = v;
        }
        return buf;
    }
}

