/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.internal.snmp;

import com.sun.management.internal.snmp.SnmpAccessControlModel;
import com.sun.management.internal.snmp.SnmpAccessControlSubSysImpl;
import com.sun.management.internal.snmp.SnmpAccessControlSubSystem;
import com.sun.management.internal.snmp.SnmpBaseEngineFactory;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.internal.snmp.SnmpJdmkAcm;
import com.sun.management.snmp.InetAddressAcl;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineParameters;
import com.sun.management.snmp.UserAcl;
import com.sun.management.snmp.uacl.JdmkUserAcl;

public class SnmpAgentEngineFactory
extends SnmpBaseEngineFactory {
    String dbgTag = "SnmpAgentEngineFactory";

    public SnmpEngine createEngine(SnmpEngineParameters parameters) throws IllegalArgumentException {
        SnmpEngineImpl engine = (SnmpEngineImpl)super.createEngine(parameters);
        return this.init(parameters, engine, null);
    }

    public SnmpEngine createEngine(SnmpEngineParameters parameters, InetAddressAcl acl) throws IllegalArgumentException {
        SnmpEngineImpl engine = (SnmpEngineImpl)super.createEngine(parameters, acl);
        return this.init(parameters, engine, acl);
    }

    protected SnmpAccessControlSubSystem createSnmpAccessControlSubSystem(SnmpEngine engine) {
        return new SnmpAccessControlSubSysImpl(engine);
    }

    protected SnmpAccessControlModel createSnmpAccessControlModel(SnmpEngineParameters parameters, InetAddressAcl acl, SnmpEngine engine, SnmpAccessControlSubSystem subsys) throws IllegalArgumentException {
        UserAcl uacl = parameters.getUserAcl();
        if (parameters.getUserAcl() == null) {
            uacl = new JdmkUserAcl("Snmp Engine Acm V3 User ACL");
        }
        SnmpJdmkAcm acm = new SnmpJdmkAcm(subsys, acl, uacl, true);
        return acm;
    }

    private SnmpEngine init(SnmpEngineParameters parameters, SnmpEngineImpl engine, InetAddressAcl ipacl) {
        SnmpAccessControlSubSystem subsys = this.createSnmpAccessControlSubSystem(engine);
        SnmpAccessControlModel acm = this.createSnmpAccessControlModel(parameters, ipacl, engine, subsys);
        engine.setAccessControlSubSystem(subsys);
        return engine;
    }
}

