/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.internal.ThreadService;
import com.sun.management.comm.SnmpAdaptorServer;
import com.sun.management.comm.SnmpInformHandler;
import com.sun.management.comm.SnmpMibContextName;
import com.sun.management.comm.SnmpMibTree;
import com.sun.management.comm.SnmpV3AdaptorServerMBean;
import com.sun.management.comm.SnmpV3InformRequest;
import com.sun.management.comm.SnmpV3RequestHandler;
import com.sun.management.comm.SnmpV3Session;
import com.sun.management.internal.snmp.SnmpAccessControlModel;
import com.sun.management.internal.snmp.SnmpAccessControlSubSystem;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.internal.snmp.SnmpMsgProcessingModel;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.management.internal.snmp.SnmpOutgoingRequest;
import com.sun.management.internal.snmp.SnmpSecuritySubSystem;
import com.sun.management.snmp.InetAddressAcl;
import com.sun.management.snmp.JdmkEngineFactory;
import com.sun.management.snmp.SnmpBadSecurityLevelException;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineFactory;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpEngineParameters;
import com.sun.management.snmp.SnmpMsg;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpScopedPduRequest;
import com.sun.management.snmp.SnmpSecurityException;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTimeticks;
import com.sun.management.snmp.SnmpTooBigException;
import com.sun.management.snmp.SnmpUnknownModelException;
import com.sun.management.snmp.SnmpUnknownMsgProcModelException;
import com.sun.management.snmp.SnmpUnknownSecModelException;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.agent.SnmpMibAgent;
import com.sun.management.snmp.agent.SnmpMibAgentMBean;
import com.sun.management.snmp.agent.SnmpMibHandler;
import com.sun.management.snmp.agent.SnmpRequestForwarder;
import com.sun.management.snmp.agent.SnmpUserDataFactory;
import com.sun.management.snmp.manager.usm.SnmpUsmParameters;
import com.sun.management.snmp.manager.usm.SnmpUsmPeer;
import com.sun.management.snmp.mpm.SnmpMsgProcessingModelV1V2;
import com.sun.management.snmp.mpm.SnmpMsgTranslatorCs2Ctxt;
import com.sun.management.snmp.mpm.SnmpMsgTranslatorV1V2;
import com.sun.management.snmp.usm.SnmpUsm;
import com.sun.management.snmp.usm.SnmpUsmAlgorithmManager;
import com.sun.management.snmp.usm.SnmpUsmLcd;
import com.sun.management.snmp.usm.SnmpUsmSecurityParameters;
import com.sun.management.snmp.usm.usmmib.SNMP_USER_BASED_SM_MIB;
import com.sun.management.snmp.usm.usmmib.SNMP_USER_BASED_SM_MIBImpl;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class SnmpV3AdaptorServer
extends SnmpAdaptorServer
implements SnmpV3AdaptorServerMBean {
    private Hashtable contexts = new Hashtable();
    private Hashtable forwarders = new Hashtable();
    SnmpMsgTranslatorV1V2 v1v2translator = null;
    SnmpMsgTranslatorCs2Ctxt cs2ctxttranslator = null;
    SnmpMsgProcessingModel v1v2mpm = null;
    SnmpAccessControlModel v3acm = null;
    SNMP_USER_BASED_SM_MIB usmmib = null;
    private Hashtable peers = new Hashtable();
    private SnmpEngineImpl engine = null;
    private SnmpV3Session sessionV3 = null;
    private int snmpUnknownSecurityModels = 0;
    private int snmpInvalidMsgs = 0;
    private int snmpUnknownContexts = 0;
    private ThreadService threadService;

    public SnmpV3AdaptorServer() throws IllegalArgumentException {
        this(new SnmpEngineParameters(), (SnmpEngineFactory)new JdmkEngineFactory(), null, 161, null);
    }

    public SnmpV3AdaptorServer(int port) throws IllegalArgumentException {
        this(new SnmpEngineParameters(), (SnmpEngineFactory)new JdmkEngineFactory(), null, port, null);
    }

    public SnmpV3AdaptorServer(InetAddressAcl acl) throws IllegalArgumentException {
        this(new SnmpEngineParameters(), (SnmpEngineFactory)new JdmkEngineFactory(), acl, 161, null);
    }

    public SnmpV3AdaptorServer(InetAddress addr) throws IllegalArgumentException {
        this(new SnmpEngineParameters(), (SnmpEngineFactory)new JdmkEngineFactory(), null, 161, addr);
    }

    public SnmpV3AdaptorServer(InetAddressAcl acl, int port) throws IllegalArgumentException {
        this(new SnmpEngineParameters(), (SnmpEngineFactory)new JdmkEngineFactory(), acl, port, null);
    }

    public SnmpV3AdaptorServer(int port, InetAddress addr) throws IllegalArgumentException {
        this(new SnmpEngineParameters(), (SnmpEngineFactory)new JdmkEngineFactory(), null, port, addr);
    }

    public SnmpV3AdaptorServer(InetAddressAcl acl, InetAddress addr) throws IllegalArgumentException {
        this(new SnmpEngineParameters(), (SnmpEngineFactory)new JdmkEngineFactory(), acl, 161, addr);
    }

    public SnmpV3AdaptorServer(InetAddressAcl acl, int port, InetAddress addr) throws IllegalArgumentException {
        this(new SnmpEngineParameters(), (SnmpEngineFactory)new JdmkEngineFactory(), acl, port, addr);
    }

    public SnmpV3AdaptorServer(boolean useAcl, int port, InetAddress addr) throws IllegalArgumentException {
        this(new SnmpEngineParameters(), (SnmpEngineFactory)new JdmkEngineFactory(), useAcl, port, addr);
    }

    public SnmpV3AdaptorServer(SnmpEngineParameters parameters, SnmpEngineFactory factory, InetAddressAcl ipacl, int port, InetAddress addr) throws IllegalArgumentException {
        super(ipacl, port, addr);
        this.createEngine(parameters, factory);
    }

    public SnmpV3AdaptorServer(SnmpEngineParameters parameters, SnmpEngineFactory factory, boolean useAcl, int port, InetAddress addr) throws IllegalArgumentException {
        super(useAcl, port, addr);
        this.createEngine(parameters, factory);
    }

    public Long getSnmpUnknownSecurityModels() {
        return new Long(this.snmpUnknownSecurityModels);
    }

    public Long getSnmpInvalidMsgs() {
        return new Long(this.snmpInvalidMsgs);
    }

    public Long getSnmpUnknownContexts() {
        return new Long(this.snmpUnknownContexts);
    }

    public Long getSnmpUnknownPDUHandlers() {
        return new Long(0L);
    }

    void incSnmpUnknownContexts(int n) {
        this.snmpUnknownContexts += n;
    }

    void incSnmpUnknownSecurityModels(int n) {
        this.snmpUnknownSecurityModels += n;
    }

    void incSnmpInvalidMsgs(int n) {
        this.snmpInvalidMsgs += n;
    }

    private void createEngine(SnmpEngineParameters parameters, SnmpEngineFactory engFactory) throws IllegalArgumentException {
        block13: {
            SnmpEngineId engineid;
            if (parameters == null) {
                parameters = new SnmpEngineParameters();
            }
            if (engFactory == null) {
                engFactory = new JdmkEngineFactory();
            }
            if ((engineid = parameters.getEngineId()) == null) {
                if (this.address != null) {
                    engineid = SnmpEngineId.createEngineId(this.address, this.getPort());
                    parameters.setEngineId(engineid);
                } else {
                    try {
                        engineid = SnmpEngineId.createEngineId(InetAddress.getLocalHost(), this.getPort());
                        parameters.setEngineId(engineid);
                    }
                    catch (UnknownHostException e) {
                        throw new IllegalArgumentException("Unknown host: " + e.getMessage());
                    }
                }
            }
            this.engine = (SnmpEngineImpl)engFactory.createEngine(parameters, this.getInetAddressAcl());
            if (this.engine == null) {
                throw new IllegalArgumentException("The factory returned a null engine. SnmpV3AdaptorServer initilization failed");
            }
            this.createUsmMib(this.engine);
            if (this.logger.finestOn()) {
                this.logger.finest("createEngine", "Engine created.");
            }
            try {
                SnmpAccessControlSubSystem acsys;
                SnmpMsgProcessingSubSystem msgsys = this.engine.getMsgProcessingSubSystem();
                if (msgsys != null) {
                    this.v1v2mpm = (SnmpMsgProcessingModelV1V2)msgsys.getModel(1);
                    this.v1v2translator = new SnmpMsgTranslatorV1V2(this.engine);
                    this.cs2ctxttranslator = new SnmpMsgTranslatorCs2Ctxt(this.engine);
                }
                if ((acsys = this.engine.getAccessControlSubSystem()) != null) {
                    this.v3acm = (SnmpAccessControlModel)acsys.getModel(3);
                }
            }
            catch (SnmpUnknownModelException e) {
                if (!this.logger.finestOn()) break block13;
                this.logger.finest("createEngine", "SNMP V2 translation not activated, translation not activable");
            }
        }
        this.threadService = new ThreadService(SnmpAdaptorServer.getThreadNumber());
    }

    public SnmpEngine getEngine() {
        return this.engine;
    }

    public SnmpEngineId getEngineId() {
        if (this.engine == null) {
            return null;
        }
        return this.engine.getEngineId();
    }

    public SnmpMibHandler addMib(SnmpMibAgent mib, String contextName) throws IllegalArgumentException {
        if (this.logger.finerOn()) {
            this.logger.finer("addMib", "Mib [" + mib + "] in context [" + contextName + "]");
        }
        if (mib == null) {
            throw new IllegalArgumentException();
        }
        if (contextName == null || contextName.length() == 0) {
            if (this.logger.finerOn()) {
                this.logger.finer("addMib", "Mib [" + mib + "] in default context");
            }
            return this.addMib(mib);
        }
        SnmpMibContextName cont = (SnmpMibContextName)this.contexts.get(contextName);
        if (cont == null) {
            if (this.logger.finerOn()) {
                this.logger.finer("addMib", "Unknown context [" + contextName + "]");
            }
            cont = new SnmpMibContextName();
            cont.root.setDefaultAgent(this.getDefaultAgent());
            this.contexts.put(contextName, cont);
        }
        if (!cont.mibs.contains(mib)) {
            if (this.logger.finerOn()) {
                this.logger.finer("addMib", "Adding MIB [" + mib + "]");
            }
            cont.mibs.addElement(mib);
            cont.root.register(mib);
        } else if (this.logger.finerOn()) {
            this.logger.finer("addMib", "MIB [" + mib + "] already registered");
        }
        return this;
    }

    public boolean enableCommunityStringAtContext() {
        if (this.v1v2mpm == null) {
            return false;
        }
        this.v1v2mpm.setMsgTranslator(this.cs2ctxttranslator);
        return true;
    }

    public boolean disableCommunityStringAtContext() {
        if (this.v1v2mpm == null) {
            return false;
        }
        this.v1v2mpm.setMsgTranslator(this.v1v2translator);
        return true;
    }

    public boolean isCommunityStringAtContextEnabled() {
        if (this.v1v2mpm == null) {
            return false;
        }
        return this.v1v2mpm.getMsgTranslator() instanceof SnmpMsgTranslatorCs2Ctxt;
    }

    public synchronized boolean enableSnmpV1V2SetRequest() {
        if (this.v3acm == null) {
            return false;
        }
        return this.v3acm.enableSnmpV1V2SetRequest();
    }

    public synchronized boolean disableSnmpV1V2SetRequest() {
        if (this.v3acm == null) {
            return false;
        }
        return this.v3acm.disableSnmpV1V2SetRequest();
    }

    public synchronized boolean isSnmpV1V2SetRequestAuthorized() {
        if (this.v3acm == null) {
            return false;
        }
        return this.v3acm.isSnmpV1V2SetRequestAuthorized();
    }

    public void addRequestForwarder(SnmpRequestForwarder forwarder, SnmpEngineId contextEngineId) {
        if (forwarder == null || contextEngineId == null) {
            throw new IllegalArgumentException();
        }
        this.forwarders.put(contextEngineId.toString(), forwarder);
    }

    public boolean removeRequestForwarder(SnmpEngineId engineId) {
        if (engineId == null) {
            throw new IllegalArgumentException();
        }
        Object obj = this.forwarders.remove(engineId.toString());
        return obj != null;
    }

    public SnmpMibHandler addMib(SnmpMibAgent mib, String contextName, SnmpOid[] oids) throws IllegalArgumentException {
        int i;
        if (this.logger.finerOn()) {
            this.logger.finer("addMib", "Mib [" + mib + "] in context " + contextName + "]");
            StringBuffer b = new StringBuffer();
            for (i = 0; i < oids.length; ++i) {
                b.append(oids[i] + " ");
            }
            this.logger.finer("addMib", "Oid[] = " + b.toString());
        }
        if (mib == null) {
            throw new IllegalArgumentException();
        }
        if (contextName == null || contextName.length() == 0) {
            if (this.logger.finerOn()) {
                this.logger.finer("addMib", "Mib [" + mib + "] in default context");
            }
            return this.addMib(mib, oids);
        }
        if (oids == null || oids.length == 0) {
            return this.addMib(mib, contextName);
        }
        SnmpMibContextName cont = (SnmpMibContextName)this.contexts.get(contextName);
        if (cont == null) {
            if (this.logger.finerOn()) {
                this.logger.finer("addMib", "Unknown context [" + contextName + "]");
            }
            cont = new SnmpMibContextName();
            cont.root.setDefaultAgent(this.getDefaultAgent());
            this.contexts.put(contextName, cont);
        }
        if (!cont.mibs.contains(mib)) {
            if (this.logger.finerOn()) {
                this.logger.finer("addMib", "Adding MIB [" + mib + "]");
            }
            cont.mibs.addElement(mib);
        } else if (this.logger.finerOn()) {
            this.logger.finer("addMib", "MIB [" + mib + "] already registered");
        }
        for (i = 0; i < oids.length; ++i) {
            cont.root.register(mib, oids[i].longValue());
        }
        return this;
    }

    public boolean removeMib(SnmpMibAgent mib, String contextName) {
        if (this.logger.finerOn()) {
            this.logger.finer("removeMib", "Mib [ " + mib + "] in context " + contextName);
        }
        if (contextName == null || contextName.length() == 0) {
            return this.removeMib(mib);
        }
        SnmpMibContextName context = (SnmpMibContextName)this.contexts.get(contextName);
        if (context == null) {
            return false;
        }
        boolean ret = context.mibs.removeElement(mib);
        if (ret) {
            if (this.logger.finestOn()) {
                this.logger.finest("removeMib", "Mib : " + mib + " removed from context :" + contextName);
            }
            context.root.unregister(mib);
            if (context.mibs.size() == 0) {
                if (this.logger.finerOn()) {
                    this.logger.finer("removeMib", "No more mib in context name. Remove contextName");
                }
                this.contexts.remove(contextName);
            }
        } else if (this.logger.finerOn()) {
            this.logger.finer("removeMib", "Mib : " + mib + " not removed from context :" + contextName);
        }
        return ret;
    }

    public boolean removeMib(SnmpMibAgent mib, String contextName, SnmpOid[] oids) {
        if (this.logger.finerOn()) {
            this.logger.finer("removeMib", "Mib [" + mib + "] from context " + contextName);
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < oids.length; ++i) {
                b.append(oids[i] + " ");
            }
            this.logger.finer("removeMib", "Oid[] = " + b.toString());
        }
        if (contextName == null || contextName.length() == 0) {
            return this.removeMib(mib, oids);
        }
        if (oids == null || oids.length == 0) {
            return this.removeMib(mib, contextName);
        }
        SnmpMibContextName context = (SnmpMibContextName)this.contexts.get(contextName);
        if (context == null) {
            return false;
        }
        boolean ret = context.mibs.contains(mib);
        if (ret) {
            context.root.unregister(mib, oids);
            if (!context.root.isMibReferenced(mib)) {
                this.logger.finer("removeMib", "Mib removed");
                context.mibs.removeElement(mib);
                if (context.mibs.size() == 0) {
                    if (this.logger.finerOn()) {
                        this.logger.finer("removeMib", "No more mib in contest name.Remove " + contextName);
                    }
                    this.contexts.remove(contextName);
                }
            } else if (this.logger.finerOn()) {
                this.logger.finer("removeMib", "Mib NOT removed, still referenced");
            }
        }
        return ret;
    }

    public void registerUsmMib(MBeanServer server, ObjectName obj) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName mibObjName;
        block4: {
            mibObjName = null;
            if (obj != null) {
                mibObjName = obj;
            } else {
                try {
                    mibObjName = this.createUsmMibObjectName(this.engine);
                }
                catch (Exception e) {
                    if (!this.logger.finestOn()) break block4;
                    this.logger.finer("registerUsmMib", e.toString());
                }
            }
        }
        server.registerMBean(this.usmmib, mibObjName);
        this.addMib(this.usmmib);
    }

    public void registerUsmMib() throws IllegalAccessException {
        this.usmmib.init();
        this.addMib(this.usmmib);
    }

    void createSnmpRequestHandler(SnmpAdaptorServer server, int id, DatagramSocket socket, DatagramPacket packet, SnmpMibTree tree, Vector m, Object a, SnmpPduFactory factory, SnmpUserDataFactory dataFactory, MBeanServer f, ObjectName n) {
        SnmpV3RequestHandler handler = new SnmpV3RequestHandler(this, this.engine, id, socket, packet, this.contexts, this.forwarders, tree, m, a, factory, dataFactory, f, n);
        this.threadService.submitTask(handler);
    }

    public int[] getSecurityModelIds() {
        if (this.engine == null) {
            return null;
        }
        return this.engine.getSecuritySubSystem().getModelIds();
    }

    public String[] getSecurityModelNames() {
        if (this.engine == null) {
            return null;
        }
        return this.engine.getSecuritySubSystem().getModelNames();
    }

    public int[] getMsgProcessingModelIds() {
        if (this.engine == null) {
            return null;
        }
        return this.engine.getMsgProcessingSubSystem().getModelIds();
    }

    public String[] getMsgProcessingModelNames() {
        if (this.engine == null) {
            return null;
        }
        return this.engine.getMsgProcessingSubSystem().getModelNames();
    }

    public int[] getAccessControlModelIds() {
        if (this.engine == null) {
            return null;
        }
        return this.engine.getAccessControlSubSystem().getModelIds();
    }

    public String[] getAccessControlModelNames() {
        if (this.engine == null) {
            return null;
        }
        return this.engine.getAccessControlSubSystem().getModelNames();
    }

    public String[] getUsmSecurityAlgorithms() {
        if (this.engine == null) {
            return null;
        }
        SnmpSecuritySubSystem subsys = this.engine.getSecuritySubSystem();
        SnmpUsm usm = null;
        try {
            usm = (SnmpUsm)subsys.getModel(3);
        }
        catch (SnmpUnknownModelException e) {
            return null;
        }
        SnmpUsmLcd lcd = usm.getLcd();
        SnmpUsmAlgorithmManager manager = lcd.getAlgorithmManager();
        return manager.getManagedAlgorithms();
    }

    public String[] getMibs() {
        HashSet set = new HashSet(this.mibs);
        Iterator itr = set.iterator();
        Enumeration e = this.contexts.elements();
        while (e.hasMoreElements()) {
            SnmpMibContextName n = (SnmpMibContextName)e.nextElement();
            set.addAll(n.mibs);
        }
        String[] names = new String[set.size()];
        itr = set.iterator();
        int i = 0;
        while (itr.hasNext()) {
            names[i] = ((SnmpMibAgentMBean)itr.next()).getMibName();
            ++i;
        }
        return names;
    }

    public String[] getMibs(String context) {
        if (context == null) {
            return null;
        }
        SnmpMibContextName ctx = (SnmpMibContextName)this.contexts.get(context);
        if (ctx == null) {
            return null;
        }
        if (ctx.mibs == null) {
            return null;
        }
        int size = ctx.mibs.size();
        String[] mibNames = new String[size];
        for (int i = 0; i < size; ++i) {
            mibNames[i] = ((SnmpMibAgentMBean)ctx.mibs.elementAt(i)).getMibName();
        }
        return mibNames;
    }

    public String[] getContexts() {
        String[] res = new String[this.contexts.size()];
        int i = 0;
        Enumeration e = this.contexts.keys();
        while (e.hasMoreElements()) {
            res[i] = (String)e.nextElement();
            ++i;
        }
        return res;
    }

    public void snmpV3Trap(SnmpUsmPeer peer, SnmpScopedPduRequest pdu) throws IOException, SnmpStatusException {
        if (peer != null) {
            pdu.port = peer.getDestPort();
            this.snmpV3Trap(peer.getDestAddr(), pdu);
        } else {
            pdu.port = this.getTrapPort();
            this.snmpV3Trap((InetAddress)null, pdu);
        }
    }

    public void snmpV3Trap(InetAddress addr, SnmpScopedPduRequest pdu) throws IOException, SnmpStatusException {
        SnmpOutgoingRequest req = null;
        SnmpMsgProcessingSubSystem msgProcSubSys = this.engine.getMsgProcessingSubSystem();
        try {
            req = msgProcSubSys.getOutgoingRequest(3, this.getPduFactory());
        }
        catch (SnmpUnknownMsgProcModelException x) {
            if (this.logger.finestOn()) {
                this.logger.finest("snmpV3Trap", "Unknown Msg Processing Model:3");
            }
            throw new SnmpStatusException(242);
        }
        SnmpMsg msg = this.prepareMsg(req, pdu);
        if (msg == null) {
            return;
        }
        if (addr != null) {
            msg.address = addr;
            try {
                this.sendTrapMessage(req, msg);
            }
            catch (SnmpTooBigException x) {
                if (this.logger.finestOn()) {
                    this.logger.finest("snmpV3Trap", "trap pdu is too big");
                    this.logger.finest("snmpV3Trap", "trap hasn't been sent to " + msg.address);
                }
                this.closeTrapSocketIfNeeded();
                throw new SnmpStatusException(1);
            }
        }
        int sendingCount = 0;
        this.openTrapSocketIfNeeded();
        if (this.getInetAddressAcl() != null) {
            Enumeration ed = this.getInetAddressAcl().getTrapDestinations();
            while (ed.hasMoreElements()) {
                msg.address = (InetAddress)ed.nextElement();
                try {
                    this.sendTrapMessage(req, msg);
                    ++sendingCount;
                }
                catch (SnmpTooBigException x) {
                    if (!this.logger.finestOn()) continue;
                    this.logger.finest("snmpV3Trap", "trap pdu is too big");
                    this.logger.finest("snmpV3Trap", "trap hasn't been sent to " + msg.address);
                    this.closeTrapSocketIfNeeded();
                    throw new SnmpStatusException(1);
                }
            }
        }
        if (sendingCount == 0) {
            try {
                msg.address = InetAddress.getLocalHost();
                this.sendTrapMessage(req, msg);
            }
            catch (SnmpTooBigException x) {
                if (this.logger.finestOn()) {
                    this.logger.finest("snmpV3Trap", "trap pdu is too big");
                    this.logger.finest("snmpV3Trap", "trap hasn't been sent");
                }
                this.closeTrapSocketIfNeeded();
                throw new SnmpStatusException(1);
            }
            catch (UnknownHostException e) {
                if (this.logger.finestOn()) {
                    this.logger.finest("snmpV3Trap", "cannot get the local host");
                    this.logger.finest("snmpV3Trap", "trap hasn't been sent");
                }
                throw new SnmpStatusException(242);
            }
        }
        this.closeTrapSocketIfNeeded();
    }

    public void snmpV3Trap(SnmpScopedPduRequest pdu) throws IOException, SnmpStatusException {
        this.snmpV3Trap((InetAddress)null, pdu);
    }

    public void snmpV3UsmTrap(String principal, int securityLevel, String contextName, SnmpOid trapOid, SnmpVarBindList list) throws IOException, SnmpStatusException {
        byte[] ctx = contextName == null ? null : contextName.getBytes();
        SnmpScopedPduRequest pdu = this.createScopedUsmPdu(principal, securityLevel, ctx, this.engine.getEngineId(), this.engine.getEngineBoots(), this.engine.getEngineTime(), list, trapOid, null, this.getTrapPort());
        this.snmpV3Trap(pdu);
    }

    public void snmpV3UsmTrap(InetAddress addr, String principal, int securityLevel, String contextName, SnmpOid trapOid, SnmpVarBindList list) throws IOException, SnmpStatusException {
        byte[] ctx = contextName == null ? null : contextName.getBytes();
        SnmpScopedPduRequest pdu = this.createScopedUsmPdu(principal, securityLevel, ctx, this.engine.getEngineId(), this.engine.getEngineBoots(), this.engine.getEngineTime(), list, trapOid, null, this.getTrapPort());
        this.snmpV3Trap(addr, pdu);
    }

    public void snmpV3UsmTrap(InetAddress addr, String principal, int securityLevel, String contextName, SnmpOid trapOid, SnmpVarBindList list, SnmpTimeticks time) throws IOException, SnmpStatusException {
        byte[] ctx = contextName == null ? null : contextName.getBytes();
        SnmpScopedPduRequest pdu = this.createScopedUsmPdu(principal, securityLevel, ctx, this.engine.getEngineId(), this.engine.getEngineBoots(), this.engine.getEngineTime(), list, trapOid, time, this.getTrapPort());
        this.snmpV3Trap(addr, pdu);
    }

    public void snmpV3UsmTrap(SnmpUsmPeer peer, SnmpOid trapOid, SnmpVarBindList list, SnmpTimeticks time) throws IOException, SnmpStatusException, IllegalArgumentException {
        SnmpUsmParameters p = (SnmpUsmParameters)peer.getParams();
        if (p == null) {
            throw new IllegalArgumentException("No Usm parameters set");
        }
        SnmpScopedPduRequest pdu = this.createScopedUsmPdu(p.getPrincipal(), p.getSecurityLevel(), p.getContextName(), this.engine.getEngineId(), this.engine.getEngineBoots(), this.engine.getEngineTime(), list, trapOid, time, peer.getDestPort());
        this.snmpV3Trap(peer.getDestAddr(), pdu);
    }

    public SnmpV3InformRequest snmpV3UsmInformRequest(SnmpUsmPeer informPeer, SnmpInformHandler cb, SnmpOid trapOid, SnmpVarBindList list) throws IllegalStateException, IOException, SnmpStatusException {
        return this.usmInformRequest(informPeer, cb, trapOid, list);
    }

    private SnmpV3InformRequest usmInformRequest(SnmpUsmPeer peer, SnmpInformHandler cb, SnmpOid trapOid, SnmpVarBindList list) throws IllegalStateException, IllegalArgumentException, IOException, SnmpStatusException {
        if (!this.isActive()) {
            throw new IllegalStateException("Start SNMP adaptor server before carrying out this operation");
        }
        if (peer.isAuthoritative()) {
            throw new SnmpStatusException("SnmpUsmPeer is an authoritative one. Not usable for informs.");
        }
        SnmpUsmParameters p = (SnmpUsmParameters)peer.getParams();
        SnmpScopedPduRequest pdu = this.createScopedUsmPdu(p.getPrincipal(), p.getSecurityLevel(), p.getContextName(), peer.getEngineId(), peer.getEngineBoots(), peer.getEngineTime(), list, null, null, peer.getDestPort());
        SnmpV3InformRequest req = this.snmpV3InformRequest(peer.getDestAddr(), cb, pdu, trapOid, list);
        return req;
    }

    private Vector snmpV3InformRequest(SnmpInformHandler cb, SnmpScopedPduRequest pdu, SnmpOid trapOid, SnmpVarBindList varBindList) throws IllegalStateException, IOException, SnmpStatusException {
        if (!this.isActive()) {
            throw new IllegalStateException("Start SNMP adaptor server before carrying out this operation");
        }
        if (this.sessionV3 == null) {
            this.sessionV3 = new SnmpV3Session(this);
        }
        if (this.logger.finerOn()) {
            this.logger.finer("snmpV3InformRequest", "trapOid=" + trapOid);
        }
        SnmpVarBindList fullVbl = varBindList != null ? (SnmpVarBindList)varBindList.clone() : new SnmpVarBindList(2);
        SnmpTimeticks sysUpTimeValue = new SnmpTimeticks(this.getSysUpTime());
        fullVbl.insertElementAt(new SnmpVarBind(snmpTrapOidOid, trapOid), 0);
        fullVbl.insertElementAt(new SnmpVarBind(sysUpTimeOid, sysUpTimeValue), 0);
        this.openInformSocketIfNeeded();
        Vector<SnmpV3InformRequest> informReqList = new Vector<SnmpV3InformRequest>();
        int sendingCount = 0;
        InetAddress addr = null;
        if (this.getInetAddressAcl() != null) {
            Enumeration ed = this.getInetAddressAcl().getInformDestinations();
            while (ed.hasMoreElements()) {
                addr = (InetAddress)ed.nextElement();
                informReqList.addElement(this.sessionV3.makeAsyncRequest(addr, pdu, cb, fullVbl));
                ++sendingCount;
            }
        }
        if (sendingCount == 0) {
            informReqList.addElement(this.sessionV3.makeAsyncRequest(InetAddress.getLocalHost(), pdu, cb, fullVbl));
        }
        return informReqList;
    }

    public SnmpV3InformRequest snmpV3InformRequest(InetAddress addr, SnmpInformHandler cb, SnmpScopedPduRequest pdu, SnmpOid trapOid, SnmpVarBindList varBindList) throws IllegalStateException, IOException, SnmpStatusException {
        if (!this.isActive()) {
            throw new IllegalStateException("Start SNMP adaptor server before carrying out this operation");
        }
        if (this.sessionV3 == null) {
            this.sessionV3 = new SnmpV3Session(this);
        }
        if (this.logger.finerOn()) {
            this.logger.finer("snmpV3InformRequest", "trapOid=" + trapOid);
        }
        SnmpVarBindList fullVbl = varBindList != null ? (SnmpVarBindList)varBindList.clone() : new SnmpVarBindList(2);
        SnmpTimeticks sysUpTimeValue = new SnmpTimeticks(this.getSysUpTime());
        fullVbl.insertElementAt(new SnmpVarBind(snmpTrapOidOid, trapOid), 0);
        fullVbl.insertElementAt(new SnmpVarBind(sysUpTimeOid, sysUpTimeValue), 0);
        this.openInformSocketIfNeeded();
        return this.sessionV3.makeAsyncRequest(addr, pdu, cb, fullVbl);
    }

    private SnmpScopedPduRequest createScopedUsmPdu(String principal, int securityLevel, byte[] contextName, SnmpEngineId authId, int boot, int time, SnmpVarBindList list, SnmpOid trapOid, SnmpTimeticks timeticks, int port) throws SnmpStatusException {
        SnmpUsm usm = null;
        try {
            usm = (SnmpUsm)this.engine.getSecuritySubSystem().getModel(3);
        }
        catch (SnmpUnknownModelException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("createScopedUsmPdu", "SnmpUnknownModelException", e);
            }
            throw new SnmpStatusException(242);
        }
        SnmpUsmSecurityParameters params = usm.createUsmSecurityParameters();
        params.setAuthoritativeEngineId(authId);
        params.setAuthoritativeEngineBoots(boot);
        params.setAuthoritativeEngineTime(time);
        params.setUserName(principal);
        SnmpScopedPduRequest req = new SnmpScopedPduRequest();
        req.port = port;
        req.version = 3;
        req.type = 167;
        req.msgFlags = (byte)securityLevel;
        req.msgSecurityModel = 3;
        req.msgMaxSize = this.bufferSize;
        req.contextEngineId = authId.getBytes();
        req.contextName = contextName;
        req.securityParameters = params;
        SnmpTimeticks sysUpTimeValue = null;
        sysUpTimeValue = timeticks != null ? timeticks : new SnmpTimeticks(this.getSysUpTime());
        SnmpVarBindList fullVbl = SnmpV3AdaptorServer.completeTrapVarBindList(list, trapOid, sysUpTimeValue);
        req.varBindList = new SnmpVarBind[fullVbl.size()];
        fullVbl.copyInto(req.varBindList);
        return req;
    }

    private void sendTrapMessage(SnmpOutgoingRequest req, SnmpMsg msg) throws IOException, SnmpTooBigException, SnmpStatusException {
        byte[] buffer = new byte[this.bufferSize];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        int encodingLength = 0;
        try {
            encodingLength = req.encodeMessage(buffer);
        }
        catch (SnmpSecurityException e) {
            if (this.logger.finerOn()) {
                this.logger.finer("sendTrapMessage", e.toString());
            }
            throw new SnmpStatusException(e.status);
        }
        catch (SnmpUnknownSecModelException e) {
            if (this.logger.finerOn()) {
                this.logger.finer("sendTrapMessage", e.toString());
            }
            throw new SnmpStatusException(e.toString());
        }
        catch (SnmpBadSecurityLevelException e) {
            if (this.logger.finerOn()) {
                this.logger.finer("sendTrapMessage", e.toString());
            }
            throw new SnmpStatusException(249);
        }
        packet.setLength(encodingLength);
        packet.setAddress(msg.address);
        packet.setPort(msg.port);
        if (this.logger.finerOn()) {
            this.logger.finer("sendTrapMessage", "sending trap to " + msg.address + ":" + msg.port);
        }
        this.trapSocket.send(packet);
        if (this.logger.finerOn()) {
            this.logger.fine("sendTrapMessage", "trap sent to " + msg.address + ":" + msg.port);
        }
        ++this.snmpOutTraps;
        ++this.snmpOutPkts;
    }

    private SnmpMsg prepareMsg(SnmpOutgoingRequest req, SnmpPdu pdu) throws IOException, SnmpStatusException {
        SnmpPduFactory pduFactory = this.getPduFactory();
        SnmpMsg msg = null;
        try {
            msg = req.encodeSnmpPdu(pdu, this.bufferSize);
        }
        catch (SnmpTooBigException ar) {
            if (this.logger.finestOn()) {
                this.logger.finest("prepareMsg", ar);
            }
            throw new SnmpStatusException(1);
        }
        if (msg == null) {
            if (this.logger.finestOn()) {
                this.logger.finest("prepareMsg", "pdu factory returned a null value");
            }
            throw new SnmpStatusException(242);
        }
        byte[] encoding = new byte[this.bufferSize];
        int encodingLength = 0;
        try {
            encodingLength = req.encodeMessage(encoding);
        }
        catch (SnmpTooBigException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("prepareMsg", e.toString());
            }
            throw new SnmpStatusException(1);
        }
        catch (SnmpSecurityException e) {
            if (this.logger.finerOn()) {
                this.logger.finer("prepareMsg", e.toString());
            }
            throw new SnmpStatusException(e.status);
        }
        catch (SnmpUnknownSecModelException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("prepareMsg", e.toString());
            }
            throw new SnmpStatusException(242);
        }
        catch (SnmpBadSecurityLevelException e) {
            if (this.logger.finerOn()) {
                this.logger.finer("prepareMsg", e.toString());
            }
            throw new SnmpStatusException(249);
        }
        this.openTrapSocketIfNeeded();
        return msg;
    }

    protected ObjectName createUsmMibObjectName(SnmpEngine engine) throws MalformedObjectNameException {
        return new ObjectName(engine.getEngineId().toString() + "/SNMP_USER_BASED_SM_MIB:" + "name=Usm-MIB-RFC2574");
    }

    private void createUsmMib(SnmpEngineImpl engine) throws IllegalArgumentException {
        SnmpUsm usm = null;
        SnmpUsmLcd usmlcd = null;
        try {
            usm = (SnmpUsm)engine.getSecuritySubSystem().getModel(3);
            usmlcd = usm.getLcd();
        }
        catch (SnmpUnknownModelException e) {
            if (this.logger.finerOn()) {
                this.logger.finer("init", "The Usm can't be added, no Usm model: " + e);
            }
            throw new IllegalArgumentException(e.toString());
        }
        this.usmmib = new SNMP_USER_BASED_SM_MIBImpl(engine, usmlcd, usm);
    }

    String makeDebugTag() {
        return "SnmpV3AdaptorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }
}

