/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.comm.SnmpInformRequest;
import com.sun.management.comm.SnmpQManager;
import java.util.Enumeration;
import java.util.Vector;

final class SnmpSendServer
extends Thread {
    private int intervalRange = 5000;
    private Vector readyPool;
    SnmpQManager snmpq = null;
    String dbgTag = "SnmpSendServer";
    boolean isBeingDestroyed = false;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.adaptor", "SnmpSendServer");

    public SnmpSendServer(ThreadGroup grp, SnmpQManager q) {
        super(grp, "SnmpSendServer");
        this.snmpq = q;
        this.start();
    }

    public synchronized void stopSendServer() {
        if (this.isAlive()) {
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void run() {
        Thread.currentThread().setPriority(5);
        if (logger.finerOn()) {
            logger.finer("run", "Thread Started");
        }
        while (true) {
            try {
                do {
                    this.prepareAndSendRequest();
                } while (!this.isBeingDestroyed);
            }
            catch (Exception anye) {
                if (!logger.finestOn()) continue;
                logger.finest("run", "Exception in send server");
                logger.finest("run", anye);
                continue;
            }
            catch (ThreadDeath td) {
                if (logger.finestOn()) {
                    logger.finest("run", "Exiting... Fatal error");
                }
                throw td;
            }
            catch (OutOfMemoryError ome) {
                if (!logger.finestOn()) continue;
                logger.finest("run", "Out of memory");
                continue;
            }
            catch (Error err) {
                if (logger.finestOn()) {
                    logger.finest("run", err);
                }
                throw err;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAndSendRequest() {
        if (this.readyPool == null || this.readyPool.isEmpty()) {
            if (logger.finerOn()) {
                logger.finer("prepareAndSendRequest", "Blocking for inform requests");
            }
            this.readyPool = this.snmpq.getAllOutstandingRequest(this.intervalRange);
            if (this.isBeingDestroyed) {
                return;
            }
        } else if (logger.finestOn()) {
            logger.finest("prepareAndSendRequest", "Inform requests from a previous block left unprocessed. Will try again");
        }
        if (logger.finerOn()) {
            logger.finer("prepareAndSendRequest", "List of inform requests to send : " + this.reqListToString(this.readyPool));
        }
        SnmpSendServer snmpSendServer = this;
        synchronized (snmpSendServer) {
            if (this.readyPool.size() < 2) {
                this.fireRequestList(this.readyPool);
                return;
            }
            while (!this.readyPool.isEmpty()) {
                SnmpInformRequest req = (SnmpInformRequest)this.readyPool.lastElement();
                if (req != null && req.inProgress()) {
                    this.fireRequest(req);
                }
                this.readyPool.removeElementAt(this.readyPool.size() - 1);
            }
            this.readyPool.removeAllElements();
        }
    }

    void fireRequest(SnmpInformRequest req) {
        if (req != null && req.inProgress()) {
            if (logger.finerOn()) {
                logger.finer("fireRequest", "Firing inform request directly. -> " + req.getRequestId());
            }
            req.action();
        }
    }

    void fireRequestList(Vector reqList) {
        while (!reqList.isEmpty()) {
            SnmpInformRequest req = (SnmpInformRequest)reqList.lastElement();
            if (req != null && req.inProgress()) {
                this.fireRequest(req);
            }
            reqList.removeElementAt(reqList.size() - 1);
        }
    }

    final String reqListToString(Vector vec) {
        StringBuffer s = new StringBuffer(vec.size() * 100);
        Enumeration dbge = vec.elements();
        while (dbge.hasMoreElements()) {
            SnmpInformRequest reqc = (SnmpInformRequest)dbge.nextElement();
            s.append("InformRequestId -> ");
            s.append(reqc.getRequestId());
            s.append(" / Destination -> ");
            s.append(reqc.getAddress());
            s.append(". ");
        }
        String str = s.toString();
        s = null;
        return str;
    }
}

