/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.GenericHttpClientHandler;
import com.sun.jdmk.comm.GenericHttpNotificationReceiver;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HttpRequest;
import com.sun.jdmk.comm.HttpResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

class GenericHttpNotificationReceiverHandler
extends GenericHttpClientHandler {
    public GenericHttpNotificationReceiverHandler(GenericHttpNotificationReceiver server, int id, GenericHttpSocket s) {
        super(server, id, s, null, null);
    }

    protected AuthInfo authenticateRequest(HttpRequest request) {
        return this.makeNullAuthInfo();
    }

    protected String getChallenge() {
        return null;
    }

    protected HttpResponse processPostRequest(HttpRequest request) throws IOException {
        String remoteOp = null;
        Integer opType = null;
        Object[] params = null;
        if (this.logger.finerOn()) {
            this.logger.finer("processPostRequest", "Process a POST request = " + request.getURIPath());
        }
        if (request.getContentLength() == 0) {
            return this.makeErrorResponse(400, "Bad Request");
        }
        Object[] result = null;
        String resultType = null;
        ByteArrayInputStream bIn = null;
        ObjectInputStream objIn = null;
        ByteArrayOutputStream bOut = null;
        try {
            bIn = new ByteArrayInputStream(request.getContentBytes());
            objIn = new ObjectInputStream(bIn);
            remoteOp = (String)objIn.readObject();
            if (this.logger.finerOn()) {
                this.logger.finer("doRun", "Remote operation: " + remoteOp);
            }
            if (!remoteOp.equals("remoteRequest")) {
                if (this.logger.finerOn()) {
                    this.logger.finer("doRun", "Unknown remote operation: " + remoteOp);
                }
                return this.makeErrorResponse(400, "Bad Request");
            }
            opType = (Integer)objIn.readObject();
            params = (Object[])objIn.readObject();
            result = this.remoteRequest(opType, params);
            resultType = "Object[]";
        }
        catch (Exception e) {
            if (this.logger.finerOn()) {
                this.logger.finer("doRun", "Failed to do remote request: " + e);
            }
            return this.makeExceptionResponse(e);
        }
        bOut = this.serialize(resultType, result);
        return this.makeOkResponse(bOut.toByteArray());
    }

    private Object[] remoteRequest(int opType, Object[] params) throws Exception {
        if (this.logger.finerOn()) {
            this.logger.finer("remoteRequest", "remoteRequest");
        }
        GenericHttpNotificationReceiver server = (GenericHttpNotificationReceiver)this.adaptorServer;
        return server.dispatcher.remoteRequest(opType, params);
    }

    protected String makeDebugTag() {
        return "GenericHttpNotificationReceiverHandler[" + this.adaptorServer.getProtocol() + ":" + this.adaptorServer.getPort() + "][" + this.requestId + "]";
    }
}

