/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.copyright;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.copyright.CommonCopyright;
import org.glassfish.copyright.Copyright;

public class AsciidocCopyright
extends CommonCopyright {
    private String firstComment;
    private static final String commentRegex = "////+";
    private static final Pattern pat = Pattern.compile("////+");
    private static final String commentDelim = "///////////////////////////////////////////////////////////////////////////////";

    public AsciidocCopyright(Copyright c) {
        super(c);
        this.commentStart = commentDelim;
        this.commentEnd = commentDelim;
        this.commentPrefix = "    ";
    }

    @Override
    protected boolean supports(File file) {
        return file.getName().endsWith(".adoc");
    }

    @Override
    protected boolean isCommentStart(String line) {
        if (line != null && line.matches(commentRegex)) {
            this.firstComment = line;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isCommentEnd(String line) {
        return line.equals(this.firstComment);
    }

    @Override
    protected String commentTrailer(String line) {
        Matcher m = pat.matcher(line);
        if (m.matches()) {
            int end = m.end();
            return line.substring(end).trim();
        }
        return "";
    }
}

