/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab.api;

import java.io.UnsupportedEncodingException;
import org.gitlab.api.http.Query;

public class Pagination {
    public static final String PARAM_PAGE = "page";
    public static final String PARAM_PER_PAGE = "per_page";
    public static final int MAX_ITEMS_PER_PAGE = 100;
    private final Query paginationQuery = new Query();

    public void setPage(int page) {
        try {
            this.paginationQuery.append(PARAM_PAGE, String.valueOf(page));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void setPerPage(int perPage) {
        if (perPage > 100) {
            throw new IllegalArgumentException("Max value for perPage is 100");
        }
        try {
            this.paginationQuery.append(PARAM_PER_PAGE, String.valueOf(perPage));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public Query asQuery() {
        return this.paginationQuery;
    }

    public String toString() {
        return this.paginationQuery.toString();
    }
}

