/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.AbstractWkbEncoder;

class MySqlWkbEncoder
extends AbstractWkbEncoder {
    MySqlWkbEncoder() {
    }

    @Override
    public <P extends Position> ByteBuffer encode(Geometry<P> geometry, ByteOrder byteOrder) {
        if (geometry == null || this.hasEmpty(geometry)) {
            return null;
        }
        ByteBuffer output = ByteBuffer.allocate(this.calculateSize(geometry, false) + 4);
        if (byteOrder != null) {
            output.setByteOrder(byteOrder);
        }
        output.putInt(geometry.getSRID() == -1 ? 0 : geometry.getSRID());
        this.writeGeometry(geometry, output);
        output.rewind();
        return output;
    }

    @Override
    protected <P extends Position> int sizeEmptyGeometry(Geometry<P> geometry) {
        return 0;
    }

    private <P extends Position> boolean hasEmpty(Geometry<P> geometry) {
        if (geometry.isEmpty()) {
            return true;
        }
        if (geometry instanceof GeometryCollection) {
            for (Geometry part : (GeometryCollection)geometry) {
                if (!this.hasEmpty(part)) continue;
                return true;
            }
        }
        return false;
    }
}

