/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms;

import java.util.Map;
import javax.jms.JMSException;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.stomp.client.Constants;
import org.fusesource.stomp.jms.StompJmsPrefetch;
import org.fusesource.stomp.jms.StompServerAdaptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveMQServerAdaptor
extends StompServerAdaptor {
    private static final AsciiBuffer SUBSCRIPTION_NAME = new AsciiBuffer("activemq.subscriptionName");
    private static final AsciiBuffer NO_LOCAL = new AsciiBuffer("activemq.noLocal");

    @Override
    public boolean matchesServerAndVersion(String server) {
        return server != null && server.startsWith("ActiveMQ/");
    }

    @Override
    public void addSubscribeHeaders(Map<AsciiBuffer, AsciiBuffer> headerMap, boolean persistent, boolean browser, boolean noLocal, StompJmsPrefetch prefetch) throws JMSException {
        if (browser) {
            throw new JMSException("ActiveMQ does not support browsing over STOMP");
        }
        if (noLocal) {
            headerMap.put(NO_LOCAL, Constants.TRUE);
        }
        if (persistent) {
            headerMap.put(SUBSCRIPTION_NAME, headerMap.get(Constants.ID));
        }
    }
}

