/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.maven;

import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.internal.info.MigrationInfoDumper;
import org.flywaydb.maven.AbstractFlywayMojo;

@Mojo(name="info", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, threadSafe=true)
public class InfoMojo
extends AbstractFlywayMojo {
    @Override
    protected void doExecute(Flyway flyway) {
        MigrationInfoService info = flyway.info();
        MigrationInfo current = info.current();
        MigrationVersion currentSchemaVersion = current == null ? MigrationVersion.EMPTY : current.getVersion();
        this.log.info("Schema version: " + currentSchemaVersion);
        this.log.info("");
        this.log.info(MigrationInfoDumper.dumpToAsciiTable((MigrationInfo[])info.all()));
    }
}

