/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.TransactionRequiredException;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.cfg.TransactionContext;
import org.flowable.common.engine.impl.cfg.TransactionListener;
import org.flowable.common.engine.impl.cfg.TransactionState;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.variable.service.impl.types.EntityManagerSession;

public class EntityManagerSessionImpl
implements EntityManagerSession {
    private EntityManagerFactory entityManagerFactory;
    private EntityManager entityManager;
    private boolean handleTransactions;
    private boolean closeEntityManager;

    public EntityManagerSessionImpl(EntityManagerFactory entityManagerFactory, EntityManager entityManager, boolean handleTransactions, boolean closeEntityManager) {
        this(entityManagerFactory, handleTransactions, closeEntityManager);
        this.entityManager = entityManager;
    }

    public EntityManagerSessionImpl(EntityManagerFactory entityManagerFactory, boolean handleTransactions, boolean closeEntityManager) {
        this.entityManagerFactory = entityManagerFactory;
        this.handleTransactions = handleTransactions;
        this.closeEntityManager = closeEntityManager;
    }

    public void flush() {
        if (this.entityManager != null && (!this.handleTransactions || this.isTransactionActive())) {
            try {
                this.entityManager.flush();
            }
            catch (IllegalStateException ise) {
                throw new FlowableException("Error while flushing EntityManager, illegal state", (Throwable)ise);
            }
            catch (TransactionRequiredException tre) {
                throw new FlowableException("Cannot flush EntityManager, an active transaction is required", (Throwable)tre);
            }
            catch (PersistenceException pe) {
                throw new FlowableException("Error while flushing EntityManager: " + pe.getMessage(), (Throwable)pe);
            }
        }
    }

    protected boolean isTransactionActive() {
        if (this.handleTransactions && this.entityManager.getTransaction() != null) {
            return this.entityManager.getTransaction().isActive();
        }
        return false;
    }

    public void close() {
        if (this.closeEntityManager && this.entityManager != null && this.entityManager.isOpen()) {
            try {
                this.entityManager.close();
            }
            catch (IllegalStateException ise) {
                throw new FlowableException("Error while closing EntityManager, may have already been closed or it is container-managed", (Throwable)ise);
            }
        }
    }

    @Override
    public EntityManager getEntityManager() {
        if (this.entityManager == null) {
            this.entityManager = this.getEntityManagerFactory().createEntityManager();
            if (this.handleTransactions) {
                TransactionListener jpaTransactionCommitListener = new TransactionListener(){

                    public void execute(CommandContext commandContext) {
                        if (EntityManagerSessionImpl.this.isTransactionActive()) {
                            EntityManagerSessionImpl.this.entityManager.getTransaction().commit();
                        }
                    }
                };
                TransactionListener jpaTransactionRollbackListener = new TransactionListener(){

                    public void execute(CommandContext commandContext) {
                        if (EntityManagerSessionImpl.this.isTransactionActive()) {
                            EntityManagerSessionImpl.this.entityManager.getTransaction().rollback();
                        }
                    }
                };
                TransactionContext transactionContext = Context.getTransactionContext();
                transactionContext.addTransactionListener(TransactionState.COMMITTED, jpaTransactionCommitListener);
                transactionContext.addTransactionListener(TransactionState.ROLLED_BACK, jpaTransactionRollbackListener);
                if (!this.isTransactionActive()) {
                    this.entityManager.getTransaction().begin();
                }
            }
        }
        return this.entityManager;
    }

    private EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }
}

