/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.db;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.api.types.VariableTypes;

public class IbatisVariableTypeHandler
implements TypeHandler<VariableType> {
    protected VariableTypes variableTypes;

    public IbatisVariableTypeHandler(VariableTypes variableTypes) {
        this.variableTypes = variableTypes;
    }

    public VariableType getResult(ResultSet rs, String columnName) throws SQLException {
        String typeName = rs.getString(columnName);
        VariableType type = this.variableTypes.getVariableType(typeName);
        if (type == null && typeName != null) {
            throw new FlowableException("unknown variable type name " + typeName);
        }
        return type;
    }

    public VariableType getResult(CallableStatement cs, int columnIndex) throws SQLException {
        String typeName = cs.getString(columnIndex);
        VariableType type = this.variableTypes.getVariableType(typeName);
        if (type == null) {
            throw new FlowableException("unknown variable type name " + typeName);
        }
        return type;
    }

    public void setParameter(PreparedStatement ps, int i, VariableType parameter, JdbcType jdbcType) throws SQLException {
        String typeName = parameter.getTypeName();
        ps.setString(i, typeName);
    }

    public VariableType getResult(ResultSet resultSet, int columnIndex) throws SQLException {
        String typeName = resultSet.getString(columnIndex);
        VariableType type = this.variableTypes.getVariableType(typeName);
        if (type == null) {
            throw new FlowableException("unknown variable type name " + typeName);
        }
        return type;
    }
}

