/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.UserTask;
import org.flowable.cmmn.converter.CmmnXmlConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterContext;
import org.flowable.cmmn.editor.json.converter.util.CmmnModelJsonConverterUtil;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.dmn.editor.converter.DmnJsonConverterUtil;
import org.flowable.editor.language.json.converter.BpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterContext;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.editor.language.json.converter.util.JsonConverterUtil;
import org.flowable.form.model.SimpleFormModel;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.common.util.XmlUtil;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.AppDefinition;
import org.flowable.ui.modeler.domain.AppModelDefinition;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.domain.ModelHistory;
import org.flowable.ui.modeler.domain.ModelRelation;
import org.flowable.ui.modeler.model.ModelKeyRepresentation;
import org.flowable.ui.modeler.model.ModelRepresentation;
import org.flowable.ui.modeler.model.ReviveModelResultRepresentation;
import org.flowable.ui.modeler.model.decisiontable.DecisionTableDefinitionRepresentation;
import org.flowable.ui.modeler.repository.ModelHistoryRepository;
import org.flowable.ui.modeler.repository.ModelRelationRepository;
import org.flowable.ui.modeler.repository.ModelRepository;
import org.flowable.ui.modeler.service.ConverterContext;
import org.flowable.ui.modeler.service.ModelImageService;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ModelServiceImpl
implements ModelService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelServiceImpl.class);
    public static final String NAMESPACE = "http://flowable.org/modeler";
    protected static final String PROCESS_NOT_FOUND_MESSAGE_KEY = "PROCESS.ERROR.NOT-FOUND";
    @Autowired
    protected ModelImageService modelImageService;
    @Autowired
    protected ModelRepository modelRepository;
    @Autowired
    protected ModelHistoryRepository modelHistoryRepository;
    @Autowired
    protected ModelRelationRepository modelRelationRepository;
    @Autowired
    protected ObjectMapper objectMapper;
    protected BpmnJsonConverter bpmnJsonConverter = new BpmnJsonConverter();
    protected BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();
    protected CmmnJsonConverter cmmnJsonConverter = new CmmnJsonConverter();
    protected CmmnXmlConverter cmmnXMLConverter = new CmmnXmlConverter();

    @Override
    public Model getModel(String modelId) {
        Model model = this.modelRepository.get(modelId);
        if (model == null) {
            NotFoundException modelNotFound = new NotFoundException("No model found with the given id: " + modelId);
            modelNotFound.setMessageKey(PROCESS_NOT_FOUND_MESSAGE_KEY);
            throw modelNotFound;
        }
        return model;
    }

    @Override
    public ModelRepresentation getModelRepresentation(String modelId) {
        Model model = this.getModel(modelId);
        return new ModelRepresentation(model);
    }

    @Override
    public List<AbstractModel> getModelsByModelType(Integer modelType) {
        return new ArrayList<AbstractModel>(this.modelRepository.findByModelType(modelType, "nameAsc"));
    }

    @Override
    public ModelHistory getModelHistory(String modelId, String modelHistoryId) {
        Model model = this.getModel(modelId);
        ModelHistory modelHistory = this.modelHistoryRepository.get(modelHistoryId);
        if (modelHistory == null || modelHistory.getRemovalDate() != null || !modelHistory.getModelId().equals(model.getId())) {
            throw new NotFoundException("Process model history not found: " + modelHistoryId);
        }
        return modelHistory;
    }

    @Override
    public byte[] getBpmnXML(AbstractModel model) {
        BpmnModel bpmnModel = this.getBpmnModel(model);
        return this.getBpmnXML(bpmnModel);
    }

    @Override
    public byte[] getBpmnXML(BpmnModel bpmnModel) {
        for (Process process : bpmnModel.getProcesses()) {
            char firstCharacter;
            if (!StringUtils.isNotEmpty((CharSequence)process.getId()) || !Character.isDigit(firstCharacter = process.getId().charAt(0))) continue;
            process.setId("a" + process.getId());
        }
        byte[] xmlBytes = this.bpmnXMLConverter.convertToXML(bpmnModel);
        return xmlBytes;
    }

    @Override
    public byte[] getCmmnXML(AbstractModel model) {
        CmmnModel cmmnModel = this.getCmmnModel(model);
        return this.getCmmnXML(cmmnModel);
    }

    @Override
    public byte[] getCmmnXML(CmmnModel cmmnModel) {
        byte[] xmlBytes = this.cmmnXMLConverter.convertToXML(cmmnModel);
        return xmlBytes;
    }

    @Override
    public ModelKeyRepresentation validateModelKey(Model model, Integer modelType, String key) {
        ModelKeyRepresentation modelKeyResponse = new ModelKeyRepresentation();
        modelKeyResponse.setKey(key);
        List<Model> models = this.modelRepository.findByKeyAndType(key, modelType);
        for (Model modelInfo : models) {
            if (model != null && modelInfo.getId().equals(model.getId())) continue;
            modelKeyResponse.setKeyAlreadyExists(true);
            modelKeyResponse.setId(modelInfo.getId());
            modelKeyResponse.setName(modelInfo.getName());
            break;
        }
        return modelKeyResponse;
    }

    @Override
    public String createModelJson(ModelRepresentation model) {
        String json = null;
        if (Integer.valueOf(2).equals(model.getModelType())) {
            try {
                json = this.objectMapper.writeValueAsString((Object)new SimpleFormModel());
            }
            catch (Exception e) {
                LOGGER.error("Error creating form model", (Throwable)e);
                throw new InternalServerErrorException("Error creating form");
            }
        } else if (Integer.valueOf(4).equals(model.getModelType())) {
            try {
                DecisionTableDefinitionRepresentation decisionTableDefinition = new DecisionTableDefinitionRepresentation();
                decisionTableDefinition.setModelVersion("3");
                String decisionTableDefinitionKey = model.getName().replaceAll(" ", "");
                decisionTableDefinition.setKey(decisionTableDefinitionKey);
                json = this.objectMapper.writeValueAsString((Object)decisionTableDefinition);
            }
            catch (Exception e) {
                LOGGER.error("Error creating decision table model", (Throwable)e);
                throw new InternalServerErrorException("Error creating decision table");
            }
        } else if (Integer.valueOf(3).equals(model.getModelType())) {
            try {
                json = this.objectMapper.writeValueAsString((Object)new AppDefinition());
            }
            catch (Exception e) {
                LOGGER.error("Error creating app definition", (Throwable)e);
                throw new InternalServerErrorException("Error creating app definition");
            }
        } else if (Integer.valueOf(5).equals(model.getModelType())) {
            ObjectNode editorNode = this.objectMapper.createObjectNode();
            editorNode.put("id", "canvas");
            editorNode.put("resourceId", "canvas");
            ObjectNode stencilSetNode = this.objectMapper.createObjectNode();
            stencilSetNode.put("namespace", "http://b3mn.org/stencilset/cmmn1.1#");
            editorNode.set("stencilset", (JsonNode)stencilSetNode);
            ObjectNode propertiesNode = this.objectMapper.createObjectNode();
            propertiesNode.put("case_id", model.getKey());
            propertiesNode.put("name", model.getName());
            if (StringUtils.isNotEmpty((CharSequence)model.getDescription())) {
                propertiesNode.put("documentation", model.getDescription());
            }
            editorNode.set("properties", (JsonNode)propertiesNode);
            ArrayNode childShapeArray = this.objectMapper.createArrayNode();
            editorNode.set("childShapes", (JsonNode)childShapeArray);
            ObjectNode childNode = this.objectMapper.createObjectNode();
            childShapeArray.add((JsonNode)childNode);
            ObjectNode boundsNode = this.objectMapper.createObjectNode();
            childNode.set("bounds", (JsonNode)boundsNode);
            ObjectNode lowerRightNode = this.objectMapper.createObjectNode();
            boundsNode.set("lowerRight", (JsonNode)lowerRightNode);
            lowerRightNode.put("x", 758);
            lowerRightNode.put("y", 754);
            ObjectNode upperLeftNode = this.objectMapper.createObjectNode();
            boundsNode.set("upperLeft", (JsonNode)upperLeftNode);
            upperLeftNode.put("x", 40);
            upperLeftNode.put("y", 40);
            childNode.set("childShapes", (JsonNode)this.objectMapper.createArrayNode());
            childNode.set("dockers", (JsonNode)this.objectMapper.createArrayNode());
            childNode.set("outgoing", (JsonNode)this.objectMapper.createArrayNode());
            childNode.put("resourceId", "casePlanModel");
            ObjectNode stencilNode = this.objectMapper.createObjectNode();
            childNode.set("stencil", (JsonNode)stencilNode);
            stencilNode.put("id", "CasePlanModel");
            json = editorNode.toString();
        } else if (Integer.valueOf(6).equals(model.getModelType())) {
            ObjectNode editorNode = this.objectMapper.createObjectNode();
            editorNode.put("id", "canvas");
            editorNode.put("resourceId", "canvas");
            ObjectNode stencilSetNode = this.objectMapper.createObjectNode();
            stencilSetNode.put("namespace", "http://b3mn.org/stencilset/dmn1.2#");
            editorNode.set("stencilset", (JsonNode)stencilSetNode);
            ObjectNode canvasBoundsNode = this.objectMapper.createObjectNode();
            editorNode.set("bounds", (JsonNode)canvasBoundsNode);
            ObjectNode lowerRightCanvasNode = this.objectMapper.createObjectNode();
            canvasBoundsNode.set("lowerRight", (JsonNode)lowerRightCanvasNode);
            lowerRightCanvasNode.put("x", 1200);
            lowerRightCanvasNode.put("y", 1050);
            ObjectNode upperLeftCanvasNode = this.objectMapper.createObjectNode();
            canvasBoundsNode.set("upperLeft", (JsonNode)upperLeftCanvasNode);
            upperLeftCanvasNode.put("x", 0);
            upperLeftCanvasNode.put("y", 0);
            ObjectNode propertiesNode = this.objectMapper.createObjectNode();
            propertiesNode.put("drd_id", model.getKey());
            propertiesNode.put("name", model.getName());
            if (StringUtils.isNotEmpty((CharSequence)model.getDescription())) {
                propertiesNode.put("documentation", model.getDescription());
            }
            editorNode.set("properties", (JsonNode)propertiesNode);
            ArrayNode childShapeArray = this.objectMapper.createArrayNode();
            editorNode.set("childShapes", (JsonNode)childShapeArray);
            ObjectNode childNode = this.objectMapper.createObjectNode();
            childShapeArray.add((JsonNode)childNode);
            ObjectNode boundsNode = this.objectMapper.createObjectNode();
            childNode.set("bounds", (JsonNode)boundsNode);
            ObjectNode lowerRightNode = this.objectMapper.createObjectNode();
            boundsNode.set("lowerRight", (JsonNode)lowerRightNode);
            lowerRightNode.put("x", 750);
            lowerRightNode.put("y", 554);
            ObjectNode upperLeftNode = this.objectMapper.createObjectNode();
            boundsNode.set("upperLeft", (JsonNode)upperLeftNode);
            upperLeftNode.put("x", 150);
            upperLeftNode.put("y", 74);
            ArrayNode childShapes = this.objectMapper.createArrayNode();
            childNode.set("childShapes", (JsonNode)childShapes);
            childNode.set("dockers", (JsonNode)this.objectMapper.createArrayNode());
            childNode.set("outgoing", (JsonNode)this.objectMapper.createArrayNode());
            childNode.put("resourceId", "expandedDecisionService");
            ObjectNode stencilNode = this.objectMapper.createObjectNode();
            childNode.set("stencil", (JsonNode)stencilNode);
            stencilNode.put("id", "ExpandedDecisionService");
            ObjectNode outgoingDecisionsShape = this.objectMapper.createObjectNode();
            childShapes.add((JsonNode)outgoingDecisionsShape);
            ObjectNode outgoingDecisionsStencilNode = this.objectMapper.createObjectNode();
            outgoingDecisionsShape.set("stencil", (JsonNode)outgoingDecisionsStencilNode);
            outgoingDecisionsStencilNode.put("id", "OutputDecisionsDecisionServiceSection");
            outgoingDecisionsShape.set("childShapes", (JsonNode)this.objectMapper.createArrayNode());
            outgoingDecisionsShape.set("dockers", (JsonNode)this.objectMapper.createArrayNode());
            outgoingDecisionsShape.set("outgoing", (JsonNode)this.objectMapper.createArrayNode());
            outgoingDecisionsShape.put("resourceId", "outputDecisions");
            ObjectNode outgoingDecisionsBoundsNode = this.objectMapper.createObjectNode();
            outgoingDecisionsShape.set("bounds", (JsonNode)outgoingDecisionsBoundsNode);
            ObjectNode outgoingDecisionsLowerRightNode = this.objectMapper.createObjectNode();
            outgoingDecisionsBoundsNode.set("lowerRight", (JsonNode)outgoingDecisionsLowerRightNode);
            outgoingDecisionsLowerRightNode.put("x", 600);
            outgoingDecisionsLowerRightNode.put("y", 240);
            ObjectNode outgoingDecisionsUpperLeftNode = this.objectMapper.createObjectNode();
            outgoingDecisionsBoundsNode.set("upperLeft", (JsonNode)outgoingDecisionsUpperLeftNode);
            outgoingDecisionsUpperLeftNode.put("x", 0);
            outgoingDecisionsUpperLeftNode.put("y", 0);
            ObjectNode encapsulatedDecisionsShape = this.objectMapper.createObjectNode();
            childShapes.add((JsonNode)encapsulatedDecisionsShape);
            ObjectNode encapsulatedDecisionsStencilNode = this.objectMapper.createObjectNode();
            encapsulatedDecisionsShape.set("stencil", (JsonNode)encapsulatedDecisionsStencilNode);
            encapsulatedDecisionsStencilNode.put("id", "EncapsulatedDecisionsDecisionServiceSection");
            encapsulatedDecisionsShape.set("childShapes", (JsonNode)this.objectMapper.createArrayNode());
            encapsulatedDecisionsShape.set("dockers", (JsonNode)this.objectMapper.createArrayNode());
            encapsulatedDecisionsShape.set("outgoing", (JsonNode)this.objectMapper.createArrayNode());
            encapsulatedDecisionsShape.put("resourceId", "encapsulatedDecisions");
            ObjectNode encapsulatedDecisionsBoundsNode = this.objectMapper.createObjectNode();
            encapsulatedDecisionsShape.set("bounds", (JsonNode)encapsulatedDecisionsBoundsNode);
            ObjectNode encapsulatedDecisionsLowerRightNode = this.objectMapper.createObjectNode();
            encapsulatedDecisionsBoundsNode.set("lowerRight", (JsonNode)encapsulatedDecisionsLowerRightNode);
            encapsulatedDecisionsLowerRightNode.put("x", 600);
            encapsulatedDecisionsLowerRightNode.put("y", 480);
            ObjectNode encapsulatedDecisionsUpperLeftNode = this.objectMapper.createObjectNode();
            encapsulatedDecisionsBoundsNode.set("upperLeft", (JsonNode)encapsulatedDecisionsUpperLeftNode);
            encapsulatedDecisionsUpperLeftNode.put("x", 0);
            encapsulatedDecisionsUpperLeftNode.put("y", 240);
            json = editorNode.toString();
        } else {
            ObjectNode editorNode = this.objectMapper.createObjectNode();
            editorNode.put("id", "canvas");
            editorNode.put("resourceId", "canvas");
            ObjectNode stencilSetNode = this.objectMapper.createObjectNode();
            stencilSetNode.put("namespace", "http://b3mn.org/stencilset/bpmn2.0#");
            editorNode.set("stencilset", (JsonNode)stencilSetNode);
            ObjectNode propertiesNode = this.objectMapper.createObjectNode();
            propertiesNode.put("process_id", model.getKey());
            propertiesNode.put("name", model.getName());
            if (StringUtils.isNotEmpty((CharSequence)model.getDescription())) {
                propertiesNode.put("documentation", model.getDescription());
            }
            editorNode.set("properties", (JsonNode)propertiesNode);
            ArrayNode childShapeArray = this.objectMapper.createArrayNode();
            editorNode.set("childShapes", (JsonNode)childShapeArray);
            ObjectNode childNode = this.objectMapper.createObjectNode();
            childShapeArray.add((JsonNode)childNode);
            ObjectNode boundsNode = this.objectMapper.createObjectNode();
            childNode.set("bounds", (JsonNode)boundsNode);
            ObjectNode lowerRightNode = this.objectMapper.createObjectNode();
            boundsNode.set("lowerRight", (JsonNode)lowerRightNode);
            lowerRightNode.put("x", 130);
            lowerRightNode.put("y", 193);
            ObjectNode upperLeftNode = this.objectMapper.createObjectNode();
            boundsNode.set("upperLeft", (JsonNode)upperLeftNode);
            upperLeftNode.put("x", 100);
            upperLeftNode.put("y", 163);
            childNode.set("childShapes", (JsonNode)this.objectMapper.createArrayNode());
            childNode.set("dockers", (JsonNode)this.objectMapper.createArrayNode());
            childNode.set("outgoing", (JsonNode)this.objectMapper.createArrayNode());
            childNode.put("resourceId", "startEvent1");
            ObjectNode stencilNode = this.objectMapper.createObjectNode();
            childNode.set("stencil", (JsonNode)stencilNode);
            stencilNode.put("id", "StartNoneEvent");
            json = editorNode.toString();
        }
        return json;
    }

    @Override
    public Model createModel(Model newModel, String createdBy) {
        newModel.setVersion(1);
        newModel.setCreated(Calendar.getInstance().getTime());
        newModel.setCreatedBy(createdBy);
        newModel.setLastUpdated(Calendar.getInstance().getTime());
        newModel.setLastUpdatedBy(createdBy);
        this.persistModel(newModel);
        return newModel;
    }

    @Override
    public Model createModel(ModelRepresentation model, String editorJson, String createdBy) {
        Model newModel = new Model();
        newModel.setVersion(1);
        newModel.setName(model.getName());
        newModel.setKey(model.getKey());
        newModel.setModelType(model.getModelType());
        newModel.setCreated(Calendar.getInstance().getTime());
        newModel.setCreatedBy(createdBy);
        newModel.setDescription(model.getDescription());
        newModel.setModelEditorJson(editorJson);
        newModel.setLastUpdated(Calendar.getInstance().getTime());
        newModel.setLastUpdatedBy(createdBy);
        newModel.setTenantId(model.getTenantId());
        this.persistModel(newModel);
        return newModel;
    }

    @Override
    public ModelRepresentation importNewVersion(String modelId, String fileName, InputStream modelStream) {
        Model processModel = this.getModel(modelId);
        String currentUserId = SecurityUtils.getCurrentUserId();
        if (fileName != null && (fileName.endsWith(".bpmn") || fileName.endsWith(".bpmn20.xml"))) {
            try {
                XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
                InputStreamReader xmlIn = new InputStreamReader(modelStream, StandardCharsets.UTF_8);
                XMLStreamReader xtr = xif.createXMLStreamReader(xmlIn);
                BpmnModel bpmnModel = this.bpmnXMLConverter.convertToBpmnModel(xtr);
                if (CollectionUtils.isEmpty((Collection)bpmnModel.getProcesses())) {
                    throw new BadRequestException("No process found in definition " + fileName);
                }
                if (bpmnModel.getLocationMap().size() == 0) {
                    throw new BadRequestException("No required BPMN DI information found in definition " + fileName);
                }
                ObjectNode modelNode = this.bpmnJsonConverter.convertToJson(bpmnModel);
                Model savedModel = this.saveModel(modelId, processModel.getName(), processModel.getKey(), processModel.getDescription(), modelNode.toString(), true, "Version import via REST service", currentUserId);
                return new ModelRepresentation(savedModel);
            }
            catch (BadRequestException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BadRequestException("Import failed for " + fileName + ", error message " + e.getMessage());
            }
        }
        throw new BadRequestException("Invalid file name, only .bpmn and .bpmn20.xml files are supported not " + fileName);
    }

    @Override
    public Model createNewModelVersion(Model modelObject, String comment, String updatedBy) {
        return (Model)this.internalCreateNewModelVersion(modelObject, comment, updatedBy, false);
    }

    @Override
    public ModelHistory createNewModelVersionAndReturnModelHistory(Model modelObject, String comment, String updatedBy) {
        return (ModelHistory)this.internalCreateNewModelVersion(modelObject, comment, updatedBy, true);
    }

    protected AbstractModel internalCreateNewModelVersion(Model modelObject, String comment, String updatedBy, boolean returnModelHistory) {
        modelObject.setLastUpdated(new Date());
        modelObject.setLastUpdatedBy(updatedBy);
        modelObject.setComment(comment);
        ModelHistory historyModel = this.createNewModelhistory(modelObject);
        this.persistModelHistory(historyModel);
        modelObject.setVersion(modelObject.getVersion() + 1);
        this.persistModel(modelObject);
        return returnModelHistory ? historyModel : modelObject;
    }

    @Override
    public Model saveModel(Model modelObject) {
        return this.persistModel(modelObject);
    }

    @Override
    public Model saveModel(Model modelObject, String editorJson, byte[] imageBytes, boolean newVersion, String newVersionComment, String updatedBy) {
        return this.internalSave(modelObject.getName(), modelObject.getKey(), modelObject.getDescription(), editorJson, newVersion, newVersionComment, imageBytes, updatedBy, modelObject);
    }

    @Override
    public Model saveModel(String modelId, String name, String key, String description, String editorJson, boolean newVersion, String newVersionComment, String updatedBy) {
        Model modelObject = this.modelRepository.get(modelId);
        return this.internalSave(name, key, description, editorJson, newVersion, newVersionComment, null, updatedBy, modelObject);
    }

    protected Model internalSave(String name, String key, String description, String editorJson, boolean newVersion, String newVersionComment, byte[] imageBytes, String updatedBy, Model modelObject) {
        if (!newVersion) {
            modelObject.setLastUpdated(new Date());
            modelObject.setLastUpdatedBy(updatedBy);
            modelObject.setName(name);
            modelObject.setKey(key);
            modelObject.setDescription(description);
            modelObject.setModelEditorJson(editorJson);
            if (imageBytes != null) {
                modelObject.setThumbnail(imageBytes);
            }
        } else {
            ModelHistory historyModel = this.createNewModelhistory(modelObject);
            this.persistModelHistory(historyModel);
            modelObject.setVersion(modelObject.getVersion() + 1);
            modelObject.setLastUpdated(new Date());
            modelObject.setLastUpdatedBy(updatedBy);
            modelObject.setName(name);
            modelObject.setKey(key);
            modelObject.setDescription(description);
            modelObject.setModelEditorJson(editorJson);
            modelObject.setComment(newVersionComment);
            if (imageBytes != null) {
                modelObject.setThumbnail(imageBytes);
            }
        }
        return this.persistModel(modelObject);
    }

    @Override
    public void deleteModel(String modelId) {
        Model model = this.modelRepository.get(modelId);
        if (model == null) {
            throw new IllegalArgumentException("No model found with id: " + modelId);
        }
        List<ModelHistory> history = this.modelHistoryRepository.findByModelId(model.getId());
        ModelHistory historyModel = this.createNewModelhistory(model);
        historyModel.setRemovalDate(Calendar.getInstance().getTime());
        this.persistModelHistory(historyModel);
        this.deleteModelAndChildren(model);
    }

    protected void deleteModelAndChildren(Model model) {
        ArrayList<Model> allModels = new ArrayList<Model>();
        this.internalDeleteModelAndChildren(model, allModels);
        for (Model modelToDelete : allModels) {
            this.modelRepository.delete(modelToDelete);
        }
    }

    protected void internalDeleteModelAndChildren(Model model, List<Model> allModels) {
        this.modelRelationRepository.deleteModelRelationsForParentModel(model.getId());
        allModels.add(model);
    }

    @Override
    public ReviveModelResultRepresentation reviveProcessModelHistory(ModelHistory modelHistory, String userId, String newVersionComment) {
        Model latestModel = this.modelRepository.get(modelHistory.getModelId());
        if (latestModel == null) {
            throw new IllegalArgumentException("No process model found with id: " + modelHistory.getModelId());
        }
        ModelHistory latestModelHistory = this.createNewModelhistory(latestModel);
        this.persistModelHistory(latestModelHistory);
        latestModel.setVersion(latestModel.getVersion() + 1);
        latestModel.setLastUpdated(new Date());
        latestModel.setLastUpdatedBy(userId);
        latestModel.setName(modelHistory.getName());
        latestModel.setKey(modelHistory.getKey());
        latestModel.setDescription(modelHistory.getDescription());
        latestModel.setModelEditorJson(modelHistory.getModelEditorJson());
        latestModel.setModelType(modelHistory.getModelType());
        latestModel.setComment(newVersionComment);
        this.persistModel(latestModel);
        ReviveModelResultRepresentation result = new ReviveModelResultRepresentation();
        if (latestModel.getModelType() == 3 && StringUtils.isNotEmpty((CharSequence)latestModel.getModelEditorJson())) {
            try {
                AppDefinition appDefinition = (AppDefinition)this.objectMapper.readValue(latestModel.getModelEditorJson(), AppDefinition.class);
                for (AppModelDefinition appModelDefinition : appDefinition.getModels()) {
                    if (this.modelRepository.get(appModelDefinition.getId()) != null) continue;
                    result.getUnresolvedModels().add(new ReviveModelResultRepresentation.UnresolveModelRepresentation(appModelDefinition.getId(), appModelDefinition.getName(), appModelDefinition.getLastUpdatedBy()));
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not deserialize app model json (id = {})", (Object)latestModel.getId(), (Object)e);
            }
        }
        return result;
    }

    @Override
    public BpmnModel getBpmnModel(AbstractModel model) {
        BpmnModel bpmnModel = null;
        try {
            ConverterContext converterContext = new ConverterContext(this, this.objectMapper);
            List<Model> referencedModels = this.modelRepository.findByParentModelId(model.getId());
            for (Model childModel : referencedModels) {
                if (2 == childModel.getModelType()) {
                    converterContext.addFormModel(childModel);
                    continue;
                }
                if (4 == childModel.getModelType()) {
                    converterContext.addDecisionTableModel(childModel);
                    continue;
                }
                if (6 != childModel.getModelType()) continue;
                converterContext.addDecisionServiceModel(childModel);
            }
            bpmnModel = this.getBpmnModel(model, converterContext);
        }
        catch (Exception e) {
            LOGGER.error("Could not generate BPMN 2.0 model for {}", (Object)model.getId(), (Object)e);
            throw new InternalServerErrorException("Could not generate BPMN 2.0 model");
        }
        return bpmnModel;
    }

    @Override
    public BpmnModel getBpmnModel(AbstractModel model, ConverterContext appConverterContext) {
        try {
            ObjectNode editorJsonNode = (ObjectNode)this.objectMapper.readTree(model.getModelEditorJson());
            return this.bpmnJsonConverter.convertToBpmnModel((JsonNode)editorJsonNode, (BpmnJsonConverterContext)appConverterContext);
        }
        catch (Exception e) {
            LOGGER.error("Could not generate BPMN 2.0 model for {}", (Object)model.getId(), (Object)e);
            throw new InternalServerErrorException("Could not generate BPMN 2.0 model");
        }
    }

    @Override
    public CmmnModel getCmmnModel(AbstractModel model) {
        CmmnModel cmmnModel = null;
        try {
            ConverterContext converterContext = new ConverterContext(this, this.objectMapper);
            List<Model> referencedModels = this.modelRepository.findByParentModelId(model.getId());
            for (Model childModel : referencedModels) {
                if (2 == childModel.getModelType()) {
                    converterContext.addFormModel(childModel);
                    continue;
                }
                if (4 == childModel.getModelType()) {
                    converterContext.addDecisionTableModel(childModel);
                    continue;
                }
                if (6 == childModel.getModelType()) {
                    converterContext.addDecisionServiceModel(childModel);
                    continue;
                }
                if (5 == childModel.getModelType()) {
                    converterContext.addCaseModel(childModel);
                    continue;
                }
                if (0 != childModel.getModelType()) continue;
                converterContext.addProcessModel(childModel);
            }
            cmmnModel = this.getCmmnModel(model, converterContext);
        }
        catch (Exception e) {
            LOGGER.error("Could not generate CMMN model for {}", (Object)model.getId(), (Object)e);
            throw new InternalServerErrorException("Could not generate CMMN model");
        }
        return cmmnModel;
    }

    @Override
    public CmmnModel getCmmnModel(AbstractModel model, ConverterContext converterContext) {
        try {
            ObjectNode editorJsonNode = (ObjectNode)this.objectMapper.readTree(model.getModelEditorJson());
            return this.cmmnJsonConverter.convertToCmmnModel((JsonNode)editorJsonNode, (CmmnJsonConverterContext)converterContext);
        }
        catch (Exception e) {
            LOGGER.error("Could not generate CMMN model for {}", (Object)model.getId(), (Object)e);
            throw new InternalServerErrorException("Could not generate CMMN model");
        }
    }

    protected void addOrUpdateExtensionElement(String name, String value, UserTask userTask) {
        List extensionElements = (List)userTask.getExtensionElements().get(name);
        ExtensionElement extensionElement = CollectionUtils.isNotEmpty((Collection)extensionElements) ? (ExtensionElement)extensionElements.get(0) : new ExtensionElement();
        extensionElement.setNamespace(NAMESPACE);
        extensionElement.setNamespacePrefix("modeler");
        extensionElement.setName(name);
        extensionElement.setElementText(value);
        if (CollectionUtils.isEmpty((Collection)extensionElements)) {
            userTask.addExtensionElement(extensionElement);
        }
    }

    @Override
    public Long getModelCountForUser(String userId, int modelType) {
        return this.modelRepository.countByModelTypeAndCreatedBy(modelType, userId);
    }

    protected Model persistModel(Model model) {
        if (StringUtils.isNotEmpty((CharSequence)model.getModelEditorJson())) {
            ObjectNode jsonNode = null;
            try {
                jsonNode = (ObjectNode)this.objectMapper.readTree(model.getModelEditorJson());
            }
            catch (Exception e) {
                LOGGER.error("Could not deserialize json model", (Throwable)e);
                throw new InternalServerErrorException("Could not deserialize json model");
            }
            if (model.getModelType() == null || model.getModelType() == 0) {
                byte[] thumbnail = this.modelImageService.generateThumbnailImage(model, jsonNode);
                if (thumbnail != null) {
                    model.setThumbnail(thumbnail);
                }
                this.modelRepository.save(model);
                this.handleBpmnProcessFormModelRelations(model, jsonNode);
                this.handleBpmnProcessDecisionTaskModelRelations(model, jsonNode);
            } else if (model.getModelType() == 5) {
                byte[] thumbnail = this.modelImageService.generateCmmnThumbnailImage(model, jsonNode);
                if (thumbnail != null) {
                    model.setThumbnail(thumbnail);
                }
                this.modelRepository.save(model);
                this.handleCmmnFormModelRelations(model, jsonNode);
                this.handleCmmnDecisionModelRelations(model, jsonNode);
                this.handleCmmnCaseModelRelations(model, jsonNode);
                this.handleCmmnProcessModelRelations(model, jsonNode);
            } else if (model.getModelType() == 2 || model.getModelType() == 4) {
                jsonNode.put("name", model.getName());
                jsonNode.put("key", model.getKey());
                this.modelRepository.save(model);
            } else if (model.getModelType() == 3) {
                this.modelRepository.save(model);
                this.handleAppModelProcessRelations(model, jsonNode);
            } else if (model.getModelType() == 6) {
                byte[] thumbnail = this.modelImageService.generateDmnThumbnailImage(model, jsonNode);
                if (thumbnail != null) {
                    model.setThumbnail(thumbnail);
                }
                this.modelRepository.save(model);
                this.handleDecisionServiceModelDecisionTableRelations(model, jsonNode);
            }
        }
        return model;
    }

    protected void persistModelHistory(ModelHistory modelHistory) {
        this.modelHistoryRepository.save(modelHistory);
    }

    protected void handleBpmnProcessFormModelRelations(AbstractModel bpmnProcessModel, ObjectNode editorJsonNode) {
        List formReferenceNodes = JsonConverterUtil.filterOutJsonNodes((List)JsonConverterUtil.getBpmnProcessModelFormReferences((JsonNode)editorJsonNode));
        Set formIds = JsonConverterUtil.gatherStringPropertyFromJsonNodes((Iterable)formReferenceNodes, (String)"id");
        this.handleModelRelations(bpmnProcessModel, formIds, "form-model");
    }

    protected void handleBpmnProcessDecisionTaskModelRelations(AbstractModel bpmnProcessModel, ObjectNode editorJsonNode) {
        List decisionTableNodes = JsonConverterUtil.filterOutJsonNodes((List)JsonConverterUtil.getBpmnProcessModelDecisionTableReferences((JsonNode)editorJsonNode));
        Set decisionTableIds = JsonConverterUtil.gatherStringPropertyFromJsonNodes((Iterable)decisionTableNodes, (String)"id");
        this.handleModelRelations(bpmnProcessModel, decisionTableIds, "decision-table-model");
        List decisionServiceNodes = JsonConverterUtil.filterOutJsonNodes((List)JsonConverterUtil.getBpmnProcessModelDecisionServiceReferences((JsonNode)editorJsonNode));
        Set decisionServiceIds = JsonConverterUtil.gatherStringPropertyFromJsonNodes((Iterable)decisionServiceNodes, (String)"id");
        this.handleModelRelations(bpmnProcessModel, decisionServiceIds, "decision-service-model");
    }

    protected void handleCmmnFormModelRelations(AbstractModel caseModel, ObjectNode editorJsonNode) {
        List formReferenceNodes = CmmnModelJsonConverterUtil.filterOutJsonNodes((List)CmmnModelJsonConverterUtil.getCmmnModelFormReferences((JsonNode)editorJsonNode));
        Set formIds = JsonConverterUtil.gatherStringPropertyFromJsonNodes((Iterable)formReferenceNodes, (String)"id");
        this.handleModelRelations(caseModel, formIds, "form-model");
    }

    protected void handleCmmnDecisionModelRelations(AbstractModel caseModel, ObjectNode editorJsonNode) {
        List processReferenceNodes = CmmnModelJsonConverterUtil.filterOutJsonNodes((List)CmmnModelJsonConverterUtil.getCmmnModelDecisionTableReferences((JsonNode)editorJsonNode));
        Set processModelIds = JsonConverterUtil.gatherStringPropertyFromJsonNodes((Iterable)processReferenceNodes, (String)"id");
        this.handleModelRelations(caseModel, processModelIds, "decision-table-model");
    }

    protected void handleCmmnCaseModelRelations(AbstractModel caseModel, ObjectNode editorJsonNode) {
        List caseReferenceNodes = CmmnModelJsonConverterUtil.filterOutJsonNodes((List)CmmnModelJsonConverterUtil.getCmmnModelCaseReferences((JsonNode)editorJsonNode));
        Set caseModelIds = JsonConverterUtil.gatherStringPropertyFromJsonNodes((Iterable)caseReferenceNodes, (String)"id");
        this.handleModelRelations(caseModel, caseModelIds, "case-model-child");
    }

    protected void handleCmmnProcessModelRelations(AbstractModel caseModel, ObjectNode editorJsonNode) {
        List processReferenceNodes = CmmnModelJsonConverterUtil.filterOutJsonNodes((List)CmmnModelJsonConverterUtil.getCmmnModelProcessReferences((JsonNode)editorJsonNode));
        Set processModelIds = JsonConverterUtil.gatherStringPropertyFromJsonNodes((Iterable)processReferenceNodes, (String)"id");
        this.handleModelRelations(caseModel, processModelIds, "process-model-child");
    }

    protected void handleAppModelProcessRelations(AbstractModel appModel, ObjectNode appModelJsonNode) {
        Set processModelIds = JsonConverterUtil.getAppModelReferencedModelIds((JsonNode)appModelJsonNode);
        this.handleModelRelations(appModel, processModelIds, "process-model");
    }

    protected void handleDecisionServiceModelDecisionTableRelations(AbstractModel decisionServiceModel, ObjectNode editorJsonNode) {
        List decisionTableNodes = DmnJsonConverterUtil.filterOutJsonNodes((List)DmnJsonConverterUtil.getDmnModelDecisionTableReferences((ObjectNode)editorJsonNode));
        Set decisionTableIds = JsonConverterUtil.gatherStringPropertyFromJsonNodes((Iterable)decisionTableNodes, (String)"id");
        this.handleModelRelations(decisionServiceModel, decisionTableIds, "decision-table-model");
    }

    protected void handleModelRelations(AbstractModel bpmnProcessModel, Set<String> idsReferencedInJson, String relationshipType) {
        List<ModelRelation> persistedModelRelations = this.modelRelationRepository.findByParentModelIdAndType(bpmnProcessModel.getId(), relationshipType);
        if (idsReferencedInJson == null || idsReferencedInJson.size() == 0) {
            for (ModelRelation modelRelation : persistedModelRelations) {
                this.modelRelationRepository.delete(modelRelation);
            }
            return;
        }
        HashSet<String> alreadyPersistedModelIds = new HashSet<String>(persistedModelRelations.size());
        for (ModelRelation persistedModelRelation : persistedModelRelations) {
            if (!idsReferencedInJson.contains(persistedModelRelation.getModelId())) {
                this.modelRelationRepository.delete(persistedModelRelation);
                continue;
            }
            alreadyPersistedModelIds.add(persistedModelRelation.getModelId());
        }
        for (String idReferencedInJson : idsReferencedInJson) {
            if (alreadyPersistedModelIds.contains(idReferencedInJson) || this.modelRepository.get(idReferencedInJson) == null) continue;
            this.modelRelationRepository.save(new ModelRelation(bpmnProcessModel.getId(), idReferencedInJson, relationshipType));
        }
    }

    protected ModelHistory createNewModelhistory(Model model) {
        ModelHistory historyModel = new ModelHistory();
        historyModel.setName(model.getName());
        historyModel.setKey(model.getKey());
        historyModel.setDescription(model.getDescription());
        historyModel.setCreated(model.getCreated());
        historyModel.setLastUpdated(model.getLastUpdated());
        historyModel.setCreatedBy(model.getCreatedBy());
        historyModel.setLastUpdatedBy(model.getLastUpdatedBy());
        historyModel.setModelEditorJson(model.getModelEditorJson());
        historyModel.setModelType(model.getModelType());
        historyModel.setVersion(model.getVersion());
        historyModel.setModelId(model.getId());
        historyModel.setComment(model.getComment());
        historyModel.setTenantId(model.getTenantId());
        return historyModel;
    }

    protected void populateModelBasedOnHistory(Model model, ModelHistory basedOn) {
        model.setName(basedOn.getName());
        model.setKey(basedOn.getKey());
        model.setDescription(basedOn.getDescription());
        model.setCreated(basedOn.getCreated());
        model.setLastUpdated(basedOn.getLastUpdated());
        model.setCreatedBy(basedOn.getCreatedBy());
        model.setLastUpdatedBy(basedOn.getLastUpdatedBy());
        model.setModelEditorJson(basedOn.getModelEditorJson());
        model.setModelType(basedOn.getModelType());
        model.setVersion(basedOn.getVersion());
        model.setComment(basedOn.getComment());
        model.setTenantId(basedOn.getTenantId());
    }

    protected Map<String, String> convertToModelKeyMap(Map<String, Model> modelMap) {
        HashMap<String, String> modelKeyMap = new HashMap<String, String>();
        if (modelMap != null) {
            for (Model formModel : modelMap.values()) {
                modelKeyMap.put(formModel.getId(), formModel.getKey());
            }
        }
        return modelKeyMap;
    }
}

