/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterContext;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.dmn.editor.converter.DmnJsonConverter;
import org.flowable.dmn.editor.converter.DmnJsonConverterContext;
import org.flowable.dmn.editor.converter.DmnJsonConverterUtil;
import org.flowable.editor.language.json.converter.BpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterContext;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.AppDefinition;
import org.flowable.ui.modeler.domain.AppModelDefinition;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.model.AppDefinitionPublishRepresentation;
import org.flowable.ui.modeler.model.AppDefinitionRepresentation;
import org.flowable.ui.modeler.model.AppDefinitionUpdateResultRepresentation;
import org.flowable.ui.modeler.repository.ModelRepository;
import org.flowable.ui.modeler.service.AppDefinitionPublishService;
import org.flowable.ui.modeler.service.ConverterContext;
import org.flowable.ui.modeler.service.DecisionTableModelConversionUtil;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class AppDefinitionImportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppDefinitionImportService.class);
    @Autowired
    protected AppDefinitionPublishService appDefinitionPublishService;
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected ModelRepository modelRepository;
    @Autowired
    protected ObjectMapper objectMapper;
    protected BpmnJsonConverter bpmnJsonConverter = new BpmnJsonConverter();
    protected CmmnJsonConverter cmmnJsonConverter = new CmmnJsonConverter();
    protected DmnJsonConverter dmnJsonConverter = new DmnJsonConverter();

    public AppDefinitionRepresentation importAppDefinition(HttpServletRequest request, MultipartFile file) {
        try {
            InputStream is = file.getInputStream();
            String fileName = file.getOriginalFilename();
            ConverterContext converterContext = new ConverterContext(this.modelService, this.objectMapper);
            return this.importAppDefinition(is, fileName, null, converterContext);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error loading file", (Throwable)e);
        }
    }

    public AppDefinitionRepresentation importAppDefinitionNewVersion(HttpServletRequest request, MultipartFile file, String appDefId) {
        try {
            List<Model> referencedDecisionTableChildModels;
            List<Model> referencedModels;
            InputStream is = file.getInputStream();
            String fileName = file.getOriginalFilename();
            Model appModel = this.modelService.getModel(appDefId);
            if (!appModel.getModelType().equals(3)) {
                throw new BadRequestException("No app definition found for id " + appDefId);
            }
            AppDefinitionRepresentation appDefinition = this.createAppDefinitionRepresentation(appModel);
            ConverterContext converterContext = new ConverterContext(this.modelService, this.objectMapper);
            if (appDefinition.getDefinition() != null && CollectionUtils.isNotEmpty(appDefinition.getDefinition().getModels())) {
                for (AppModelDefinition modelDef : appDefinition.getDefinition().getModels()) {
                    Model processModel = this.modelService.getModel(modelDef.getId());
                    referencedModels = this.modelRepository.findByParentModelId(processModel.getId());
                    for (Model childModel : referencedModels) {
                        if (2 == childModel.getModelType()) {
                            converterContext.addFormModel(childModel);
                            continue;
                        }
                        if (4 == childModel.getModelType()) {
                            converterContext.addDecisionTableModel(childModel);
                            continue;
                        }
                        if (6 != childModel.getModelType()) continue;
                        converterContext.addDecisionServiceModel(childModel);
                        referencedDecisionTableChildModels = this.modelRepository.findByParentModelId(childModel.getId());
                        for (Model decisionTableChildModel : referencedDecisionTableChildModels) {
                            converterContext.addDecisionTableModel(decisionTableChildModel);
                        }
                    }
                    converterContext.addProcessModel(processModel);
                }
            }
            if (appDefinition.getDefinition() != null && CollectionUtils.isNotEmpty(appDefinition.getDefinition().getCmmnModels())) {
                for (AppModelDefinition modelDef : appDefinition.getDefinition().getCmmnModels()) {
                    Model caseModel = this.modelService.getModel(modelDef.getId());
                    referencedModels = this.modelRepository.findByParentModelId(caseModel.getId());
                    for (Model childModel : referencedModels) {
                        if (2 == childModel.getModelType()) {
                            converterContext.addFormModel(childModel);
                            continue;
                        }
                        if (4 == childModel.getModelType()) {
                            converterContext.addDecisionTableModel(childModel);
                            continue;
                        }
                        if (6 != childModel.getModelType()) continue;
                        converterContext.addDecisionServiceModel(childModel);
                        referencedDecisionTableChildModels = this.modelRepository.findByParentModelId(childModel.getId());
                        for (Model decisionTableChildModel : referencedDecisionTableChildModels) {
                            converterContext.addDecisionTableModel(decisionTableChildModel);
                        }
                    }
                    converterContext.addCaseModel(caseModel);
                }
            }
            return this.importAppDefinition(is, fileName, appModel, converterContext);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error loading file", (Throwable)e);
        }
    }

    protected AppDefinitionRepresentation importAppDefinition(InputStream is, String fileName, Model existingAppModel, ConverterContext converterContext) {
        if (fileName != null && fileName.endsWith(".zip")) {
            Model appDefinitionModel = this.readZipFile(is, converterContext);
            if (StringUtils.isNotEmpty((CharSequence)appDefinitionModel.getKey()) && StringUtils.isNotEmpty((CharSequence)appDefinitionModel.getModelEditorJson())) {
                this.importForms(converterContext);
                this.importDecisionTables(converterContext);
                this.importDecisionServices(converterContext);
                this.importBpmnModels(converterContext);
                this.importCmmnModels(converterContext);
                return this.importAppDefinitionModel(appDefinitionModel, existingAppModel, converterContext);
            }
            throw new BadRequestException("Could not find app definition json");
        }
        throw new BadRequestException("Invalid file name, only .zip files are supported not " + fileName);
    }

    public AppDefinitionUpdateResultRepresentation publishAppDefinition(String modelId, AppDefinitionPublishRepresentation publishModel) {
        String currentUserId = SecurityUtils.getCurrentUserId();
        Model appModel = this.modelService.getModel(modelId);
        AppDefinitionRepresentation appDefinitionRepresentation = this.createAppDefinitionRepresentation(appModel);
        AppDefinitionUpdateResultRepresentation result = new AppDefinitionUpdateResultRepresentation();
        this.appDefinitionPublishService.publishAppDefinition(publishModel.getComment(), appModel, currentUserId);
        result.setAppDefinition(appDefinitionRepresentation);
        return result;
    }

    protected AppDefinitionRepresentation createAppDefinitionRepresentation(AbstractModel model) {
        AppDefinition appDefinition = null;
        try {
            appDefinition = (AppDefinition)this.objectMapper.readValue(model.getModelEditorJson(), AppDefinition.class);
        }
        catch (Exception e) {
            LOGGER.error("Error deserializing app {}", (Object)model.getId(), (Object)e);
            throw new InternalServerErrorException("Could not deserialize app definition");
        }
        AppDefinitionRepresentation result = new AppDefinitionRepresentation(model);
        result.setDefinition(appDefinition);
        return result;
    }

    protected Model readZipFile(InputStream inputStream, ConverterContext converterContext) {
        Model appDefinitionModel = null;
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(inputStream);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String zipEntryName = zipEntry.getName();
                if (zipEntryName.endsWith("json") || zipEntryName.endsWith("png")) {
                    String modelFileName = null;
                    modelFileName = zipEntryName.contains("/") ? zipEntryName.substring(zipEntryName.indexOf(47) + 1) : zipEntryName;
                    if (modelFileName.endsWith(".png")) {
                        converterContext.getModelKeyToThumbnailMap().put(modelFileName.replace(".png", ""), IOUtils.toByteArray((InputStream)zipInputStream));
                    } else {
                        modelFileName = modelFileName.replace(".json", "");
                        String json = IOUtils.toString((InputStream)zipInputStream, (Charset)StandardCharsets.UTF_8);
                        if (zipEntryName.startsWith("bpmn-models/")) {
                            converterContext.getProcessKeyToJsonStringMap().put(modelFileName, json);
                        } else if (zipEntryName.startsWith("cmmn-models/")) {
                            converterContext.getCaseKeyToJsonStringMap().put(modelFileName, json);
                        } else if (zipEntryName.startsWith("form-models/")) {
                            converterContext.getFormKeyToJsonStringMap().put(modelFileName, json);
                        } else if (zipEntryName.startsWith("decision-table-models/")) {
                            converterContext.getDecisionTableKeyToJsonStringMap().put(modelFileName, json);
                        } else if (zipEntryName.startsWith("decision-service-models/")) {
                            converterContext.getDecisionServiceKeyToJsonStringMap().put(modelFileName, json);
                        } else if (!zipEntryName.contains("/")) {
                            appDefinitionModel = this.createModelObject(json, 3);
                        }
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error reading app definition zip file", (Throwable)e);
            throw new InternalServerErrorException("Error reading app definition zip file");
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.closeEntry();
                }
                catch (Exception exception) {}
                try {
                    zipInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return appDefinitionModel;
    }

    protected void importForms(ConverterContext converterContext) {
        Map<String, String> formMap = converterContext.getFormKeyToJsonStringMap();
        Map<String, byte[]> thumbnailMap = converterContext.getModelKeyToThumbnailMap();
        for (String formKey : formMap.keySet()) {
            Model formModel = this.createModelObject(formMap.get(formKey), 2);
            Model existingModel = converterContext.getFormModelByKey(formModel.getKey());
            Model updatedFormModel = null;
            if (existingModel != null) {
                byte[] imageBytes = null;
                if (thumbnailMap.containsKey(formKey)) {
                    imageBytes = thumbnailMap.get(formKey);
                }
                updatedFormModel = this.modelService.saveModel(existingModel, formModel.getModelEditorJson(), imageBytes, true, "App definition import", SecurityUtils.getCurrentUserId());
            } else {
                formModel.setId(null);
                updatedFormModel = this.modelService.createModel(formModel, SecurityUtils.getCurrentUserId());
                if (thumbnailMap.containsKey(formKey)) {
                    updatedFormModel.setThumbnail(thumbnailMap.get(formKey));
                    this.modelRepository.save(updatedFormModel);
                }
            }
            converterContext.addFormModel(updatedFormModel, formModel.getId());
        }
    }

    protected void importDecisionTables(ConverterContext converterContext) {
        Map<String, String> decisionTableMap = converterContext.getDecisionTableKeyToJsonStringMap();
        Map<String, byte[]> thumbnailMap = converterContext.getModelKeyToThumbnailMap();
        String currentUserId = SecurityUtils.getCurrentUserId();
        for (String decisionTableKey : decisionTableMap.keySet()) {
            Model decisionTableModel = this.createModelObject(decisionTableMap.get(decisionTableKey), 4);
            DecisionTableModelConversionUtil.convertModelToV3(decisionTableModel);
            String oldDecisionTableId = decisionTableModel.getId();
            Model existingModel = converterContext.getDecisionTableModelByKey(decisionTableModel.getKey());
            Model updatedDecisionTableModel = null;
            if (existingModel != null) {
                byte[] imageBytes = null;
                if (thumbnailMap.containsKey(decisionTableKey)) {
                    imageBytes = thumbnailMap.get(decisionTableKey);
                }
                updatedDecisionTableModel = this.modelService.saveModel(existingModel, decisionTableModel.getModelEditorJson(), imageBytes, true, "App definition import", currentUserId);
            } else {
                decisionTableModel.setId(null);
                updatedDecisionTableModel = this.modelService.createModel(decisionTableModel, currentUserId);
                if (thumbnailMap.containsKey(decisionTableKey)) {
                    updatedDecisionTableModel.setThumbnail(thumbnailMap.get(decisionTableKey));
                    this.modelRepository.save(updatedDecisionTableModel);
                }
            }
            converterContext.addDecisionTableModel(updatedDecisionTableModel, oldDecisionTableId);
        }
    }

    protected void importDecisionServices(ConverterContext converterContext) {
        Map<String, String> decisionServicesMap = converterContext.getDecisionServiceKeyToJsonStringMap();
        Map<String, byte[]> thumbnailMap = converterContext.getModelKeyToThumbnailMap();
        String currentUserId = SecurityUtils.getCurrentUserId();
        for (String decisionServiceKey : decisionServicesMap.keySet()) {
            Model updatedDecisionServiceModel;
            ObjectNode decisionServiceModelNode;
            Model decisionServiceModel = this.createModelObject(decisionServicesMap.get(decisionServiceKey), 6);
            String oldDecisionServiceId = decisionServiceModel.getId();
            try {
                decisionServiceModelNode = (ObjectNode)this.objectMapper.readTree(decisionServiceModel.getModelEditorJson());
            }
            catch (Exception e) {
                LOGGER.error("Error reading decision service json for {}", (Object)decisionServiceKey, (Object)e);
                throw new InternalServerErrorException("Error reading decision service json for " + decisionServiceKey);
            }
            decisionServiceModelNode.remove("modelId");
            DmnJsonConverterUtil.updateDecisionTableModelReferences((ObjectNode)decisionServiceModelNode, (DmnJsonConverterContext)converterContext);
            String updatedDecisionServiceJson = decisionServiceModelNode.toString();
            Model existingModel = converterContext.getDecisionServiceModelByKey(decisionServiceModel.getKey());
            if (existingModel != null) {
                byte[] imageBytes = null;
                if (thumbnailMap.containsKey(decisionServiceKey)) {
                    imageBytes = thumbnailMap.get(decisionServiceKey);
                }
                existingModel.setModelEditorJson(updatedDecisionServiceJson);
                updatedDecisionServiceModel = this.modelService.saveModel(existingModel, existingModel.getModelEditorJson(), imageBytes, true, "App definition import", currentUserId);
            } else {
                decisionServiceModel.setId(null);
                decisionServiceModel.setModelEditorJson(updatedDecisionServiceJson);
                updatedDecisionServiceModel = this.modelService.createModel(decisionServiceModel, currentUserId);
                if (thumbnailMap.containsKey(decisionServiceKey)) {
                    updatedDecisionServiceModel.setThumbnail(thumbnailMap.get(decisionServiceKey));
                    this.modelRepository.save(updatedDecisionServiceModel);
                }
            }
            converterContext.addDecisionServiceModel(updatedDecisionServiceModel, oldDecisionServiceId);
        }
    }

    protected void importBpmnModels(ConverterContext converterContext) {
        Map<String, String> bpmnModelMap = converterContext.getProcessKeyToJsonStringMap();
        Map<String, byte[]> thumbnailMap = converterContext.getModelKeyToThumbnailMap();
        String currentUserId = SecurityUtils.getCurrentUserId();
        for (String bpmnModelKey : bpmnModelMap.keySet()) {
            String bpmnModelJson = bpmnModelMap.get(bpmnModelKey);
            Model bpmnModelObject = this.createModelObject(bpmnModelJson, 0);
            String oldBpmnModelId = bpmnModelObject.getId();
            JsonNode bpmnModelNode = null;
            try {
                bpmnModelNode = this.objectMapper.readTree(bpmnModelObject.getModelEditorJson());
            }
            catch (Exception e) {
                LOGGER.error("Error reading BPMN json for {}", (Object)bpmnModelKey, (Object)e);
                throw new InternalServerErrorException("Error reading BPMN json for " + bpmnModelKey);
            }
            BpmnModel bpmnModel = this.bpmnJsonConverter.convertToBpmnModel(bpmnModelNode, (BpmnJsonConverterContext)converterContext);
            String updatedBpmnJson = this.bpmnJsonConverter.convertToJson(bpmnModel, (BpmnJsonConverterContext)converterContext).toString();
            Model existingModel = converterContext.getProcessModelByKey(bpmnModelKey);
            Model updatedProcessModel = null;
            if (existingModel != null) {
                byte[] imageBytes = null;
                if (thumbnailMap.containsKey(bpmnModelKey)) {
                    imageBytes = thumbnailMap.get(bpmnModelKey);
                }
                existingModel.setModelEditorJson(updatedBpmnJson);
                updatedProcessModel = this.modelService.saveModel(existingModel, existingModel.getModelEditorJson(), imageBytes, true, "App definition import", currentUserId);
            } else {
                bpmnModelObject.setId(null);
                bpmnModelObject.setModelEditorJson(updatedBpmnJson);
                updatedProcessModel = this.modelService.createModel(bpmnModelObject, currentUserId);
                if (thumbnailMap.containsKey(bpmnModelKey)) {
                    updatedProcessModel.setThumbnail(thumbnailMap.get(bpmnModelKey));
                    this.modelService.saveModel(updatedProcessModel);
                }
            }
            converterContext.addProcessModel(updatedProcessModel, oldBpmnModelId);
        }
    }

    protected void importCmmnModels(ConverterContext converterContext) {
        Map<String, String> cmmnModelMap = converterContext.getCaseKeyToJsonStringMap();
        Map<String, byte[]> thumbnailMap = converterContext.getModelKeyToThumbnailMap();
        String currentUserId = SecurityUtils.getCurrentUserId();
        for (String cmmnModelKey : cmmnModelMap.keySet()) {
            String cmmnModelJson = cmmnModelMap.get(cmmnModelKey);
            Model cmmnModelObject = this.createModelObject(cmmnModelJson, 5);
            String oldCmmnModelId = cmmnModelObject.getId();
            JsonNode cmmnModelNode = null;
            try {
                cmmnModelNode = this.objectMapper.readTree(cmmnModelObject.getModelEditorJson());
            }
            catch (Exception e) {
                LOGGER.error("Error reading CMMN json for {}", (Object)cmmnModelKey, (Object)e);
                throw new InternalServerErrorException("Error reading CMMN json for " + cmmnModelKey);
            }
            CmmnModel cmmnModel = this.cmmnJsonConverter.convertToCmmnModel(cmmnModelNode, (CmmnJsonConverterContext)converterContext);
            String updatedCmmnJson = this.cmmnJsonConverter.convertToJson(cmmnModel, (CmmnJsonConverterContext)converterContext).toString();
            Model existingModel = converterContext.getCaseModelByKey(cmmnModelKey);
            Model updatedCaseModel = null;
            if (existingModel != null) {
                byte[] imageBytes = null;
                if (thumbnailMap.containsKey(cmmnModelKey)) {
                    imageBytes = thumbnailMap.get(cmmnModelKey);
                }
                existingModel.setModelEditorJson(updatedCmmnJson);
                updatedCaseModel = this.modelService.saveModel(existingModel, existingModel.getModelEditorJson(), imageBytes, true, "App definition import", currentUserId);
            } else {
                cmmnModelObject.setId(null);
                cmmnModelObject.setModelEditorJson(updatedCmmnJson);
                updatedCaseModel = this.modelService.createModel(cmmnModelObject, currentUserId);
                if (thumbnailMap.containsKey(cmmnModelKey)) {
                    updatedCaseModel.setThumbnail(thumbnailMap.get(cmmnModelKey));
                    this.modelService.saveModel(updatedCaseModel);
                }
            }
            converterContext.addCaseModel(updatedCaseModel, oldCmmnModelId);
        }
    }

    protected AppDefinitionRepresentation importAppDefinitionModel(Model appDefinitionModel, Model existingAppModel, ConverterContext converterContext) {
        Model newModel;
        AppDefinition appDefinition = null;
        try {
            appDefinition = (AppDefinition)this.objectMapper.readValue(appDefinitionModel.getModelEditorJson(), AppDefinition.class);
        }
        catch (Exception e) {
            LOGGER.error("Error reading app definition {}", (Object)appDefinitionModel.getName(), (Object)e);
            throw new BadRequestException("Error reading app definition", (Throwable)e);
        }
        if (appDefinition.getModels() != null) {
            for (AppModelDefinition modelDef : appDefinition.getModels()) {
                newModel = converterContext.getProcessModelById(modelDef.getId());
                if (newModel == null) continue;
                modelDef.setId(newModel.getId());
                modelDef.setName(newModel.getName());
                modelDef.setCreatedBy(newModel.getCreatedBy());
                modelDef.setLastUpdatedBy(newModel.getLastUpdatedBy());
                modelDef.setLastUpdated(newModel.getLastUpdated());
                modelDef.setVersion(newModel.getVersion());
            }
        }
        if (appDefinition.getCmmnModels() != null) {
            for (AppModelDefinition modelDef : appDefinition.getCmmnModels()) {
                newModel = converterContext.getCaseModelById(modelDef.getId());
                if (newModel == null) continue;
                modelDef.setId(newModel.getId());
                modelDef.setName(newModel.getName());
                modelDef.setCreatedBy(newModel.getCreatedBy());
                modelDef.setLastUpdatedBy(newModel.getLastUpdatedBy());
                modelDef.setLastUpdated(newModel.getLastUpdated());
                modelDef.setVersion(newModel.getVersion());
            }
        }
        String currentUserId = SecurityUtils.getCurrentUserId();
        try {
            String updatedAppDefinitionJson = this.objectMapper.writeValueAsString((Object)appDefinition);
            if (existingAppModel != null) {
                appDefinitionModel = this.modelService.saveModel(existingAppModel, updatedAppDefinitionJson, null, true, "App definition import", currentUserId);
            } else {
                appDefinitionModel.setId(null);
                appDefinitionModel.setModelEditorJson(updatedAppDefinitionJson);
                appDefinitionModel = this.modelService.createModel(appDefinitionModel, currentUserId);
            }
            AppDefinitionRepresentation result = new AppDefinitionRepresentation(appDefinitionModel);
            result.setDefinition(appDefinition);
            return result;
        }
        catch (Exception e) {
            LOGGER.error("Error storing app definition", (Throwable)e);
            throw new InternalServerErrorException("Error storing app definition");
        }
    }

    protected Model createModelObject(String modelJson, int modelType) {
        try {
            JsonNode modelNode = this.objectMapper.readTree(modelJson);
            Model model = new Model();
            model.setId(modelNode.get("id").asText());
            model.setName(modelNode.get("name").asText());
            model.setKey(modelNode.get("key").asText());
            JsonNode descriptionNode = modelNode.get("description");
            if (descriptionNode != null && !descriptionNode.isNull()) {
                model.setDescription(descriptionNode.asText());
            }
            model.setModelEditorJson(modelNode.get("editorJson").toString());
            model.setModelType(modelType);
            return model;
        }
        catch (Exception e) {
            LOGGER.error("Error reading model json", (Throwable)e);
            throw new InternalServerErrorException("Error reading model json");
        }
    }
}

