/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.ui.common.repository.UuidIdGenerator;
import org.flowable.ui.common.tenant.TenantProvider;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.repository.ModelRepository;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ModelRepositoryImpl
implements ModelRepository {
    private static final String NAMESPACE = "org.flowable.ui.modeler.domain.Model.";
    @Autowired
    @Qualifier(value="flowableModeler")
    protected SqlSessionTemplate sqlSessionTemplate;
    @Autowired
    protected UuidIdGenerator idGenerator;
    @Autowired
    protected TenantProvider tenantProvider;

    @Override
    public Model get(String id) {
        return (Model)this.sqlSessionTemplate.selectOne("org.flowable.ui.modeler.domain.Model.selectModel", (Object)id);
    }

    @Override
    public List<Model> findByModelType(Integer modelType, String sort) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("modelType", modelType);
        params.put("sort", sort);
        return this.findModelsByParameters(params);
    }

    @Override
    public List<Model> findByModelTypeAndFilter(Integer modelType, String filter, String sort) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("modelType", modelType);
        params.put("filter", filter);
        params.put("sort", sort);
        return this.findModelsByParameters(params);
    }

    @Override
    public List<Model> findByKeyAndType(String key, Integer modelType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("key", key);
        params.put("modelType", modelType);
        return this.findModelsByParameters(params);
    }

    @Override
    public List<Model> findByParentModelId(String parentModelId) {
        return this.sqlSessionTemplate.selectList("org.flowable.ui.modeler.domain.Model.selectModelByParentModelId", (Object)parentModelId);
    }

    @Override
    public Long countByModelTypeAndCreatedBy(int modelType, String createdBy) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("createdBy", createdBy);
        params.put("modelType", modelType);
        params.put("tenantId", this.tenantProvider.getTenantId());
        return (Long)this.sqlSessionTemplate.selectOne("org.flowable.ui.modeler.domain.Model.countByModelTypeAndCreatedBy", params);
    }

    protected List<Model> findModelsByParameters(Map<String, Object> parameters) {
        parameters.put("tenantId", this.tenantProvider.getTenantId());
        return this.sqlSessionTemplate.selectList("org.flowable.ui.modeler.domain.Model.selectModelByParameters", parameters);
    }

    @Override
    public void save(Model model) {
        if (model.getId() == null) {
            model.setId(this.idGenerator.generateId());
            model.setTenantId(this.tenantProvider.getTenantId());
            this.sqlSessionTemplate.insert("org.flowable.ui.modeler.domain.Model.insertModel", (Object)model);
        } else {
            this.sqlSessionTemplate.update("org.flowable.ui.modeler.domain.Model.updateModel", (Object)model);
        }
    }

    @Override
    public void delete(Model model) {
        this.sqlSessionTemplate.delete("org.flowable.ui.modeler.domain.Model.deleteModel", (Object)model);
    }
}

