/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.security;

import org.flowable.common.engine.api.FlowableIllegalStateException;
import org.flowable.ui.common.security.FlowableSecurityScopeProvider;
import org.flowable.ui.common.security.SecurityScope;
import org.flowable.ui.common.security.SecurityScopeProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityUtils {
    static final String GROUP_PREFIX = "GROUP_";
    static final String TENANT_PREFIX = "TENANT_";
    private static SecurityScopeProvider securityScopeProvider = new FlowableSecurityScopeProvider();

    private SecurityUtils() {
    }

    public static GrantedAuthority createTenantAuthority(String tenantId) {
        return new SimpleGrantedAuthority(TENANT_PREFIX + tenantId);
    }

    public static GrantedAuthority createGroupAuthority(String groupId) {
        return new SimpleGrantedAuthority(GROUP_PREFIX + groupId);
    }

    public static void setSecurityScopeProvider(SecurityScopeProvider securityScopeProvider) {
        SecurityUtils.securityScopeProvider = securityScopeProvider;
    }

    public static String getCurrentUserId() {
        SecurityScope user = SecurityUtils.getCurrentSecurityScope();
        if (user != null) {
            return user.getUserId();
        }
        return null;
    }

    public static SecurityScope getCurrentSecurityScope() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (securityContext != null && securityContext.getAuthentication() != null) {
            return SecurityUtils.getSecurityScope(securityContext.getAuthentication());
        }
        return null;
    }

    public static SecurityScope getSecurityScope(Authentication authentication) {
        return securityScopeProvider.getSecurityScope(authentication);
    }

    public static SecurityScope getAuthenticatedSecurityScope() {
        SecurityScope currentSecurityScope = SecurityUtils.getCurrentSecurityScope();
        if (currentSecurityScope != null) {
            return currentSecurityScope;
        }
        throw new FlowableIllegalStateException("User is not authenticated");
    }
}

