/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.security;

import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.idm.api.Token;
import org.flowable.ui.common.model.RemoteToken;
import org.flowable.ui.common.security.BasePersistentTokenService;
import org.flowable.ui.common.service.idm.RemoteIdmService;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationException;

public class RemoteIdmPersistentTokenService
extends BasePersistentTokenService {
    protected final RemoteIdmService remoteIdmService;

    public RemoteIdmPersistentTokenService(RemoteIdmService remoteIdmService) {
        this.remoteIdmService = remoteIdmService;
    }

    @Override
    protected Token loadToken(String tokenId) {
        RemoteToken token = this.remoteIdmService.getToken(tokenId);
        if (token != null) {
            return token;
        }
        throw new FlowableObjectNotFoundException("Token with id '" + tokenId + "' not found.");
    }

    @Override
    public Token createToken(String userId, String remoteAddress, String userAgent) {
        throw new RememberMeAuthenticationException("Creating remote tokens is not allowed");
    }
}

