/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.security;

import org.flowable.ui.common.security.ApiHttpSecurityCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;

public class JwtApiHttpSecurityCustomizer
implements ApiHttpSecurityCustomizer {
    protected final JwtAuthenticationConverter converter;

    public JwtApiHttpSecurityCustomizer(JwtAuthenticationConverter converter) {
        this.converter = converter;
    }

    @Override
    public void customize(HttpSecurity http) throws Exception {
        JwtDecoder jwtDecoder = (JwtDecoder)((ApplicationContext)http.getSharedObject(ApplicationContext.class)).getBeanProvider(JwtDecoder.class).getIfAvailable();
        if (jwtDecoder != null) {
            http.oauth2ResourceServer().jwt().jwtAuthenticationConverter((Converter)this.converter);
        }
    }
}

