/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.security;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.flowable.ui.common.security.SecurityScope;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class FlowableAuthenticationSecurityScope
implements SecurityScope {
    protected final Authentication authentication;

    public FlowableAuthenticationSecurityScope(Authentication authentication) {
        this.authentication = authentication;
    }

    @Override
    public String getUserId() {
        return this.authentication.getName();
    }

    @Override
    public Set<String> getGroupIds() {
        return this.extractAuthoritiesStartingWith("GROUP_").collect(Collectors.toSet());
    }

    @Override
    public String getTenantId() {
        return this.extractAuthoritiesStartingWith("TENANT_").findFirst().orElse("");
    }

    @Override
    public boolean hasAuthority(String authority) {
        Collection authorities = this.authentication.getAuthorities();
        for (GrantedAuthority grantedAuthority : authorities) {
            if (!grantedAuthority.getAuthority().equals(authority)) continue;
            return true;
        }
        return false;
    }

    protected Stream<String> extractAuthoritiesStartingWith(String prefix) {
        return this.authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).filter(authority -> authority.startsWith(prefix)).map(authority -> authority.substring(prefix.length()));
    }
}

