/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.security;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import org.flowable.ui.common.security.SecurityUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;
import org.springframework.util.Assert;

public class FlowableJwtGrantedAuthoritiesMapper
implements Converter<Jwt, Collection<GrantedAuthority>> {
    protected final String authoritiesAttribute;
    protected final String groupsAttribute;
    protected final Collection<GrantedAuthority> defaultAuthorities;
    protected JwtGrantedAuthoritiesConverter defaultConverter = new JwtGrantedAuthoritiesConverter();

    public FlowableJwtGrantedAuthoritiesMapper(String authoritiesAttribute, String groupsAttribute, Collection<String> defaultAuthorities, Collection<String> defaultGroups) {
        this.authoritiesAttribute = authoritiesAttribute;
        this.groupsAttribute = groupsAttribute;
        this.defaultAuthorities = new LinkedHashSet<GrantedAuthority>();
        if (defaultAuthorities != null) {
            for (String defaultAuthority : defaultAuthorities) {
                this.defaultAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(defaultAuthority));
            }
        }
        if (defaultGroups != null) {
            for (String defaultGroup : defaultGroups) {
                this.defaultAuthorities.add(SecurityUtils.createGroupAuthority(defaultGroup));
            }
        }
    }

    public Collection<GrantedAuthority> convert(Jwt jwt) {
        Object claim;
        Collection authorities = this.defaultConverter.convert(jwt);
        if (StringUtils.isNotBlank((CharSequence)this.authoritiesAttribute)) {
            claim = jwt.getClaim(this.authoritiesAttribute);
            Collection<String> additionalAuthorities = this.asStringCollection(claim);
            for (String authority : additionalAuthorities) {
                authorities.add(new SimpleGrantedAuthority(authority));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.groupsAttribute)) {
            claim = jwt.getClaim(this.groupsAttribute);
            Collection<String> groups = this.asStringCollection(claim);
            for (String group : groups) {
                authorities.add(SecurityUtils.createGroupAuthority(group));
            }
        }
        authorities.addAll(this.defaultAuthorities);
        return authorities;
    }

    protected Collection<String> asStringCollection(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof String) {
            return Arrays.asList(((String)value).split(","));
        }
        return Collections.emptyList();
    }

    public void setDefaultConverter(JwtGrantedAuthoritiesConverter defaultConverter) {
        Assert.notNull((Object)defaultConverter, (String)"defaultConverter must not be null");
        this.defaultConverter = defaultConverter;
    }
}

