/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.task.service.impl.persistence.entity;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.db.SuspensionState;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.identitylink.api.IdentityLink;
import org.flowable.identitylink.service.IdentityLinkServiceConfiguration;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntityManager;
import org.flowable.task.api.DelegationState;
import org.flowable.task.service.InternalTaskAssignmentManager;
import org.flowable.task.service.TaskServiceConfiguration;
import org.flowable.task.service.impl.persistence.CountingTaskEntity;
import org.flowable.task.service.impl.persistence.entity.AbstractTaskServiceVariableScopeEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.util.CountingTaskUtil;
import org.flowable.task.service.impl.util.TaskVariableUtils;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.persistence.entity.VariableInitializingList;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableScopeImpl;
import org.flowable.variable.service.impl.util.CommandContextUtil;

public class TaskEntityImpl
extends AbstractTaskServiceVariableScopeEntity
implements TaskEntity,
CountingTaskEntity,
Serializable {
    public static final String DELETE_REASON_COMPLETED = "completed";
    public static final String DELETE_REASON_DELETED = "deleted";
    private static final long serialVersionUID = 1L;
    protected String owner;
    protected int assigneeUpdatedCount;
    protected String originalAssignee;
    protected String assignee;
    protected DelegationState delegationState;
    protected String parentTaskId;
    protected String name;
    protected String localizedName;
    protected String description;
    protected String localizedDescription;
    protected int priority = 50;
    protected String state;
    protected Date createTime;
    protected Date inProgressStartTime;
    protected String inProgressStartedBy;
    protected Date claimTime;
    protected String claimedBy;
    protected Date suspendedTime;
    protected String suspendedBy;
    protected Date inProgressStartDueDate;
    protected Date dueDate;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected String category;
    protected boolean isIdentityLinksInitialized;
    protected List<IdentityLinkEntity> taskIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
    protected String executionId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String taskDefinitionId;
    protected String scopeId;
    protected String subScopeId;
    protected String scopeType;
    protected String scopeDefinitionId;
    protected String propagatedStageInstanceId;
    protected String taskDefinitionKey;
    protected String formKey;
    protected boolean isCanceled;
    private boolean isCountEnabled;
    protected int variableCount;
    protected int identityLinkCount;
    protected int subTaskCount;
    protected String tenantId = "";
    protected String eventName;
    protected String eventHandlerId;
    protected String tempCompletedBy;
    protected List<VariableInstanceEntity> queryVariables;
    protected List<IdentityLinkEntity> queryIdentityLinks;
    protected boolean forcedUpdate;

    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("assignee", this.assignee);
        persistentState.put("owner", this.owner);
        persistentState.put("name", this.name);
        persistentState.put("priority", this.priority);
        persistentState.put("category", this.category);
        persistentState.put("formKey", this.formKey);
        if (this.executionId != null) {
            persistentState.put("executionId", this.executionId);
        }
        if (this.processInstanceId != null) {
            persistentState.put("processInstanceId", this.processInstanceId);
        }
        if (this.processDefinitionId != null) {
            persistentState.put("processDefinitionId", this.processDefinitionId);
        }
        if (this.taskDefinitionId != null) {
            persistentState.put("taskDefinitionId", this.taskDefinitionId);
        }
        if (this.taskDefinitionKey != null) {
            persistentState.put("taskDefinitionKey", this.taskDefinitionKey);
        }
        if (this.scopeId != null) {
            persistentState.put("scopeId", this.scopeId);
        }
        if (this.subScopeId != null) {
            persistentState.put("subScopeId", this.subScopeId);
        }
        if (this.scopeType != null) {
            persistentState.put("scopeType", this.scopeType);
        }
        if (this.scopeDefinitionId != null) {
            persistentState.put("scopeDefinitionId", this.scopeDefinitionId);
        }
        if (this.propagatedStageInstanceId != null) {
            persistentState.put("propagatedStageInstanceId", this.propagatedStageInstanceId);
        }
        if (this.state != null) {
            persistentState.put("state", this.state);
        }
        if (this.createTime != null) {
            persistentState.put("createTime", this.createTime);
        }
        if (this.inProgressStartTime != null) {
            persistentState.put("inProgressStartTime", this.inProgressStartTime);
        }
        if (this.inProgressStartedBy != null) {
            persistentState.put("inProgressStartedBy", this.inProgressStartedBy);
        }
        if (this.claimTime != null) {
            persistentState.put("claimTime", this.claimTime);
        }
        if (this.claimedBy != null) {
            persistentState.put("claimedBy", this.claimedBy);
        }
        if (this.suspendedTime != null) {
            persistentState.put("suspendedTime", this.suspendedTime);
        }
        if (this.suspendedBy != null) {
            persistentState.put("suspendedBy", this.suspendedBy);
        }
        if (this.description != null) {
            persistentState.put("description", this.description);
        }
        if (this.inProgressStartDueDate != null) {
            persistentState.put("inProgressStartDueDate", this.inProgressStartDueDate);
        }
        if (this.dueDate != null) {
            persistentState.put("dueDate", this.dueDate);
        }
        if (this.parentTaskId != null) {
            persistentState.put("parentTaskId", this.parentTaskId);
        }
        if (this.delegationState != null) {
            persistentState.put("delegationState", this.delegationState);
            persistentState.put("delegationStateString", this.getDelegationStateString());
        }
        persistentState.put("suspensionState", this.suspensionState);
        if (this.forcedUpdate) {
            persistentState.put("forcedUpdate", Boolean.TRUE);
        }
        persistentState.put("isCountEnabled", this.isCountEnabled);
        persistentState.put("variableCount", this.variableCount);
        persistentState.put("identityLinkCount", this.identityLinkCount);
        persistentState.put("subTaskCount", this.subTaskCount);
        return persistentState;
    }

    @Override
    public void forceUpdate() {
        this.forcedUpdate = true;
    }

    protected VariableScopeImpl getParentVariableScope() {
        return this.getTaskServiceConfiguration().getInternalTaskVariableScopeResolver().resolveParentVariableScope(this);
    }

    protected void initializeVariableInstanceBackPointer(VariableInstance variableInstance) {
        variableInstance.setTaskId(this.id);
        if ("cmmn".equals(this.scopeType)) {
            variableInstance.setScopeId(this.scopeId);
            variableInstance.setScopeType(this.scopeType);
            variableInstance.setSubScopeId(this.subScopeId);
        } else {
            variableInstance.setExecutionId(this.executionId);
            variableInstance.setProcessInstanceId(this.processInstanceId);
            variableInstance.setProcessDefinitionId(this.processDefinitionId);
        }
    }

    protected void addLoggingSessionInfo(ObjectNode loggingNode) {
    }

    protected List<VariableInstanceEntity> loadVariableInstances() {
        return this.getVariableServiceConfiguration().getVariableService().createInternalVariableInstanceQuery().taskId(this.id).list();
    }

    protected VariableInstanceEntity createVariableInstance(String variableName, Object value) {
        VariableInstanceEntity variableInstance = super.createVariableInstance(variableName, value);
        CountingTaskUtil.handleInsertVariableInstanceEntityCount(variableInstance, this.getTaskServiceConfiguration());
        return variableInstance;
    }

    protected void deleteVariableInstanceForExplicitUserCall(VariableInstanceEntity variableInstance) {
        super.deleteVariableInstanceForExplicitUserCall(variableInstance);
        CountingTaskUtil.handleDeleteVariableInstanceEntityCount(variableInstance, true, this.getTaskServiceConfiguration());
    }

    @Override
    public Set<IdentityLink> getCandidates() {
        HashSet<IdentityLink> potentialOwners = new HashSet<IdentityLink>();
        for (IdentityLinkEntity identityLinkEntity : this.getIdentityLinks()) {
            if (!"candidate".equals(identityLinkEntity.getType())) continue;
            potentialOwners.add((IdentityLink)identityLinkEntity);
        }
        return potentialOwners;
    }

    @Override
    public List<IdentityLinkEntity> getIdentityLinks() {
        if (!this.isIdentityLinksInitialized) {
            this.taskIdentityLinkEntities = this.queryIdentityLinks == null ? this.getIdentityLinkServiceConfiguration().getIdentityLinkEntityManager().findIdentityLinksByTaskId(this.id) : this.queryIdentityLinks;
            this.isIdentityLinksInitialized = true;
        }
        return this.taskIdentityLinkEntities;
    }

    @Override
    public void setName(String taskName) {
        this.name = taskName;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setAssignee(String assignee) {
        this.originalAssignee = this.assignee;
        this.assignee = assignee;
        ++this.assigneeUpdatedCount;
    }

    @Override
    public void setAssigneeValue(String assignee) {
        InternalTaskAssignmentManager taskAssignmentManager = this.getTaskAssignmentManager();
        if (taskAssignmentManager != null) {
            taskAssignmentManager.changeAssignee(this, assignee);
        } else {
            this.originalAssignee = this.assignee;
            this.assignee = assignee;
            ++this.assigneeUpdatedCount;
        }
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public void setOwnerValue(String owner) {
        InternalTaskAssignmentManager taskAssignmentManager = this.getTaskAssignmentManager();
        if (taskAssignmentManager != null) {
            taskAssignmentManager.changeOwner(this, owner);
        } else {
            this.owner = owner;
        }
    }

    @Override
    public void setInProgressStartDueDate(Date inProgressStartDueDate) {
        this.inProgressStartDueDate = inProgressStartDueDate;
    }

    @Override
    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public void addUserIdentityLink(String userId, String identityLinkType) {
        IdentityLinkEntityManager identityLinkEntityManager = this.getIdentityLinkServiceConfiguration().getIdentityLinkEntityManager();
        IdentityLinkEntity identityLink = identityLinkEntityManager.addTaskIdentityLink(this.id, userId, null, identityLinkType);
        InternalTaskAssignmentManager taskAssignmentManager = this.getTaskAssignmentManager();
        if (taskAssignmentManager != null) {
            taskAssignmentManager.addUserIdentityLink(this, (IdentityLink)identityLink);
        }
    }

    @Override
    public void addGroupIdentityLink(String groupId, String identityLinkType) {
        IdentityLinkEntityManager identityLinkEntityManager = this.getIdentityLinkServiceConfiguration().getIdentityLinkEntityManager();
        IdentityLinkEntity identityLink = identityLinkEntityManager.addTaskIdentityLink(this.id, null, groupId, identityLinkType);
        InternalTaskAssignmentManager taskAssignmentManager = this.getTaskAssignmentManager();
        if (taskAssignmentManager != null) {
            taskAssignmentManager.addGroupIdentityLink(this, (IdentityLink)identityLink);
        }
    }

    @Override
    public void deleteCandidateUser(String userId) {
        this.deleteUserIdentityLink(userId, "candidate");
    }

    @Override
    public void deleteCandidateGroup(String groupId) {
        this.deleteGroupIdentityLink(groupId, "candidate");
    }

    @Override
    public void deleteUserIdentityLink(String userId, String identityLinkType) {
        IdentityLinkEntityManager identityLinkEntityManager = this.getIdentityLinkServiceConfiguration().getIdentityLinkEntityManager();
        List identityLinkEntities = identityLinkEntityManager.deleteTaskIdentityLink(this.id, this.getIdentityLinks(), userId, null, identityLinkType);
        InternalTaskAssignmentManager taskAssignmentManager = this.getTaskAssignmentManager();
        if (taskAssignmentManager != null) {
            for (IdentityLinkEntity identityLink : identityLinkEntities) {
                taskAssignmentManager.deleteUserIdentityLink(this, (IdentityLink)identityLink);
            }
        }
    }

    @Override
    public void deleteGroupIdentityLink(String groupId, String identityLinkType) {
        IdentityLinkEntityManager identityLinkEntityManager = this.getIdentityLinkServiceConfiguration().getIdentityLinkEntityManager();
        List identityLinkEntities = identityLinkEntityManager.deleteTaskIdentityLink(this.id, this.getIdentityLinks(), null, groupId, identityLinkType);
        InternalTaskAssignmentManager taskAssignmentManager = this.getTaskAssignmentManager();
        if (taskAssignmentManager != null) {
            for (IdentityLinkEntity identityLink : identityLinkEntities) {
                taskAssignmentManager.deleteGroupIdentityLink(this, (IdentityLink)identityLink);
            }
        }
    }

    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    @Override
    public String getFormKey() {
        return this.formKey;
    }

    @Override
    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    protected boolean isPropagateToHistoricVariable() {
        return true;
    }

    protected VariableInstanceEntity getSpecificVariable(String variableName) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            throw new FlowableException("lazy loading outside command context for " + String.valueOf(this));
        }
        return this.getVariableServiceConfiguration().getVariableService().createInternalVariableInstanceQuery().taskId(this.id).name(variableName).singleResult();
    }

    protected List<VariableInstanceEntity> getSpecificVariables(Collection<String> variableNames) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            throw new FlowableException("lazy loading outside command context for " + String.valueOf(this));
        }
        return this.getVariableServiceConfiguration().getVariableService().createInternalVariableInstanceQuery().taskId(this.id).names(variableNames).list();
    }

    @Override
    public String getName() {
        if (this.localizedName != null && this.localizedName.length() > 0) {
            return this.localizedName;
        }
        return this.name;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public void setLocalizedName(String localizedName) {
        this.localizedName = localizedName;
    }

    @Override
    public String getDescription() {
        if (this.localizedDescription != null && this.localizedDescription.length() > 0) {
            return this.localizedDescription;
        }
        return this.description;
    }

    public String getLocalizedDescription() {
        return this.localizedDescription;
    }

    public void setLocalizedDescription(String localizedDescription) {
        this.localizedDescription = localizedDescription;
    }

    @Override
    public Date getInProgressStartDueDate() {
        return this.inProgressStartDueDate;
    }

    @Override
    public Date getDueDate() {
        return this.dueDate;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public void setState(String state) {
        this.state = state;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public Date getInProgressStartTime() {
        return this.inProgressStartTime;
    }

    @Override
    public void setInProgressStartTime(Date inProgressStartTime) {
        this.inProgressStartTime = inProgressStartTime;
    }

    @Override
    public String getInProgressStartedBy() {
        return this.inProgressStartedBy;
    }

    @Override
    public void setInProgressStartedBy(String inProgressStartedBy) {
        this.inProgressStartedBy = inProgressStartedBy;
    }

    @Override
    public Date getClaimTime() {
        return this.claimTime;
    }

    @Override
    public void setClaimTime(Date claimTime) {
        this.claimTime = claimTime;
    }

    @Override
    public String getClaimedBy() {
        return this.claimedBy;
    }

    @Override
    public void setClaimedBy(String claimedBy) {
        this.claimedBy = claimedBy;
    }

    @Override
    public Date getSuspendedTime() {
        return this.suspendedTime;
    }

    @Override
    public void setSuspendedTime(Date suspendedTime) {
        this.suspendedTime = suspendedTime;
    }

    @Override
    public String getSuspendedBy() {
        return this.suspendedBy;
    }

    @Override
    public void setSuspendedBy(String suspendedBy) {
        this.suspendedBy = suspendedBy;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public String getTaskDefinitionId() {
        return this.taskDefinitionId;
    }

    @Override
    public void setTaskDefinitionId(String taskDefinitionId) {
        this.taskDefinitionId = taskDefinitionId;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    @Override
    public void setScopeId(String scopeId) {
        this.scopeId = scopeId;
    }

    public String getSubScopeId() {
        return this.subScopeId;
    }

    @Override
    public void setSubScopeId(String subScopeId) {
        this.subScopeId = subScopeId;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    @Override
    public void setScopeType(String scopeType) {
        this.scopeType = scopeType;
    }

    public String getScopeDefinitionId() {
        return this.scopeDefinitionId;
    }

    @Override
    public void setScopeDefinitionId(String scopeDefinitionId) {
        this.scopeDefinitionId = scopeDefinitionId;
    }

    @Override
    public void setPropagatedStageInstanceId(String propagatedStageInstanceId) {
        this.propagatedStageInstanceId = propagatedStageInstanceId;
    }

    public String getPropagatedStageInstanceId() {
        return this.propagatedStageInstanceId;
    }

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    public String getOriginalAssignee() {
        if (this.assigneeUpdatedCount > 1) {
            return this.originalAssignee;
        }
        return this.assignee;
    }

    @Override
    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    @Override
    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    @Override
    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @Override
    public String getEventHandlerId() {
        return this.eventHandlerId;
    }

    @Override
    public void setEventHandlerId(String eventHandlerId) {
        this.eventHandlerId = eventHandlerId;
    }

    @Override
    public String getTempCompletedBy() {
        return this.tempCompletedBy;
    }

    @Override
    public void setTempCompletedBy(String tempCompletedBy) {
        this.tempCompletedBy = tempCompletedBy;
    }

    @Override
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public DelegationState getDelegationState() {
        return this.delegationState;
    }

    @Override
    public void addCandidateUser(String userId) {
        IdentityLinkEntityManager identityLinkEntityManager = this.getIdentityLinkServiceConfiguration().getIdentityLinkEntityManager();
        IdentityLinkEntity identityLink = identityLinkEntityManager.addCandidateUser(this.id, userId);
        InternalTaskAssignmentManager taskAssignmentManager = this.getTaskAssignmentManager();
        if (taskAssignmentManager != null) {
            taskAssignmentManager.addCandidateUser(this, (IdentityLink)identityLink);
        }
    }

    @Override
    public void addCandidateUsers(Collection<String> candidateUsers) {
        IdentityLinkEntityManager identityLinkEntityManager = this.getIdentityLinkServiceConfiguration().getIdentityLinkEntityManager();
        List identityLinks = identityLinkEntityManager.addCandidateUsers(this.id, candidateUsers);
        InternalTaskAssignmentManager taskAssignmentManager = this.getTaskAssignmentManager();
        if (taskAssignmentManager != null) {
            taskAssignmentManager.addCandidateUsers(this, this.convertToIdentityLinks(identityLinks));
        }
    }

    @Override
    public void addCandidateGroup(String groupId) {
        IdentityLinkEntityManager identityLinkEntityManager = this.getIdentityLinkServiceConfiguration().getIdentityLinkEntityManager();
        IdentityLinkEntity identityLink = identityLinkEntityManager.addCandidateGroup(this.id, groupId);
        InternalTaskAssignmentManager taskAssignmentManager = this.getTaskAssignmentManager();
        if (taskAssignmentManager != null) {
            taskAssignmentManager.addCandidateGroup(this, (IdentityLink)identityLink);
        }
    }

    @Override
    public void addCandidateGroups(Collection<String> candidateGroups) {
        IdentityLinkEntityManager identityLinkEntityManager = this.getIdentityLinkServiceConfiguration().getIdentityLinkEntityManager();
        List identityLinks = identityLinkEntityManager.addCandidateGroups(this.id, candidateGroups);
        InternalTaskAssignmentManager taskAssignmentManager = this.getTaskAssignmentManager();
        if (taskAssignmentManager != null) {
            taskAssignmentManager.addCandidateGroups(this, this.convertToIdentityLinks(identityLinks));
        }
    }

    protected List<IdentityLink> convertToIdentityLinks(List<IdentityLinkEntity> identityLinks) {
        ArrayList<IdentityLinkEntity> identityLinkObjects = new ArrayList<IdentityLinkEntity>(identityLinks);
        return identityLinkObjects;
    }

    protected InternalTaskAssignmentManager getTaskAssignmentManager() {
        TaskServiceConfiguration taskServiceConfiguration = this.getTaskServiceConfiguration();
        if (taskServiceConfiguration != null) {
            return taskServiceConfiguration.getInternalTaskAssignmentManager();
        }
        return null;
    }

    protected TaskServiceConfiguration getTaskServiceConfiguration() {
        return (TaskServiceConfiguration)((Object)this.getTaskEngineConfiguration().getServiceConfigurations().get("cfg.taskService"));
    }

    protected IdentityLinkServiceConfiguration getIdentityLinkServiceConfiguration() {
        return (IdentityLinkServiceConfiguration)this.getTaskEngineConfiguration().getServiceConfigurations().get("cfg.identityLinkService");
    }

    protected VariableServiceConfiguration getVariableServiceConfiguration() {
        return (VariableServiceConfiguration)this.getTaskEngineConfiguration().getServiceConfigurations().get("cfg.variableService");
    }

    protected AbstractEngineConfiguration getTaskEngineConfiguration() {
        Map engineConfigurations = CommandContextUtil.getCommandContext().getEngineConfigurations();
        AbstractEngineConfiguration engineConfiguration = null;
        if ("cmmn".equals(this.scopeType)) {
            engineConfiguration = (AbstractEngineConfiguration)engineConfigurations.get("cfg.cmmnEngine");
        } else {
            engineConfiguration = (AbstractEngineConfiguration)engineConfigurations.get("cfg.processEngine");
            if (engineConfiguration == null) {
                engineConfiguration = (AbstractEngineConfiguration)engineConfigurations.get("cfg.cmmnEngine");
            }
        }
        return engineConfiguration;
    }

    public void setDelegationState(DelegationState delegationState) {
        this.delegationState = delegationState;
    }

    public String getDelegationStateString() {
        return this.delegationState != null ? this.delegationState.toString() : null;
    }

    public void setDelegationStateString(String delegationStateString) {
        this.delegationState = delegationStateString != null ? (DelegationState)DelegationState.valueOf(DelegationState.class, (String)delegationStateString) : null;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public String getParentTaskId() {
        return this.parentTaskId;
    }

    @Override
    public Map<String, VariableInstanceEntity> getVariableInstanceEntities() {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances;
    }

    @Override
    public int getSuspensionState() {
        return this.suspensionState;
    }

    @Override
    public void setSuspensionState(int suspensionState) {
        this.suspensionState = suspensionState;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode() || "suspended".equals(this.state);
    }

    public Map<String, Object> getTaskLocalVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (VariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() == null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    public Map<String, Object> getProcessVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (VariableInstanceEntity variableInstance : this.queryVariables) {
                if (this.getProcessInstanceId() == null || !this.getProcessInstanceId().equals(variableInstance.getProcessInstanceId()) || variableInstance.getTaskId() != null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    public Map<String, Object> getCaseVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (VariableInstanceEntity variableInstance : this.queryVariables) {
                if (!TaskVariableUtils.isCaseRelated((ValueFields)variableInstance) || !variableInstance.getScopeId().equals(this.getScopeId()) || variableInstance.getTaskId() != null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public List<VariableInstanceEntity> getQueryVariables() {
        if (this.queryVariables == null && Context.getCommandContext() != null) {
            this.queryVariables = new VariableInitializingList();
        }
        return this.queryVariables;
    }

    public void setQueryVariables(List<VariableInstanceEntity> queryVariables) {
        this.queryVariables = queryVariables;
    }

    public List<IdentityLinkEntity> getQueryIdentityLinks() {
        if (this.queryIdentityLinks == null) {
            this.queryIdentityLinks = new LinkedList<IdentityLinkEntity>();
        }
        return this.queryIdentityLinks;
    }

    public void setQueryIdentityLinks(List<IdentityLinkEntity> identityLinks) {
        this.queryIdentityLinks = identityLinks;
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        strb.append("Task[");
        strb.append("id=").append(this.id);
        strb.append(", key=").append(this.taskDefinitionKey);
        strb.append(", name=").append(this.name);
        if (this.executionId != null) {
            strb.append(", processInstanceId=").append(this.processInstanceId).append(", executionId=").append(this.executionId).append(", processDefinitionId=").append(this.processDefinitionId);
        } else if (this.scopeId != null) {
            strb.append(", scopeInstanceId=").append(this.scopeId).append(", subScopeId=").append(this.subScopeId).append(", scopeDefinitionId=").append(this.scopeDefinitionId);
        }
        strb.append("]");
        return strb.toString();
    }

    @Override
    public boolean isCountEnabled() {
        return this.isCountEnabled;
    }

    public boolean getIsCountEnabled() {
        return this.isCountEnabled;
    }

    @Override
    public void setCountEnabled(boolean isCountEnabled) {
        this.isCountEnabled = isCountEnabled;
    }

    public void setIsCountEnabled(boolean isCountEnabled) {
        this.isCountEnabled = isCountEnabled;
    }

    @Override
    public void setVariableCount(int variableCount) {
        this.variableCount = variableCount;
    }

    @Override
    public int getVariableCount() {
        return this.variableCount;
    }

    @Override
    public void setIdentityLinkCount(int identityLinkCount) {
        this.identityLinkCount = identityLinkCount;
    }

    @Override
    public int getIdentityLinkCount() {
        return this.identityLinkCount;
    }

    @Override
    public int getSubTaskCount() {
        return this.subTaskCount;
    }

    @Override
    public void setSubTaskCount(int subTaskCount) {
        this.subTaskCount = subTaskCount;
    }

    @Override
    public boolean isIdentityLinksInitialized() {
        return this.isIdentityLinksInitialized;
    }
}

