/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.actuate.endpoint;

import java.io.InputStream;
import org.flowable.bpmn.BpmnAutoLayout;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.image.impl.DefaultProcessDiagramGenerator;
import org.flowable.spring.boot.actuate.endpoint.ProcessEngineEndpoint;
import org.springframework.boot.actuate.endpoint.web.annotation.EndpointWebExtension;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;

@EndpointWebExtension(endpoint=ProcessEngineEndpoint.class)
public class ProcessEngineMvcEndpoint {
    private final RepositoryService repositoryService;

    public ProcessEngineMvcEndpoint(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @GetMapping(value={"/processes/{processDefinitionKey:.*}"}, produces={"image/jpeg"})
    @ResponseBody
    public ResponseEntity processDefinitionDiagram(@PathVariable String processDefinitionKey) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).latestVersion().singleResult();
        if (processDefinition == null) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
        }
        DefaultProcessDiagramGenerator processDiagramGenerator = new DefaultProcessDiagramGenerator();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
        if (bpmnModel.getLocationMap().size() == 0) {
            BpmnAutoLayout autoLayout = new BpmnAutoLayout(bpmnModel);
            autoLayout.execute();
        }
        InputStream is = processDiagramGenerator.generateJpgDiagram(bpmnModel);
        return ResponseEntity.ok((Object)new InputStreamResource(is));
    }
}

